/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.TemplateParserConstants;
import com.google.template.soy.soyparse.TemplateParserTokenManager;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateParser
implements TemplateParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern START_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("^\\s*?(\\n|\\r)\\s*");
    private static final Pattern END_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*$");
    private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("(?<=\\S)\\s*?(\\n|\\r)\\s*(?=\\S)");
    private IdGenerator nodeIdGen;
    private String sourcePath = SourceLocation.UNKNOWN.getSourcePath();
    private int lineNumOffset;
    private static final Map<String, String> SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT = ImmutableMap.builder().put((Object)"sp", (Object)" ").put((Object)"nil", (Object)"").put((Object)"\\n", (Object)"\n").put((Object)"\\r", (Object)"\r").put((Object)"\\t", (Object)"\t").put((Object)"lb", (Object)"{").put((Object)"rb", (Object)"}").build();
    public TemplateParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[36];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TemplateParser(Reader input, IdGenerator nodeIdGen) {
        this(input);
        this.nodeIdGen = nodeIdGen;
    }

    public TemplateParser(String input, String sourcePath, int templateBodyStartLine, IdGenerator nodeIdGen) {
        this(new StringReader(input), nodeIdGen);
        this.sourcePath = sourcePath;
        this.lineNumOffset = templateBodyStartLine - 1;
    }

    public List<SoyNode.StandaloneNode> parseTemplateBody() throws SoySyntaxException, TokenMgrError, ParseException {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        return this.TemplateBodyInput();
    }

    private <T extends SoyNode> T setLocation(T node, int lineNum) {
        node.setLocation(new SourceLocation(this.sourcePath, lineNum + this.lineNumOffset));
        return node;
    }

    private final SourceItemInfo<Void> SoyTagOpen() throws ParseException {
        Token tagOpen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                tagOpen = this.jj_consume_token(5);
                break;
            }
            case 6: {
                tagOpen = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SourceItemInfo<Object>(null, tagOpen.beginLine);
    }

    private final void RegSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void SelfEndingSoyTagClose() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final String CmdText() throws ParseException {
        List<String> cmdTextParts = this.CmdTextParts();
        return Joiner.on((String)"").join(cmdTextParts);
    }

    private final List<String> CmdTextParts() throws ParseException {
        StringBuilder currCmdTextPartSb;
        ArrayList cmdTextParts;
        block21: {
            cmdTextParts = Lists.newArrayList();
            currCmdTextPartSb = new StringBuilder();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    String freakCmdName = this.AnyCmdName();
                    currCmdTextPartSb.append(freakCmdName);
                    this.jj_consume_token(55);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: 
                    case 57: 
                    case 59: 
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block21;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        Token cmdTextChar = this.jj_consume_token(59);
                        currCmdTextPartSb.append(cmdTextChar.image);
                        continue block15;
                    }
                    case 60: {
                        Token cmdTextChar = this.jj_consume_token(60);
                        currCmdTextPartSb.append(cmdTextChar.image);
                        continue block15;
                    }
                    case 56: 
                    case 57: {
                        Token cmdTextSpecialPart;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 56: {
                                cmdTextSpecialPart = this.jj_consume_token(56);
                                break;
                            }
                            case 57: {
                                cmdTextSpecialPart = this.jj_consume_token(57);
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (currCmdTextPartSb.length() > 0) {
                            cmdTextParts.add(currCmdTextPartSb.toString());
                            currCmdTextPartSb = new StringBuilder();
                        }
                        cmdTextParts.add(cmdTextSpecialPart.image);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (currCmdTextPartSb.length() > 0) {
            cmdTextParts.add(currCmdTextPartSb.toString());
            currCmdTextPartSb = new StringBuilder();
        }
        int n = cmdTextParts.size();
        for (int i = 0; i < n; ++i) {
            String cmdTextPart = (String)cmdTextParts.get(i);
            if (i == 0) {
                cmdTextPart = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)cmdTextPart);
            }
            if (i == n - 1) {
                cmdTextPart = CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)cmdTextPart);
            }
            cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
            cmdTextParts.set(i, cmdTextPart);
        }
        return cmdTextParts;
    }

    private final String AnyCmdName() throws ParseException {
        Token cmdName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                cmdName = this.jj_consume_token(9);
                break;
            }
            case 10: {
                cmdName = this.jj_consume_token(10);
                break;
            }
            case 11: {
                cmdName = this.jj_consume_token(11);
                break;
            }
            case 12: {
                cmdName = this.jj_consume_token(12);
                break;
            }
            case 13: {
                cmdName = this.jj_consume_token(13);
                break;
            }
            case 14: {
                cmdName = this.jj_consume_token(14);
                break;
            }
            case 15: {
                cmdName = this.jj_consume_token(15);
                break;
            }
            case 16: {
                cmdName = this.jj_consume_token(16);
                break;
            }
            case 17: {
                cmdName = this.jj_consume_token(17);
                break;
            }
            case 18: {
                cmdName = this.jj_consume_token(18);
                break;
            }
            case 19: {
                cmdName = this.jj_consume_token(19);
                break;
            }
            case 24: {
                cmdName = this.jj_consume_token(24);
                break;
            }
            case 25: {
                cmdName = this.jj_consume_token(25);
                break;
            }
            case 26: {
                cmdName = this.jj_consume_token(26);
                break;
            }
            case 27: {
                cmdName = this.jj_consume_token(27);
                break;
            }
            case 28: {
                cmdName = this.jj_consume_token(28);
                break;
            }
            case 29: {
                cmdName = this.jj_consume_token(29);
                break;
            }
            case 30: {
                cmdName = this.jj_consume_token(30);
                break;
            }
            case 31: {
                cmdName = this.jj_consume_token(31);
                break;
            }
            case 32: {
                cmdName = this.jj_consume_token(32);
                break;
            }
            case 43: {
                cmdName = this.jj_consume_token(43);
                break;
            }
            case 44: {
                cmdName = this.jj_consume_token(44);
                break;
            }
            case 33: {
                cmdName = this.jj_consume_token(33);
                break;
            }
            case 34: {
                cmdName = this.jj_consume_token(34);
                break;
            }
            case 35: {
                cmdName = this.jj_consume_token(35);
                break;
            }
            case 36: {
                cmdName = this.jj_consume_token(36);
                break;
            }
            case 37: {
                cmdName = this.jj_consume_token(37);
                break;
            }
            case 38: {
                cmdName = this.jj_consume_token(38);
                break;
            }
            case 39: {
                cmdName = this.jj_consume_token(39);
                break;
            }
            case 40: {
                cmdName = this.jj_consume_token(40);
                break;
            }
            case 41: {
                cmdName = this.jj_consume_token(41);
                break;
            }
            case 42: {
                cmdName = this.jj_consume_token(42);
                break;
            }
            case 45: {
                cmdName = this.jj_consume_token(45);
                break;
            }
            case 46: {
                cmdName = this.jj_consume_token(46);
                break;
            }
            case 47: {
                cmdName = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cmdName.image;
    }

    private final SourceItemInfo<String> BasicRawText() throws ParseException {
        StringBuilder basicRawTextSb = new StringBuilder();
        Token basicRawTextChar = this.jj_consume_token(75);
        basicRawTextSb.append(basicRawTextChar.image);
        boolean isStartOfTemplate = basicRawTextChar.beginLine == 1 && basicRawTextChar.beginColumn == 1;
        int lineNum = basicRawTextChar.beginLine;
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            basicRawTextChar = this.jj_consume_token(75);
            basicRawTextSb.append(basicRawTextChar.image);
        }
        String basicRawText = basicRawTextSb.toString();
        if (isStartOfTemplate) {
            basicRawText = CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)basicRawText);
        }
        basicRawText = START_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");
        int numSpaceCharsRemovedFromFront = basicRawTextSb.length() - basicRawText.length();
        for (int i = 0; i < numSpaceCharsRemovedFromFront; ++i) {
            char ch = basicRawTextSb.charAt(i);
            if (ch == '\r') {
                if (i + 1 != numSpaceCharsRemovedFromFront && basicRawTextSb.charAt(i + 1) == '\n') continue;
                ++lineNum;
                continue;
            }
            if (ch != '\n') continue;
            ++lineNum;
        }
        basicRawText = END_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");
        Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText);
        StringBuffer basicRawTextWithoutNewlinesSb = new StringBuffer(basicRawText.length());
        while (matcher.find()) {
            char charBefore = basicRawText.charAt(matcher.start() - 1);
            char charAfter = basicRawText.charAt(matcher.end());
            matcher.appendReplacement(basicRawTextWithoutNewlinesSb, charBefore == '>' || charAfter == '<' ? "" : " ");
        }
        matcher.appendTail(basicRawTextWithoutNewlinesSb);
        return new SourceItemInfo<String>(basicRawTextWithoutNewlinesSb.toString(), lineNum);
    }

    public final void MaybeWhitespace(String errorMessage) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                SourceItemInfo<String> basicRawText = this.BasicRawText();
                if (((String)basicRawText.parsedContent).trim().length() == 0) break;
                throw new ParseException(errorMessage + " Found on line " + (basicRawText.lineNum + this.lineNumOffset));
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
    }

    private final SourceItemInfo<String> LiteralRawText() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(16);
        this.RegSoyTagClose();
        Token literalRawTextContent = this.jj_consume_token(72);
        return new SourceItemInfo<String>(literalRawTextContent.image, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> SpecialCharRawText() throws ParseException {
        this.SoyTagOpen();
        SourceItemInfo<String> specialCharCmdName = this.SpecialCharCmdName();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT.get(specialCharCmdName.parsedContent), specialCharCmdName.lineNum);
    }

    private final SourceItemInfo<String> SpecialCharCmdName() throws ParseException {
        Token specialCharCmdName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                specialCharCmdName = this.jj_consume_token(9);
                break;
            }
            case 10: {
                specialCharCmdName = this.jj_consume_token(10);
                break;
            }
            case 11: {
                specialCharCmdName = this.jj_consume_token(11);
                break;
            }
            case 12: {
                specialCharCmdName = this.jj_consume_token(12);
                break;
            }
            case 13: {
                specialCharCmdName = this.jj_consume_token(13);
                break;
            }
            case 14: {
                specialCharCmdName = this.jj_consume_token(14);
                break;
            }
            case 15: {
                specialCharCmdName = this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SourceItemInfo<String>(specialCharCmdName.image, specialCharCmdName.beginLine);
    }

    private final SourceItemInfo<String> MsgTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(18);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndMsgTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(19);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> PluralTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(20);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndPluralTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(21);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> SelectTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(22);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndSelectTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(23);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<List<String>> PrintTag() throws ParseException {
        ArrayList printTagParts = Lists.newArrayList();
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(24);
            this.jj_consume_token(54);
            printTagParts.add("print");
        }
        List<String> cmdTextParts = this.CmdTextParts();
        printTagParts.addAll(cmdTextParts);
        this.RegSoyTagClose();
        return new SourceItemInfo<List<String>>(printTagParts, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> CssTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(25);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> LetTagSelfEnding() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(26);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> LetTagNotSelfEnding() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(26);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndLetTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(27);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> IfTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(28);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> ElseifTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(29);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<Void> ElseTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(30);
        this.RegSoyTagClose();
        return tagOpen;
    }

    private final void EndIfTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(31);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> SwitchTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(32);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndSwitchTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(33);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> ForeachTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(34);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<Void> IfemptyTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(35);
        this.RegSoyTagClose();
        return tagOpen;
    }

    private final void EndForeachTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(36);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> ForTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(37);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndForTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(38);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<List<String>> AnyCallTagSelfEnding() throws ParseException {
        ArrayList callTagParts = Lists.newArrayList();
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        Token cmdName = this.jj_consume_token(39);
        callTagParts.add(cmdName.image);
        this.jj_consume_token(54);
        List<String> cmdTextParts = this.CmdTextParts();
        callTagParts.addAll(cmdTextParts);
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<List<String>>(callTagParts, tagOpen.lineNum);
    }

    private final SourceItemInfo<List<String>> AnyCallTagNotSelfEnding() throws ParseException {
        ArrayList callTagParts = Lists.newArrayList();
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        Token cmdName = this.jj_consume_token(39);
        callTagParts.add(cmdName.image);
        this.jj_consume_token(54);
        List<String> cmdTextParts = this.CmdTextParts();
        callTagParts.addAll(cmdTextParts);
        this.RegSoyTagClose();
        return new SourceItemInfo<List<String>>(callTagParts, tagOpen.lineNum);
    }

    private final boolean EndAnyCallTag() throws ParseException {
        this.SoyTagOpen();
        Token cmdName = this.jj_consume_token(40);
        this.RegSoyTagClose();
        return cmdName.image.equals("/call");
    }

    private final SourceItemInfo<String> ParamTagSelfEnding() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(41);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.SelfEndingSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<String> ParamTagNotSelfEnding() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(41);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final void EndParamTag() throws ParseException {
        this.SoyTagOpen();
        this.jj_consume_token(42);
        this.RegSoyTagClose();
    }

    private final SourceItemInfo<String> CaseTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(43);
        this.jj_consume_token(54);
        String cmdText = this.CmdText();
        this.RegSoyTagClose();
        return new SourceItemInfo<String>(cmdText, tagOpen.lineNum);
    }

    private final SourceItemInfo<Void> DefaultTag() throws ParseException {
        SourceItemInfo<Void> tagOpen = this.SoyTagOpen();
        this.jj_consume_token(44);
        this.RegSoyTagClose();
        return tagOpen;
    }

    private final List<SoyNode.StandaloneNode> TemplateBodyInput() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(0);
        if (this.token_source.curLexState == 2) {
            throw new ParseException("At end of template, found comment block that is never closed.");
        }
        return templateBlock;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException, SoySyntaxException {
        ArrayList templateBlock = Lists.newArrayList();
        block3: while (this.jj_2_3(Integer.MAX_VALUE)) {
            if (this.jj_2_4(Integer.MAX_VALUE)) {
                RawTextNode contiguousRawText = this.ContiguousRawText();
                if (contiguousRawText == null) continue;
                templateBlock.add(contiguousRawText);
                continue;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    SoyNode.StatementNode stmt = this.Stmt();
                    templateBlock.add(stmt);
                    continue block3;
                }
            }
            this.jj_la1[10] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return templateBlock;
    }

    private final RawTextNode ContiguousRawText() throws ParseException {
        StringBuilder sb = new StringBuilder();
        int lineNum = -1;
        block6: do {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: {
                    SourceItemInfo<String> basicRawText = this.BasicRawText();
                    if (((String)basicRawText.parsedContent).length() == 0) continue block6;
                    if (lineNum == -1) {
                        lineNum = basicRawText.lineNum;
                    }
                    sb.append((String)basicRawText.parsedContent);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    if (this.jj_2_5(Integer.MAX_VALUE)) {
                        SourceItemInfo<String> literalRawText = this.LiteralRawText();
                        if (lineNum == -1) {
                            lineNum = literalRawText.lineNum;
                        }
                        sb.append((String)literalRawText.parsedContent);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: {
                            SourceItemInfo<String> specialCharRawText = this.SpecialCharRawText();
                            if (lineNum == -1) {
                                lineNum = specialCharRawText.lineNum;
                            }
                            sb.append((String)specialCharRawText.parsedContent);
                            break block0;
                        }
                    }
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_6(Integer.MAX_VALUE));
        return sb.length() > 0 ? this.setLocation(new RawTextNode(this.nodeIdGen.genId(), sb.toString()), lineNum) : null;
    }

    private final void ContiguousRawTextLookaheadHelper() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                if (this.jj_2_7(Integer.MAX_VALUE)) {
                    this.SoyTagOpen();
                    this.jj_consume_token(16);
                    this.RegSoyTagClose();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        this.SpecialCharRawText();
                        break block0;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final SoyNode.StatementNode Stmt() throws ParseException, SoySyntaxException {
        AbstractSoyNode stmt;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            stmt = this.MsgStmt();
        } else if (this.jj_2_9(Integer.MAX_VALUE)) {
            stmt = this.PrintStmt();
        } else if (this.jj_2_10(Integer.MAX_VALUE)) {
            stmt = this.CssStmt();
        } else if (this.jj_2_11(Integer.MAX_VALUE)) {
            stmt = this.LetStmt();
        } else if (this.jj_2_12(Integer.MAX_VALUE)) {
            stmt = this.IfStmt();
        } else if (this.jj_2_13(Integer.MAX_VALUE)) {
            stmt = this.SwitchStmt();
        } else if (this.jj_2_14(Integer.MAX_VALUE)) {
            stmt = this.ForeachStmt();
        } else if (this.jj_2_15(Integer.MAX_VALUE)) {
            stmt = this.ForStmt();
        } else if (this.jj_2_16(Integer.MAX_VALUE)) {
            stmt = this.CallStmt();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return stmt;
    }

    private final void StmtLookaheadHelper() throws ParseException {
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            this.PrintStmtLookaheadHelper();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    this.SoyTagOpen();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: {
                            this.jj_consume_token(18);
                            break;
                        }
                        case 25: {
                            this.jj_consume_token(25);
                            break;
                        }
                        case 26: {
                            this.jj_consume_token(26);
                            break;
                        }
                        case 28: {
                            this.jj_consume_token(28);
                            break;
                        }
                        case 32: {
                            this.jj_consume_token(32);
                            break;
                        }
                        case 34: {
                            this.jj_consume_token(34);
                            break;
                        }
                        case 37: {
                            this.jj_consume_token(37);
                            break;
                        }
                        case 39: {
                            this.jj_consume_token(39);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(54);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final MsgNode MsgStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> cmdText = this.MsgTag();
        MsgNode msgNode = this.setLocation(new MsgNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        List<SoyNode.StandaloneNode> templateBlockForMsg = this.TemplateBlockForMsg();
        msgNode.addChildren(templateBlockForMsg);
        this.EndMsgTag();
        return msgNode;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException, SoySyntaxException {
        ArrayList templateBlock = Lists.newArrayList();
        if (this.jj_2_20(Integer.MAX_VALUE)) {
            this.MaybeWhitespace("No message content is allowed before a 'plural' block.");
            MsgPluralNode msgPlural = this.MsgPlural();
            templateBlock.add(msgPlural);
            this.MaybeWhitespace("No message content is allowed after a 'plural' block.");
        } else if (this.jj_2_21(Integer.MAX_VALUE)) {
            this.MaybeWhitespace("No message content is allowed before a 'select' block.");
            MsgSelectNode msgSelect = this.MsgSelect();
            templateBlock.add(msgSelect);
            this.MaybeWhitespace("No message content is allowed after a 'select' block.");
        } else {
            block4: while (this.jj_2_18(Integer.MAX_VALUE)) {
                if (this.jj_2_19(Integer.MAX_VALUE)) {
                    RawTextNode contiguousRawText = this.ContiguousRawText();
                    if (contiguousRawText == null) continue;
                    templateBlock.add(contiguousRawText);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        SoyNode.StatementNode stmt = this.Stmt();
                        if (!(stmt instanceof SoyNode.MsgPlaceholderInitialContentNode)) {
                            String commandName = stmt instanceof IfNode ? "if" : ((SoyNode.CommandNode)((Object)stmt)).getCommandName();
                            throw new SoySyntaxException("Command '" + commandName + "' not allowed within a 'msg' block.");
                        }
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialContentNode)((Object)stmt)));
                        continue block4;
                    }
                    case 69: {
                        MsgHtmlTagNode msgHtmlTag = this.MsgHtmlTag();
                        templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), msgHtmlTag));
                        continue block4;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return templateBlock;
    }

    private final MsgPluralNode MsgPlural() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> templateBlockForMsg;
        SourceItemInfo<String> cmdText = this.PluralTag();
        MsgPluralNode msgPluralNode = this.setLocation(new MsgPluralNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        this.MaybeWhitespace("No content allowed between 'plural' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_22(Integer.MAX_VALUE)) {
            cmdText = this.CaseTag();
            MsgPluralCaseNode msgPluralCaseNode = this.setLocation(new MsgPluralCaseNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
            msgPluralNode.addChild(msgPluralCaseNode);
            templateBlockForMsg = this.TemplateBlockForMsg();
            if (templateBlockForMsg.size() == 1 && (templateBlockForMsg.get(0) instanceof MsgPluralNode || templateBlockForMsg.get(0) instanceof MsgSelectNode)) {
                throw new SoySyntaxException("Tags 'plural' and 'select' are not allowed inside 'plural' blocks.");
            }
            msgPluralCaseNode.addChildren(templateBlockForMsg);
        }
        SourceItemInfo<Void> defaultTagOpen = this.DefaultTag();
        MsgPluralDefaultNode msgPluralDefaultNode = this.setLocation(new MsgPluralDefaultNode(this.nodeIdGen.genId()), defaultTagOpen.lineNum);
        msgPluralNode.addChild(msgPluralDefaultNode);
        templateBlockForMsg = this.TemplateBlockForMsg();
        if (templateBlockForMsg.size() == 1 && (templateBlockForMsg.get(0) instanceof MsgPluralNode || templateBlockForMsg.get(0) instanceof MsgSelectNode)) {
            throw new SoySyntaxException("Tags 'plural' and 'select' are not allowed inside 'plural' blocks.");
        }
        msgPluralDefaultNode.addChildren(templateBlockForMsg);
        this.EndPluralTag();
        return msgPluralNode;
    }

    private final MsgSelectNode MsgSelect() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> templateBlockForMsg;
        SourceItemInfo<String> cmdText = this.SelectTag();
        MsgSelectNode msgSelectNode = this.setLocation(new MsgSelectNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        this.MaybeWhitespace("No content allowed between 'select' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_23(Integer.MAX_VALUE)) {
            cmdText = this.CaseTag();
            MsgSelectCaseNode msgSelectCaseNode = this.setLocation(new MsgSelectCaseNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
            msgSelectNode.addChild(msgSelectCaseNode);
            templateBlockForMsg = this.TemplateBlockForMsg();
            msgSelectCaseNode.addChildren(templateBlockForMsg);
        }
        SourceItemInfo<Void> defaultTagOpen = this.DefaultTag();
        MsgSelectDefaultNode msgSelectDefaultNode = this.setLocation(new MsgSelectDefaultNode(this.nodeIdGen.genId()), defaultTagOpen.lineNum);
        msgSelectNode.addChild(msgSelectDefaultNode);
        templateBlockForMsg = this.TemplateBlockForMsg();
        msgSelectDefaultNode.addChildren(templateBlockForMsg);
        this.EndSelectTag();
        return msgSelectNode;
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException, SoySyntaxException {
        Token tagOpen = this.jj_consume_token(69);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(70);
        int lineNum = tagOpen.beginLine;
        if (templateBlock.get(0) instanceof RawTextNode) {
            RawTextNode firstNode = (RawTextNode)templateBlock.get(0);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), "<" + firstNode.getRawText());
            templateBlock.set(0, this.setLocation(newNode, lineNum));
        } else {
            templateBlock.add(0, this.setLocation(new RawTextNode(this.nodeIdGen.genId(), "<"), lineNum));
        }
        int lastNodeIndex = templateBlock.size() - 1;
        if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
            RawTextNode lastNode = (RawTextNode)templateBlock.get(lastNodeIndex);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), lastNode.getRawText() + ">");
            templateBlock.set(lastNodeIndex, this.setLocation(newNode, lineNum));
        } else {
            templateBlock.add(this.setLocation(new RawTextNode(this.nodeIdGen.genId(), ">"), lineNum));
        }
        return this.setLocation(new MsgHtmlTagNode(this.nodeIdGen.genId(), templateBlock), lineNum);
    }

    private final PrintNode PrintStmt() throws ParseException, SoySyntaxException {
        String userSuppliedPhName;
        List cmdTextParts;
        boolean isImplicit;
        SourceItemInfo<List<String>> printTagParts = this.PrintTag();
        int lineNum = printTagParts.lineNum;
        if (!((List)printTagParts.parsedContent).isEmpty() && ((String)((List)printTagParts.parsedContent).get(0)).equals("print")) {
            isImplicit = false;
            cmdTextParts = ((List)printTagParts.parsedContent).subList(1, ((List)printTagParts.parsedContent).size());
        } else {
            isImplicit = true;
            cmdTextParts = (List)printTagParts.parsedContent;
        }
        String cmdText = Joiner.on((String)"").join((Iterable)cmdTextParts);
        String phnameAttr = null;
        for (String cmdTextPart : cmdTextParts) {
            if (!cmdTextPart.startsWith(" phname=\"") || !cmdTextPart.endsWith("\"")) continue;
            if (phnameAttr != null) {
                throw new SoySyntaxException("Found multiple 'phname' attributes in 'print' command text \"" + cmdText + "\".");
            }
            phnameAttr = cmdTextPart;
        }
        if (phnameAttr != null) {
            cmdTextParts.remove(phnameAttr);
            userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
        } else {
            userSuppliedPhName = null;
        }
        if (cmdTextParts.isEmpty()) {
            throw new SoySyntaxException("Found 'print' command with empty command text.");
        }
        String exprText = ((String)cmdTextParts.get(0)).trim();
        PrintNode printNode = this.setLocation(new PrintNode(this.nodeIdGen.genId(), isImplicit, exprText, userSuppliedPhName), lineNum);
        String directiveName = null;
        int n = cmdTextParts.size();
        for (int i = 1; i < n; ++i) {
            String cmdTextPart = (String)cmdTextParts.get(i);
            if (cmdTextPart.startsWith("|")) {
                if (directiveName != null) {
                    printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), directiveName, ""), lineNum));
                }
                directiveName = cmdTextPart;
                continue;
            }
            if (cmdTextPart.startsWith(":")) {
                if (directiveName == null) {
                    throw new AssertionError();
                }
                String argsText = cmdTextPart.substring(1);
                printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), directiveName, argsText), lineNum));
                directiveName = null;
                continue;
            }
            if (cmdTextPart.trim().length() == 0) continue;
            throw new SoySyntaxException("Invalid 'print' command text \"" + cmdText + "\" (check the directives).");
        }
        if (directiveName != null) {
            printNode.addChild(this.setLocation(new PrintDirectiveNode(this.nodeIdGen.genId(), directiveName, ""), lineNum));
        }
        return printNode;
    }

    private final void PrintStmtLookaheadHelper() throws ParseException {
        this.SoyTagOpen();
        if (this.jj_2_24(Integer.MAX_VALUE)) {
            this.jj_consume_token(24);
            this.jj_consume_token(54);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.AnyCmdName();
                    this.jj_consume_token(55);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final CssNode CssStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> cmdText = this.CssTag();
        return this.setLocation(new CssNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
    }

    private final LetNode LetStmt() throws ParseException, SoySyntaxException {
        LetNode letNode;
        if (this.jj_2_25(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.LetTagSelfEnding();
            letNode = this.setLocation(new LetValueNode(this.nodeIdGen.genId(), false, (String)cmdText.parsedContent), cmdText.lineNum);
        } else if (this.jj_2_26(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.LetTagNotSelfEnding();
            LetContentNode letContentNode = this.setLocation(new LetContentNode(this.nodeIdGen.genId(), false, (String)cmdText.parsedContent), cmdText.lineNum);
            List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
            letContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
            letNode = letContentNode;
            this.EndLetTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return letNode;
    }

    private final IfNode IfStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> cmdText = this.IfTag();
        IfNode ifNode = this.setLocation(new IfNode(this.nodeIdGen.genId()), cmdText.lineNum);
        IfCondNode ifCondNode = this.setLocation(new IfCondNode(this.nodeIdGen.genId(), "if", (String)cmdText.parsedContent), cmdText.lineNum);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        while (this.jj_2_27(Integer.MAX_VALUE)) {
            cmdText = this.ElseifTag();
            ifCondNode = this.setLocation(new IfCondNode(this.nodeIdGen.genId(), "elseif", (String)cmdText.parsedContent), cmdText.lineNum);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        if (this.jj_2_28(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> elseTagOpen = this.ElseTag();
            IfElseNode ifElseNode = this.setLocation(new IfElseNode(this.nodeIdGen.genId()), elseTagOpen.lineNum);
            ifNode.addChild(ifElseNode);
            templateBlock = this.TemplateBlock();
            ifElseNode.addChildren(templateBlock);
        }
        this.EndIfTag();
        return ifNode;
    }

    private final SwitchNode SwitchStmt() throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> templateBlock;
        SourceItemInfo<String> cmdText = this.SwitchTag();
        SwitchNode switchNode = this.setLocation(new SwitchNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        this.MaybeWhitespace("No content allowed between 'switch' and 'case' (whitespace and comments are okay).");
        while (this.jj_2_29(Integer.MAX_VALUE)) {
            cmdText = this.CaseTag();
            SwitchCaseNode switchCaseNode = this.setLocation(new SwitchCaseNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
            switchNode.addChild(switchCaseNode);
            templateBlock = this.TemplateBlock();
            switchCaseNode.addChildren(templateBlock);
        }
        if (this.jj_2_30(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> defaultTagOpen = this.DefaultTag();
            SwitchDefaultNode switchDefaultNode = this.setLocation(new SwitchDefaultNode(this.nodeIdGen.genId()), defaultTagOpen.lineNum);
            switchNode.addChild(switchDefaultNode);
            templateBlock = this.TemplateBlock();
            switchDefaultNode.addChildren(templateBlock);
        }
        this.EndSwitchTag();
        return switchNode;
    }

    private final ForeachNode ForeachStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> cmdText = this.ForeachTag();
        ForeachNode foreachNode = this.setLocation(new ForeachNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        int lineNum = this.getToken((int)0).beginLine;
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ForeachNonemptyNode foreachNonemptyNode = this.setLocation(new ForeachNonemptyNode(this.nodeIdGen.genId()), lineNum);
        foreachNode.addChild(foreachNonemptyNode);
        foreachNonemptyNode.addChildren(templateBlock);
        if (this.jj_2_31(Integer.MAX_VALUE)) {
            SourceItemInfo<Void> ifemptyTagOpen = this.IfemptyTag();
            templateBlock = this.TemplateBlock();
            ForeachIfemptyNode foreachIfemptyNode = this.setLocation(new ForeachIfemptyNode(this.nodeIdGen.genId()), ifemptyTagOpen.lineNum);
            foreachNode.addChild(foreachIfemptyNode);
            foreachIfemptyNode.addChildren(templateBlock);
        }
        this.EndForeachTag();
        return foreachNode;
    }

    private final ForNode ForStmt() throws ParseException, SoySyntaxException {
        SourceItemInfo<String> cmdText = this.ForTag();
        ForNode forNode = this.setLocation(new ForNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        forNode.addChildren(templateBlock);
        this.EndForTag();
        return forNode;
    }

    private final CallNode CallStmt() throws ParseException, SoySyntaxException {
        Boolean isBasicEndCallTag;
        SourceItemInfo<List<String>> callTagInfo;
        ArrayList callParams = Lists.newArrayList();
        if (this.jj_2_33(Integer.MAX_VALUE)) {
            callTagInfo = this.AnyCallTagSelfEnding();
            isBasicEndCallTag = null;
        } else if (this.jj_2_34(Integer.MAX_VALUE)) {
            callTagInfo = this.AnyCallTagNotSelfEnding();
            this.MaybeWhitespace("No content allowed between 'call' and 'param' (whitespace and comments are okay).");
            while (this.jj_2_32(Integer.MAX_VALUE)) {
                CallParamNode callParam = this.CallParam();
                callParams.add(callParam);
                this.MaybeWhitespace("No content allowed between 'param' and 'param' (whitespace and comments are okay).");
            }
            isBasicEndCallTag = this.EndAnyCallTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        List callTagParts = (List)callTagInfo.parsedContent;
        String cmdName = (String)callTagParts.get(0);
        StringBuilder cmdTextSb = new StringBuilder();
        String phnameAttr = null;
        for (int i = 1; i < callTagParts.size(); ++i) {
            String cmdTextPart = (String)callTagParts.get(i);
            if (cmdTextPart.startsWith(" phname=\"") && cmdTextPart.endsWith("\"")) {
                if (phnameAttr != null) {
                    throw new SoySyntaxException("Found multiple 'phname' attributes in '" + cmdName + "' command text \"" + Joiner.on((String)"").join(callTagParts.subList(1, callTagParts.size())) + "\".");
                }
                phnameAttr = cmdTextPart;
                continue;
            }
            cmdTextSb.append(cmdTextPart);
        }
        String cmdText = cmdTextSb.toString();
        boolean isBasicCallTag = ((String)callTagParts.get(0)).equals("call");
        if (isBasicEndCallTag != null && isBasicCallTag != isBasicEndCallTag) {
            if (isBasicCallTag) {
                throw new ParseException("Mismatched 'call' and '/delcall'.");
            }
            throw new ParseException("Mismatched 'delcall' and '/call'.");
        }
        String userSuppliedPhName = phnameAttr != null ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;
        CallNode callNode = isBasicCallTag ? new CallBasicNode(this.nodeIdGen.genId(), cmdText, userSuppliedPhName) : new CallDelegateNode(this.nodeIdGen.genId(), cmdText, userSuppliedPhName);
        callNode = this.setLocation(callNode, callTagInfo.lineNum);
        callNode.addChildren(callParams);
        return callNode;
    }

    private final CallParamNode CallParam() throws ParseException, SoySyntaxException {
        CallParamNode callParamNode;
        if (this.jj_2_35(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.ParamTagSelfEnding();
            callParamNode = this.setLocation(new CallParamValueNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
        } else if (this.jj_2_36(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.ParamTagNotSelfEnding();
            CallParamContentNode cpcn = this.setLocation(new CallParamContentNode(this.nodeIdGen.genId(), (String)cmdText.parsedContent), cmdText.lineNum);
            List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
            cpcn.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
            callParamNode = cpcn;
            this.EndParamTag();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return callParamNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    private boolean jj_3_33() {
        return this.jj_3R_22();
    }

    private boolean jj_3_26() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_20() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_25() {
        return this.jj_3R_20();
    }

    private boolean jj_3_17() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(56)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(57)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(25)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(26)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(28)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(34)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(37)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(39)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_23() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_31() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_46()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_35() {
        return this.jj_3R_16();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_36()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(55);
    }

    private boolean jj_3_16() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_14() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_13() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_31() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_12() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_30() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_scan_token(55);
    }

    private boolean jj_3_11() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_10() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_9() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_32() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_16() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(59)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(60)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(51)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(53)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(62)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(64)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_25() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_22() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_7() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_36() {
        return this.jj_3R_25();
    }

    private boolean jj_3_30() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(50)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(52)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(61)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(63)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_28() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_18() {
        return this.jj_3R_26();
    }

    private boolean jj_3_35() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_27() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_28()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_29() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        Token xsp;
        if (this.jj_scan_token(75)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_43());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_12() {
        return this.jj_3R_26();
    }

    private boolean jj_3_6() {
        return this.jj_3R_13();
    }

    private boolean jj_3_19() {
        return this.jj_3R_13();
    }

    private boolean jj_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(69)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        return this.jj_3R_13();
    }

    private boolean jj_3_28() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_21() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_23() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_20() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_27() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_4() {
        return this.jj_3R_13();
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_11() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(15)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(16)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(17)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(18)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(19)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(24)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(25)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(26)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(27)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(28)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(29)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(30)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(31)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(32)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(43)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(44)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(33)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(34)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(35)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(36)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(37)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(38)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(39)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(40)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(41)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(42)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(45)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(46)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(47)) {
                                                                                                                                                    return true;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(15)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3_32() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_21() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_34() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_37() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        return this.jj_3R_15();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{96, 0, 0, -15729152, 0, 0, 0, -15729152, 0, 65024, 96, 0, 96, 0, 96, 369360896, 96, 96, -15729152};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, -1609302016, 1076363264, 65535, 0x1B000000, 0x3000000, 0x1B000000, 65535, 0, 0, 0, 0, 0, 0, 0, 165, 0, 0, 402718719};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 1, 0, 0, 0, 0, 0, 2048, 0, 0, 2048, 0, 2048, 0, 0, 0, 32, 0};
    }

    public TemplateParser(InputStream stream) {
        this(stream, null);
    }

    public TemplateParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TemplateParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TemplateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public TemplateParser(TemplateParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(TemplateParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[83];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 19; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 83; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 36; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TemplateParser.jj_la1_init_0();
        TemplateParser.jj_la1_init_1();
        TemplateParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class SourceItemInfo<T> {
        final T parsedContent;
        final int lineNum;

        SourceItemInfo(T parsedContent, int lineNum) {
            this.parsedContent = parsedContent;
            this.lineNum = lineNum;
        }
    }
}

