/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.IncrementingIdGenerator;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parsepasses.CheckDelegatesVisitor;
import com.google.template.soy.parsepasses.CheckOverridesVisitor;
import com.google.template.soy.parsepasses.PrependNamespacesToCalleeNamesVisitor;
import com.google.template.soy.parsepasses.RewriteRemainderNodesVisitor;
import com.google.template.soy.parsepasses.VerifyPhnameAttrOnlyOnPlaceholdersVisitor;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.CheckSoyDocVisitor;
import com.google.template.soy.sharedpasses.RemoveHtmlCommentsVisitor;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class SoyFileSetParser {
    private final List<SoyFileSupplier> soyFileSuppliers;
    private boolean doRunInitialParsingPasses;
    private boolean doRunCheckingPasses;
    private boolean doEnforceSyntaxVersionV2;
    private boolean doCheckOverrides;

    public SoyFileSetParser(SoyFileSupplier ... soyFileSuppliers) {
        this(Lists.newArrayList((Object[])soyFileSuppliers));
    }

    public SoyFileSetParser(List<SoyFileSupplier> soyFileSuppliers) {
        this.soyFileSuppliers = soyFileSuppliers;
        this.doRunInitialParsingPasses = true;
        this.doRunCheckingPasses = true;
        this.doEnforceSyntaxVersionV2 = true;
        this.doCheckOverrides = true;
    }

    public SoyFileSetParser setDoRunInitialParsingPasses(boolean doRunInitialParsingPasses) {
        this.doRunInitialParsingPasses = doRunInitialParsingPasses;
        if (!doRunInitialParsingPasses) {
            this.doRunCheckingPasses = false;
            this.doEnforceSyntaxVersionV2 = false;
            this.doCheckOverrides = false;
        }
        return this;
    }

    public SoyFileSetParser setDoRunCheckingPasses(boolean doRunCheckingPasses) {
        this.doRunCheckingPasses = doRunCheckingPasses;
        if (doRunCheckingPasses) {
            Preconditions.checkState((boolean)this.doRunInitialParsingPasses);
        } else {
            this.doEnforceSyntaxVersionV2 = false;
            this.doCheckOverrides = false;
        }
        return this;
    }

    public SoyFileSetParser setDoEnforceSyntaxVersionV2(boolean doEnforceSyntaxVersionV2) {
        this.doEnforceSyntaxVersionV2 = doEnforceSyntaxVersionV2;
        if (doEnforceSyntaxVersionV2) {
            Preconditions.checkState((boolean)this.doRunCheckingPasses);
        }
        return this;
    }

    public SoyFileSetParser setDoCheckOverrides(boolean doCheckOverrides) {
        this.doCheckOverrides = doCheckOverrides;
        if (doCheckOverrides) {
            Preconditions.checkState((boolean)this.doRunCheckingPasses);
        }
        return this;
    }

    public SoyFileSetNode parse() throws SoySyntaxException {
        return (SoyFileSetNode)this.parseWithVersions().first;
    }

    public Pair<SoyFileSetNode, List<SoyFileSupplier.Version>> parseWithVersions() throws SoySyntaxException {
        IncrementingIdGenerator nodeIdGen = new IncrementingIdGenerator();
        SoyFileSetNode soyTree = new SoyFileSetNode(nodeIdGen.genId(), nodeIdGen);
        ImmutableList.Builder versions = ImmutableList.builder();
        for (SoyFileSupplier soyFileSupplier : this.soyFileSuppliers) {
            Pair<SoyFileNode, SoyFileSupplier.Version> fileAndVersion = SoyFileSetParser.parseSoyFileHelper(soyFileSupplier, nodeIdGen, soyFileSupplier.getPath());
            soyTree.addChild((SoyNode)fileAndVersion.first);
            versions.add(fileAndVersion.second);
        }
        if (this.doRunInitialParsingPasses) {
            new RewriteRemainderNodesVisitor().exec(soyTree);
            new PrependNamespacesToCalleeNamesVisitor().exec(soyTree);
            if (this.doRunCheckingPasses) {
                this.runCheckingPasses(soyTree);
            }
        }
        return Pair.of(soyTree, versions.build());
    }

    private static Pair<SoyFileNode, SoyFileSupplier.Version> parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen, String sourcePath) throws SoySyntaxException {
        SoyFileSupplier.Version version;
        Reader soyFileReader;
        try {
            Pair<Reader, SoyFileSupplier.Version> readerAndVersion = soyFileSupplier.open();
            soyFileReader = (Reader)readerAndVersion.first;
            version = (SoyFileSupplier.Version)readerAndVersion.second;
        }
        catch (IOException ioe) {
            throw new SoySyntaxException("Error opening Soy file " + soyFileSupplier.getPath() + ": " + ioe);
        }
        try {
            SoyFileNode soyFile = new SoyFileParser(soyFileReader, nodeIdGen, sourcePath).parseSoyFile();
            soyFile.setFilePath(soyFileSupplier.getPath());
            if (soyFileSupplier.hasChangedSince(version)) {
                throw new SoySyntaxException("Version skew in Soy file " + soyFileSupplier.getPath());
            }
            Pair<SoyFileNode, SoyFileSupplier.Version> pair = Pair.of(soyFile, version);
            return pair;
        }
        catch (TokenMgrError tme) {
            throw new SoySyntaxException(tme).setFilePath(soyFileSupplier.getPath());
        }
        catch (ParseException pe) {
            throw new SoySyntaxException(pe).setFilePath(soyFileSupplier.getPath());
        }
        catch (SoySyntaxException sse) {
            throw sse.setFilePath(soyFileSupplier.getPath());
        }
        finally {
            try {
                soyFileReader.close();
            }
            catch (IOException ioe) {
                throw new SoySyntaxException("Error closing Soy file " + soyFileSupplier.getPath() + ": " + ioe);
            }
        }
    }

    private void runCheckingPasses(SoyFileSetNode soyTree) {
        if (this.doEnforceSyntaxVersionV2) {
            new AssertSyntaxVersionV2Visitor().exec(soyTree);
        } else {
            new RemoveHtmlCommentsVisitor().exec(soyTree);
        }
        new VerifyPhnameAttrOnlyOnPlaceholdersVisitor().exec(soyTree);
        new CheckSoyDocVisitor(this.doEnforceSyntaxVersionV2).exec(soyTree);
        if (this.doCheckOverrides) {
            new CheckOverridesVisitor().exec(soyTree);
        }
        new CheckDelegatesVisitor().exec(soyTree);
    }
}

