/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaRuntimePrintDirective;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final Map<String, SoyJavaRuntimePrintDirective> soyJavaRuntimeDirectivesMap;
    private final EvalVisitor.EvalVisitorFactory evalVisitorFactory;
    private final RenderVisitorFactory renderVisitorFactory;
    private final Appendable outputSb;
    private final TemplateRegistry templateRegistry;
    private final SoyMapData data;
    private final SoyMapData ijData;
    private final Deque<Map<String, SoyData>> env;
    private final Set<String> activeDelPackageNames;
    private final SoyMsgBundle msgBundle;
    private final SoyCssRenamingMap cssRenamingMap;
    private EvalVisitor evalVisitor;
    private SoyListData foreachList;
    private int currPluralRemainderValue;

    protected RenderVisitor(@Nullable Map<String, SoyJavaRuntimePrintDirective> soyJavaRuntimeDirectivesMap, EvalVisitor.EvalVisitorFactory evalVisitorFactory, RenderVisitorFactory renderVisitorFactory, Appendable outputSb, @Nullable TemplateRegistry templateRegistry, @Nullable SoyMapData data, @Nullable SoyMapData ijData, @Nullable Deque<Map<String, SoyData>> env, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        this.soyJavaRuntimeDirectivesMap = soyJavaRuntimeDirectivesMap;
        this.evalVisitorFactory = evalVisitorFactory;
        this.renderVisitorFactory = renderVisitorFactory;
        this.outputSb = outputSb;
        this.templateRegistry = templateRegistry;
        this.data = data;
        this.ijData = ijData;
        this.env = env != null ? env : new ArrayDeque();
        this.activeDelPackageNames = activeDelPackageNames;
        this.msgBundle = msgBundle;
        this.cssRenamingMap = cssRenamingMap;
        this.evalVisitor = null;
        this.currPluralRemainderValue = -1;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        try {
            this.visitBlockHelper(node);
        }
        catch (RenderException re) {
            throw re.getTemplateName() != null ? re : re.setTemplateName(node.getTemplateName());
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.append(this.outputSb, node.getRawText());
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        SoyMsg soyMsg;
        boolean doAddEnvFrame;
        boolean bl = doAddEnvFrame = node.needsEnvFrameDuringInterp() != Boolean.FALSE;
        if (doAddEnvFrame) {
            this.env.push(Maps.newHashMap());
        }
        if (this.msgBundle != null) {
            long msgId = MsgUtils.computeMsgId(node);
            soyMsg = this.msgBundle.getMsg(msgId);
        } else {
            soyMsg = null;
        }
        if (soyMsg != null) {
            List<SoyMsgPart> msgParts = soyMsg.getParts();
            if (msgParts.size() > 0) {
                SoyMsgPart firstPart = msgParts.get(0);
                if (firstPart instanceof SoyMsgPluralPart) {
                    new PluralSelectMsgPartsVisitor(node, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgPluralPart)firstPart);
                } else if (firstPart instanceof SoyMsgSelectPart) {
                    new PluralSelectMsgPartsVisitor(node, new ULocale(soyMsg.getLocaleString())).visitPart((SoyMsgSelectPart)firstPart);
                } else {
                    for (SoyMsgPart msgPart : msgParts) {
                        if (msgPart instanceof SoyMsgRawTextPart) {
                            this.append(this.outputSb, ((SoyMsgRawTextPart)msgPart).getRawText());
                            continue;
                        }
                        if (msgPart instanceof SoyMsgPlaceholderPart) {
                            String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                            this.visit(node.getRepPlaceholderNode(placeholderName));
                            continue;
                        }
                        throw new AssertionError();
                    }
                }
            }
        } else {
            this.visitChildren(node);
        }
        if (doAddEnvFrame) {
            this.env.pop();
        }
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode node) {
        int pluralValue;
        ExprRootNode<?> pluralExpr = node.getExpr();
        try {
            pluralValue = this.eval(pluralExpr).integerValue();
        }
        catch (SoyDataException e) {
            throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", pluralExpr.toSourceString()));
        }
        this.currPluralRemainderValue = pluralValue - node.getOffset();
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgPluralDefaultNode) {
                this.visitChildren(child);
                break;
            }
            if (((MsgPluralCaseNode)child).getCaseNumber() != pluralValue) continue;
            this.visitChildren(child);
            break;
        }
        this.currPluralRemainderValue = -1;
    }

    @Override
    protected void visitMsgPluralCaseNode(MsgPluralCaseNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgPluralDefaultNode(MsgPluralDefaultNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgPluralRemainderNode(MsgPluralRemainderNode node) {
        this.append(this.outputSb, String.valueOf(this.currPluralRemainderValue));
    }

    @Override
    protected void visitMsgSelectNode(MsgSelectNode node) {
        String selectValue;
        ExprRootNode<?> selectExpr = node.getExpr();
        try {
            selectValue = this.eval(selectExpr).stringValue();
        }
        catch (SoyDataException e) {
            throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()));
        }
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgSelectDefaultNode) {
                this.visitChildren(child);
                continue;
            }
            if (!((MsgSelectCaseNode)child).getCaseValue().equals(selectValue)) continue;
            this.visitChildren(child);
            return;
        }
    }

    @Override
    protected void visitMsgSelectCaseNode(MsgSelectCaseNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgSelectDefaultNode(MsgSelectDefaultNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitGoogMsgRefNode(GoogMsgRefNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        SoyData result = this.eval(node.getExprUnion().getExpr());
        if (result instanceof UndefinedData) {
            throw new RenderException("In 'print' tag, expression \"" + node.getExprText() + "\" evaluates to undefined.");
        }
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            List<ExprRootNode<?>> argsExprs = directiveNode.getArgs();
            ArrayList argsSoyDatas = Lists.newArrayListWithCapacity((int)argsExprs.size());
            for (ExprRootNode<?> argExpr : argsExprs) {
                argsSoyDatas.add(this.evalVisitor.exec(argExpr));
            }
            String directiveResult = this.applyDirective(directiveNode.getName(), result, argsSoyDatas, node);
            result = StringData.forValue(directiveResult);
        }
        this.append(this.outputSb, String.valueOf(result));
    }

    protected String applyDirective(String directiveName, SoyData value, List<SoyData> args, PrintNode printNode) {
        SoyJavaRuntimePrintDirective directive = this.soyJavaRuntimeDirectivesMap.get(directiveName);
        if (directive == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + directiveName + "'" + " (tag " + printNode.toSourceString() + ")");
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw new RenderException("Print directive '" + directiveName + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
        }
        try {
            return directive.apply(value, args);
        }
        catch (RuntimeException e) {
            throw new RenderException(String.format("Failed in applying directive '%s' in tag \"%s\" due to exception: %s", directiveName, printNode.toSourceString(), e.getMessage()));
        }
    }

    @Override
    protected void visitCssNode(CssNode node) {
        String mappedText;
        ExprRootNode<?> componentNameExpr = node.getComponentNameExpr();
        if (componentNameExpr != null) {
            this.append(this.outputSb, this.eval(componentNameExpr).toString());
            this.append(this.outputSb, "-");
        }
        String selectorText = node.getSelectorText();
        if (this.cssRenamingMap != null && (mappedText = this.cssRenamingMap.get(selectorText)) != null) {
            selectorText = mappedText;
        }
        this.append(this.outputSb, selectorText);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.env.peek().put(node.getVarName(), this.eval(node.getValueExpr()));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.env.peek().put(node.getVarName(), this.renderChildren(node));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                if (!this.eval(icn.getExprUnion().getExpr()).toBoolean()) continue;
                this.visit(icn);
                return;
            }
            if (child instanceof IfElseNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        SoyData switchValue = this.eval(node.getExpr());
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprRootNode<?> caseExpr : scn.getExprList()) {
                    if (!switchValue.equals(this.eval(caseExpr))) continue;
                    this.visit(scn);
                    return;
                }
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        SoyData dataRefValue = this.eval(node.getExpr());
        if (!(dataRefValue instanceof SoyListData)) {
            throw new RenderException("In 'foreach' command " + node.toSourceString() + ", the data reference does not resolve to a SoyListData.");
        }
        this.foreachList = (SoyListData)dataRefValue;
        if (this.foreachList.length() > 0) {
            this.visit((SoyNode)node.getChild(0));
        } else if (node.numChildren() == 2) {
            this.visit((SoyNode)node.getChild(1));
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        SoyListData foreachList = this.foreachList;
        this.foreachList = null;
        String varName = node.getVarName();
        HashMap newEnvFrame = Maps.newHashMap();
        newEnvFrame.put(varName + "__lastIndex", IntegerData.forValue(foreachList.length() - 1));
        this.env.push(newEnvFrame);
        for (int i = 0; i < foreachList.length(); ++i) {
            newEnvFrame.put(varName + "__index", IntegerData.forValue(i));
            newEnvFrame.put(varName, foreachList.get(i));
            this.visitChildren(node);
        }
        this.env.pop();
    }

    @Override
    protected void visitForNode(ForNode node) {
        ArrayList rangeArgValues = Lists.newArrayList();
        for (ExprRootNode<?> rangeArg : node.getRangeArgs()) {
            SoyData rangeArgValue = this.eval(rangeArg);
            if (!(rangeArgValue instanceof IntegerData)) {
                throw new RenderException("In 'for' command " + node.toSourceString() + ", the expression \"" + rangeArg.toSourceString() + "\" does not resolve to an integer.");
            }
            rangeArgValues.add(((IntegerData)rangeArgValue).getValue());
        }
        int increment = rangeArgValues.size() == 3 ? (Integer)rangeArgValues.remove(2) : 1;
        int init = rangeArgValues.size() == 2 ? (Integer)rangeArgValues.remove(0) : 0;
        int limit = (Integer)rangeArgValues.get(0);
        String localVarName = node.getVarName();
        HashMap newEnvFrame = Maps.newHashMap();
        this.env.push(newEnvFrame);
        for (int i = init; i < limit; i += increment) {
            newEnvFrame.put(localVarName, IntegerData.forValue(i));
            this.visitChildren(node);
        }
        this.env.pop();
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            throw new RenderException("Attempting to render undefined template '" + node.getCalleeName() + "'.");
        }
        this.visitCallNodeHelper(node, callee);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateDelegateNode callee;
        try {
            callee = this.templateRegistry.selectDelegateTemplate(node.getDelCalleeName(), this.activeDelPackageNames);
        }
        catch (TemplateRegistry.DelegateTemplateConflictException e) {
            throw new RenderException(e.getMessage());
        }
        if (callee == null) {
            return;
        }
        this.visitCallNodeHelper(node, callee);
    }

    private void visitCallNodeHelper(CallNode node, TemplateNode callee) {
        SoyMapData dataToPass;
        if (node.isPassingAllData()) {
            dataToPass = this.data;
        } else if (node.isPassingData()) {
            SoyData dataRefValue = this.eval(node.getExpr());
            if (!(dataRefValue instanceof SoyMapData)) {
                throw new RenderException("In 'call' command " + node.toSourceString() + ", the data reference does not resolve to a SoyMapData.");
            }
            dataToPass = (SoyMapData)dataRefValue;
        } else {
            dataToPass = null;
        }
        SoyMapData callData = !node.isPassingData() ? new SoyMapData() : (node.numChildren() == 0 ? dataToPass : new AugmentedSoyMapData(dataToPass));
        for (CallParamNode child : node.getChildren()) {
            if (child instanceof CallParamValueNode) {
                callData.putSingle(child.getKey(), this.eval(((CallParamValueNode)child).getValueExprUnion().getExpr()));
                continue;
            }
            if (child instanceof CallParamContentNode) {
                callData.putSingle(child.getKey(), this.renderChildren((CallParamContentNode)child));
                continue;
            }
            throw new AssertionError();
        }
        RenderVisitor rv = this.renderVisitorFactory.create(this.outputSb, this.templateRegistry, callData, this.ijData, null, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
        rv.exec(callee);
    }

    @Override
    protected void visitCallParamNode(CallParamNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.visitBlockHelper((SoyNode.BlockNode)node);
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private void visitBlockHelper(SoyNode.BlockNode node) {
        if (node.needsEnvFrameDuringInterp() != Boolean.FALSE) {
            this.env.push(Maps.newHashMap());
            this.visitChildren(node);
            this.env.pop();
        } else {
            this.visitChildren(node);
        }
    }

    private SoyData eval(ExprNode expr) {
        if (expr == null) {
            throw new RenderException("Cannot evaluate expression in V1 syntax.");
        }
        if (this.evalVisitor == null) {
            this.evalVisitor = this.evalVisitorFactory.create(this.data, this.ijData, this.env);
        }
        try {
            return (SoyData)this.evalVisitor.exec(expr);
        }
        catch (Exception e) {
            throw new RenderException("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage());
        }
    }

    private StringData renderChildren(SoyNode.BlockNode block) {
        StringBuilder output = new StringBuilder();
        RenderVisitor rv = this.renderVisitorFactory.create(output, this.templateRegistry, this.data, this.ijData, this.env, this.activeDelPackageNames, this.msgBundle, this.cssRenamingMap);
        rv.visitChildren(block);
        return StringData.forValue(output.toString());
    }

    private void append(Appendable out, CharSequence csq) {
        try {
            out.append(csq);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private class PluralSelectMsgPartsVisitor {
        private final MsgNode msgNode;
        private final ULocale locale;
        private int currentPluralRemainderValue;

        public PluralSelectMsgPartsVisitor(MsgNode msgNode, ULocale locale) {
            this.msgNode = msgNode;
            this.locale = locale;
        }

        private void visitPart(SoyMsgSelectPart selectPart) {
            String correctSelectValue;
            String selectVarName = selectPart.getSelectVarName();
            MsgSelectNode repSelectNode = this.msgNode.getRepSelectNode(selectVarName);
            ExprRootNode<?> selectExpr = repSelectNode.getExpr();
            try {
                correctSelectValue = RenderVisitor.this.eval(selectExpr).stringValue();
            }
            catch (SoyDataException e) {
                throw new RenderException(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()));
            }
            List caseParts = null;
            List defaultParts = null;
            for (Pair<String, List<SoyMsgPart>> case0 : selectPart.getCases()) {
                if (case0.first == null) {
                    defaultParts = (List)case0.second;
                    continue;
                }
                if (!((String)case0.first).equals(correctSelectValue)) continue;
                caseParts = (List)case0.second;
                break;
            }
            if (caseParts == null) {
                caseParts = defaultParts;
            }
            if (caseParts != null) {
                for (SoyMsgPart casePart : caseParts) {
                    if (casePart instanceof SoyMsgSelectPart) {
                        this.visitPart((SoyMsgSelectPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPluralPart) {
                        this.visitPart((SoyMsgPluralPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)casePart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + casePart.getClass().getName() + " under a select case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralPart pluralPart) {
            int correctPluralValue;
            MsgPluralNode repPluralNode = this.msgNode.getRepPluralNode(pluralPart.getPluralVarName());
            ExprRootNode<?> pluralExpr = repPluralNode.getExpr();
            try {
                correctPluralValue = RenderVisitor.this.eval(pluralExpr).integerValue();
            }
            catch (SoyDataException e) {
                throw new RenderException(String.format("Plural expression \"%s\" doesn't evaluate to integer.", pluralExpr.toSourceString()));
            }
            this.currentPluralRemainderValue = correctPluralValue - repPluralNode.getOffset();
            List caseParts = null;
            boolean hasNonExplicitCases = false;
            List otherCaseParts = null;
            for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> case0 : pluralPart.getCases()) {
                SoyMsgPluralCaseSpec pluralCaseSpec = (SoyMsgPluralCaseSpec)case0.first;
                SoyMsgPluralCaseSpec.Type caseType = pluralCaseSpec.getType();
                if (caseType == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                    if (pluralCaseSpec.getExplicitValue() != correctPluralValue) continue;
                    caseParts = (List)case0.second;
                    break;
                }
                if (caseType == SoyMsgPluralCaseSpec.Type.OTHER) {
                    otherCaseParts = (List)case0.second;
                    continue;
                }
                hasNonExplicitCases = true;
            }
            if (caseParts == null && !hasNonExplicitCases) {
                caseParts = otherCaseParts;
            }
            if (caseParts == null) {
                String pluralKeyword = PluralRules.forLocale((ULocale)this.locale).select((double)this.currentPluralRemainderValue);
                SoyMsgPluralCaseSpec.Type correctCaseType = new SoyMsgPluralCaseSpec(pluralKeyword).getType();
                for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> case0 : pluralPart.getCases()) {
                    if (((SoyMsgPluralCaseSpec)case0.first).getType() != correctCaseType) continue;
                    caseParts = (List)case0.second;
                    break;
                }
            }
            if (caseParts != null) {
                for (SoyMsgPart casePart : caseParts) {
                    if (casePart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgRawTextPart) {
                        this.visitPart((SoyMsgRawTextPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPluralRemainderPart) {
                        this.visitPart((SoyMsgPluralRemainderPart)casePart);
                        continue;
                    }
                    throw new RenderException("Unsupported part of type " + casePart.getClass().getName() + " under a plural case.");
                }
            }
        }

        private void visitPart(SoyMsgPluralRemainderPart remainderPart) {
            RenderVisitor.this.append(RenderVisitor.this.outputSb, String.valueOf(this.currentPluralRemainderValue));
        }

        private void visitPart(SoyMsgPlaceholderPart msgPlaceholderPart) {
            RenderVisitor.this.visit(this.msgNode.getRepPlaceholderNode(msgPlaceholderPart.getPlaceholderName()));
        }

        private void visitPart(SoyMsgRawTextPart rawTextPart) {
            RenderVisitor.this.append(RenderVisitor.this.outputSb, rawTextPart.getRawText());
        }
    }

    public static interface RenderVisitorFactory {
        public RenderVisitor create(Appendable var1, TemplateRegistry var2, @Nullable SoyMapData var3, @Nullable SoyMapData var4, @Nullable Deque<Map<String, SoyData>> var5, @Nullable Set<String> var6, @Nullable SoyMsgBundle var7, @Nullable SoyCssRenamingMap var8);
    }
}

