/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunction;
import com.google.template.soy.sharedpasses.render.RenderException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class EvalVisitor
extends AbstractReturningExprNodeVisitor<SoyData> {
    private final Map<String, SoyJavaRuntimeFunction> soyJavaRuntimeFunctionsMap;
    private final SoyMapData data;
    private final SoyMapData ijData;
    private final Deque<Map<String, SoyData>> env;

    protected EvalVisitor(@Nullable Map<String, SoyJavaRuntimeFunction> soyJavaRuntimeFunctionsMap, @Nullable SoyMapData data, @Nullable SoyMapData ijData, Deque<Map<String, SoyData>> env) {
        this.soyJavaRuntimeFunctionsMap = soyJavaRuntimeFunctionsMap;
        this.data = data;
        this.ijData = ijData;
        this.env = env;
    }

    @Override
    protected SoyData visitExprRootNode(ExprRootNode<?> node) {
        return (SoyData)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected SoyData visitNullNode(NullNode node) {
        return NullData.INSTANCE;
    }

    @Override
    protected SoyData visitBooleanNode(BooleanNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyData visitIntegerNode(IntegerNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyData visitFloatNode(FloatNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyData visitStringNode(StringNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyData visitListLiteralNode(ListLiteralNode node) {
        return new SoyListData(this.visitChildren(node));
    }

    @Override
    protected SoyData visitMapLiteralNode(MapLiteralNode node) {
        HashMap map = Maps.newHashMap();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            SoyData key = (SoyData)this.visit(node.getChild(i));
            if (!(key instanceof StringData)) {
                throw new RenderException("Maps must have string keys (key \"" + node.getChild(i).toSourceString() + "\"" + " in map " + node.toSourceString() + " does not evaluate to a string).");
            }
            SoyData value = (SoyData)this.visit(node.getChild(i + 1));
            map.put(key.stringValue(), value);
        }
        return new SoyMapData(map);
    }

    @Override
    protected SoyData visitDataRefNode(DataRefNode node) {
        SoyData value0 = this.resolveDataRefFirstKey(node);
        if (node.numChildren() == 1) {
            return value0;
        }
        SoyData value = value0;
        for (int i = 1; i < node.numChildren(); ++i) {
            if (!(value instanceof CollectionData)) {
                return UndefinedData.INSTANCE;
            }
            ExprNode child = node.getChild(i);
            if (child instanceof DataRefKeyNode) {
                value = ((CollectionData)value).getSingle(((DataRefKeyNode)child).getKey());
                continue;
            }
            if (child instanceof DataRefIndexNode) {
                value = ((SoyListData)value).get(((DataRefIndexNode)child).getIndex());
                continue;
            }
            if (child instanceof GlobalNode) {
                throw new UnsupportedOperationException();
            }
            SoyData key = (SoyData)this.visit(child);
            value = key instanceof IntegerData ? ((SoyListData)value).get(((IntegerData)key).getValue()) : ((CollectionData)value).getSingle(key.toString());
        }
        if (value != null) {
            return value;
        }
        return UndefinedData.INSTANCE;
    }

    @Override
    protected SoyData visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        SoyData operand = (SoyData)this.visit(node.getChild(0));
        if (operand instanceof IntegerData) {
            return this.convertResult(-operand.integerValue());
        }
        return this.convertResult(-operand.floatValue());
    }

    @Override
    protected SoyData visitNotOpNode(OperatorNodes.NotOpNode node) {
        SoyData operand = (SoyData)this.visit(node.getChild(0));
        return this.convertResult(!operand.toBoolean());
    }

    @Override
    protected SoyData visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() * operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() * operand1.numberValue());
    }

    @Override
    protected SoyData visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        return this.convertResult(operand0.numberValue() / operand1.numberValue());
    }

    @Override
    protected SoyData visitModOpNode(OperatorNodes.ModOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        return this.convertResult(operand0.integerValue() % operand1.integerValue());
    }

    @Override
    protected SoyData visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() + operand1.integerValue());
        }
        if (operand0 instanceof StringData || operand1 instanceof StringData) {
            return this.convertResult(operand0.toString() + operand1.toString());
        }
        return this.convertResult(operand0.numberValue() + operand1.numberValue());
    }

    @Override
    protected SoyData visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() - operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() - operand1.numberValue());
    }

    @Override
    protected SoyData visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() < operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() < operand1.numberValue());
    }

    @Override
    protected SoyData visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() > operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() > operand1.numberValue());
    }

    @Override
    protected SoyData visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() <= operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() <= operand1.numberValue());
    }

    @Override
    protected SoyData visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return this.convertResult(operand0.integerValue() >= operand1.integerValue());
        }
        return this.convertResult(operand0.numberValue() >= operand1.numberValue());
    }

    @Override
    protected SoyData visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        return this.convertResult(operand0.equals(operand1));
    }

    @Override
    protected SoyData visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        SoyData operand1;
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        return this.convertResult(!operand0.equals(operand1 = (SoyData)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyData visitAndOpNode(OperatorNodes.AndOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        if (!operand0.toBoolean()) {
            return this.convertResult(false);
        }
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        return this.convertResult(operand1.toBoolean());
    }

    @Override
    protected SoyData visitOrOpNode(OperatorNodes.OrOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        if (operand0.toBoolean()) {
            return this.convertResult(true);
        }
        SoyData operand1 = (SoyData)this.visit(node.getChild(1));
        return this.convertResult(operand1.toBoolean());
    }

    @Override
    protected SoyData visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        SoyData operand0 = (SoyData)this.visit(node.getChild(0));
        if (operand0.toBoolean()) {
            return (SoyData)this.visit(node.getChild(1));
        }
        return (SoyData)this.visit(node.getChild(2));
    }

    @Override
    protected SoyData visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw new RenderException("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        List<SoyData> args = this.visitChildren(node);
        return this.computeFunction(fnName, args, node);
    }

    protected SoyData computeFunction(String fnName, List<SoyData> args, FunctionNode fnNode) {
        SoyJavaRuntimeFunction fn = this.soyJavaRuntimeFunctionsMap.get(fnName);
        if (fn == null) {
            throw new RenderException("Failed to find Soy function with name '" + fnName + "'" + " (function call \"" + fnNode.toSourceString() + "\").");
        }
        return this.computeFunctionHelper(fn, args, fnNode);
    }

    protected SoyData computeFunctionHelper(SoyJavaRuntimeFunction fn, List<SoyData> args, FunctionNode fnNode) {
        try {
            return fn.compute(args);
        }
        catch (Exception e) {
            throw new RenderException("Error while computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage());
        }
    }

    private SoyData visitIsFirstFunction(FunctionNode node) {
        int localVarIndex;
        try {
            DataRefNode dataRef = (DataRefNode)node.getChild(0);
            String localVarName = dataRef.getFirstKey();
            localVarIndex = this.getLocalVar(localVarName + "__index").integerValue();
        }
        catch (Exception e) {
            throw new RenderException("Failed to evaluate function call " + node.toSourceString() + ".");
        }
        return this.convertResult(localVarIndex == 0);
    }

    private SoyData visitIsLastFunction(FunctionNode node) {
        int localVarLastIndex;
        int localVarIndex;
        try {
            DataRefNode dataRef = (DataRefNode)node.getChild(0);
            String localVarName = dataRef.getFirstKey();
            localVarIndex = this.getLocalVar(localVarName + "__index").integerValue();
            localVarLastIndex = this.getLocalVar(localVarName + "__lastIndex").integerValue();
        }
        catch (Exception e) {
            throw new RenderException("Failed to evaluate function call " + node.toSourceString() + ".");
        }
        return this.convertResult(localVarIndex == localVarLastIndex);
    }

    private SoyData visitIndexFunction(FunctionNode node) {
        int localVarIndex;
        try {
            DataRefNode dataRef = (DataRefNode)node.getChild(0);
            String localVarName = dataRef.getFirstKey();
            localVarIndex = this.getLocalVar(localVarName + "__index").integerValue();
        }
        catch (Exception e) {
            throw new RenderException("Failed to evaluate function call " + node.toSourceString() + ".");
        }
        return this.convertResult(localVarIndex);
    }

    private SoyData visitHasDataFunction() {
        return this.convertResult(this.data != null);
    }

    private SoyData convertResult(boolean b) {
        return BooleanData.forValue(b);
    }

    private SoyData convertResult(int i) {
        return IntegerData.forValue(i);
    }

    private SoyData convertResult(double f) {
        return FloatData.forValue(f);
    }

    private SoyData convertResult(String s) {
        return StringData.forValue(s);
    }

    private SoyData getLocalVar(String localVarName) {
        for (Map<String, SoyData> envFrame : this.env) {
            SoyData value = envFrame.get(localVarName);
            if (value == null) continue;
            return value;
        }
        throw new AssertionError();
    }

    protected SoyData resolveDataRefFirstKey(DataRefNode dataRefNode) {
        String firstKey = dataRefNode.getFirstKey();
        SoyData value = null;
        if (dataRefNode.isIjDataRef()) {
            value = this.ijData.getSingle(firstKey);
        } else {
            Boolean isLocalVarDataRef = dataRefNode.isLocalVarDataRef();
            if ((isLocalVarDataRef == Boolean.TRUE || isLocalVarDataRef == null) && this.env != null) {
                Map<String, SoyData> envFrame;
                Iterator<Map<String, SoyData>> i$ = this.env.iterator();
                while (i$.hasNext() && (value = (envFrame = i$.next()).get(firstKey)) == null) {
                }
            }
            if (isLocalVarDataRef == Boolean.FALSE || isLocalVarDataRef == null && value == null) {
                value = this.data.getSingle(firstKey);
            }
        }
        return value != null ? value : UndefinedData.INSTANCE;
    }

    public static interface EvalVisitorFactory {
        public EvalVisitor create(@Nullable SoyMapData var1, @Nullable SoyMapData var2, Deque<Map<String, SoyData>> var3);
    }
}

