/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.sharedpasses.FindUsedIjParamsInExprHelperVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class FindUsedIjParamsVisitor
extends AbstractSoyNodeVisitor<UsedIjParamsInfo> {
    private TemplateRegistry templateRegistry;
    private Set<TemplateNode> visitedTemplates;
    private TemplateNode currTemplate;
    private Deque<TemplateNode> callerStack;
    private Multimap<String, TemplateNode> usedIjParamToCalleesMultimap;
    private boolean mayHaveExternalUsedIjParams;

    public FindUsedIjParamsVisitor(@Nullable TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    @Override
    public UsedIjParamsInfo exec(SoyNode node) {
        this.visitedTemplates = Sets.newHashSet();
        this.currTemplate = null;
        this.callerStack = new ArrayDeque<TemplateNode>();
        this.usedIjParamToCalleesMultimap = LinkedHashMultimap.create();
        this.mayHaveExternalUsedIjParams = false;
        this.visit(node);
        return new UsedIjParamsInfo(this.usedIjParamToCalleesMultimap, this.mayHaveExternalUsedIjParams);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (this.templateRegistry == null) {
            SoyFileSetNode soyTree = (SoyFileSetNode)node.getParent().getParent();
            this.templateRegistry = new TemplateRegistry(soyTree);
        }
        this.visitedTemplates.add(node);
        FindUsedIjParamsInExprHelperVisitor helperVisitor = new FindUsedIjParamsInExprHelperVisitor();
        SoytreeUtils.execOnAllV2Exprs(node, helperVisitor);
        Set<String> locallyUsedIjParams = helperVisitor.getResult();
        for (String param : locallyUsedIjParams) {
            this.usedIjParamToCalleesMultimap.put((Object)param, (Object)node);
        }
        this.currTemplate = node;
        this.visitChildren(node);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        this.visitChildren(node);
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            this.mayHaveExternalUsedIjParams = true;
            return;
        }
        this.visitCalleeHelper(callee);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        this.visitChildren(node);
        this.mayHaveExternalUsedIjParams = true;
        List<TemplateRegistry.DelegateTemplateDivision> delTemplateDivisions = this.templateRegistry.getSortedDelegateTemplateDivisions(node.getDelCalleeName());
        if (delTemplateDivisions != null) {
            for (TemplateRegistry.DelegateTemplateDivision division : delTemplateDivisions) {
                for (TemplateDelegateNode delCallee : division.delPackageNameToDelTemplateMap.values()) {
                    this.visitCalleeHelper(delCallee);
                }
            }
        }
    }

    private void visitCalleeHelper(TemplateNode callee) {
        if (callee == this.currTemplate || this.callerStack.contains(callee)) {
            return;
        }
        if (this.visitedTemplates.contains(callee)) {
            return;
        }
        this.callerStack.push(this.currTemplate);
        this.visit(callee);
        this.currTemplate = this.callerStack.pop();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    public static class UsedIjParamsInfo {
        public final Multimap<String, TemplateNode> usedIjParamToCalleesMultimap;
        public final boolean mayHaveExternalUsedIjParams;

        public UsedIjParamsInfo(Multimap<String, TemplateNode> usedIjParamToCalleesMultimap, boolean mayHaveExternalUsedIjParams) {
            this.usedIjParamToCalleesMultimap = usedIjParamToCalleesMultimap;
            this.mayHaveExternalUsedIjParams = mayHaveExternalUsedIjParams;
        }
    }
}

