/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.FindIndirectParamsVisitor;
import com.google.template.soy.sharedpasses.MarkLocalVarDataRefsVisitor;
import com.google.template.soy.sharedpasses.UnmarkLocalVarDataRefsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CheckSoyDocVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final boolean isTreeAllV2;
    private TemplateRegistry templateRegistry;
    private boolean currFileHasOptParams;
    private boolean usesFunctionHasData;
    private GetDataKeysInExprVisitor getDataKeysInExprVisitor;

    public CheckSoyDocVisitor(boolean isTreeAllV2) {
        this.isTreeAllV2 = isTreeAllV2;
    }

    @Override
    public Void exec(SoyNode node) {
        new MarkLocalVarDataRefsVisitor().exec(node);
        super.exec(node);
        new UnmarkLocalVarDataRefsVisitor().exec(node);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.templateRegistry = new TemplateRegistry(node);
        for (SoyFileNode soyFile : node.getChildren()) {
            boolean isFileAllV2;
            if (this.isTreeAllV2) {
                isFileAllV2 = true;
            } else {
                try {
                    new AssertSyntaxVersionV2Visitor().exec(soyFile);
                    isFileAllV2 = true;
                }
                catch (SoySyntaxException sse) {
                    isFileAllV2 = false;
                }
            }
            if (!isFileAllV2) continue;
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.currFileHasOptParams = false;
        block0: for (TemplateNode template : node.getChildren()) {
            for (TemplateNode.SoyDocParam param : template.getSoyDocParams()) {
                if (param.isRequired) continue;
                this.currFileHasOptParams = true;
                break block0;
            }
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.usesFunctionHasData = false;
        HashSet dataKeys = Sets.newHashSet();
        this.getDataKeysInExprVisitor = new GetDataKeysInExprVisitor(dataKeys);
        this.visitChildren(node);
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        ArrayList unusedParams = Lists.newArrayList();
        for (TemplateNode.SoyDocParam param : node.getSoyDocParams()) {
            if (dataKeys.contains(param.key)) {
                dataKeys.remove(param.key);
                continue;
            }
            if (ipi.paramKeyToCalleesMultimap.containsKey((Object)param.key) || ipi.mayHaveExternalIndirectParams) continue;
            unusedParams.add(param.key);
        }
        ArrayList undeclaredDataKeys = Lists.newArrayList();
        if (dataKeys.size() > 0) {
            undeclaredDataKeys.addAll(dataKeys);
            Collections.sort(undeclaredDataKeys);
        }
        if (undeclaredDataKeys.size() > 0) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found references to data keys that are not declared in SoyDoc: " + undeclaredDataKeys, null, node);
        }
        if (unusedParams.size() > 0 && !(node instanceof TemplateDelegateNode)) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found params declared in SoyDoc but not used in template: " + unusedParams, null, node);
        }
        if (this.currFileHasOptParams && this.usesFunctionHasData) {
            for (TemplateNode.SoyDocParam param : node.getSoyDocParams()) {
                if (!param.isRequired) continue;
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Unnecessary usage of hasData() since template has at least one required parameter.", null, node);
            }
        }
    }

    @Override
    protected void visitCallNode(CallNode node) {
        if (!node.isPassingAllData()) {
            this.visitExprHolderHelper(node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            this.visitExprHolderHelper((SoyNode.ExprHolderNode)node);
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void visitExprHolderHelper(SoyNode.ExprHolderNode exprHolder) {
        for (ExprUnion exprUnion : exprHolder.getAllExprUnions()) {
            ExprRootNode<?> expr = exprUnion.getExpr();
            if (this.currFileHasOptParams && !this.usesFunctionHasData && new UsesFunctionHasDataVisitor().exec(expr).booleanValue()) {
                this.usesFunctionHasData = true;
            }
            this.getDataKeysInExprVisitor.exec(expr);
        }
    }

    private static class GetDataKeysInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final Set<String> dataKeys;

        public GetDataKeysInExprVisitor(Set<String> dataKeys) {
            this.dataKeys = dataKeys;
        }

        @Override
        protected void visitDataRefNode(DataRefNode node) {
            if (!node.isIjDataRef() && !node.isLocalVarDataRef().booleanValue()) {
                this.dataKeys.add(node.getFirstKey());
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }

    private static class UsesFunctionHasDataVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private boolean usesFunctionHasData;

        private UsesFunctionHasDataVisitor() {
        }

        @Override
        public Boolean exec(ExprNode node) {
            this.usesFunctionHasData = false;
            this.visit(node);
            return this.usesFunctionHasData;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.getFunctionName().equals("hasData")) {
                this.usesFunctionHasData = true;
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                for (ExprNode child : ((ExprNode.ParentExprNode)node).getChildren()) {
                    if (this.usesFunctionHasData) {
                        return;
                    }
                    this.visit(child);
                }
            }
        }
    }
}

