/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

public class AssertNoExternalCallsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private TemplateRegistry templateRegistry;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode ? 1 : 0) != 0);
        this.templateRegistry = new TemplateRegistry(soyNode.getNearestAncestor(SoyFileSetNode.class));
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        if (this.templateRegistry.getBasicTemplate(node.getCalleeName()) == null) {
            String currFilePath = node.getNearestAncestor(SoyFileNode.class).getFilePath();
            String currTemplateNameForErrorMsg = node.getNearestAncestor(TemplateNode.class).getTemplateNameForUserMsgs();
            throw new SoySyntaxException("In Soy file " + currFilePath + ", template " + currTemplateNameForErrorMsg + ": Encountered call to undefined template '" + node.getCalleeName() + "'.");
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

