/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.shared.restricted.EscapingConventions;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public final class Sanitizers {
    private static final Logger LOGGER = Logger.getLogger(Sanitizers.class.getName());

    private Sanitizers() {
    }

    public static String escapeHtml(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return value.toString();
        }
        return Sanitizers.escapeHtml(value.toString());
    }

    public static String escapeHtml(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String escapeHtmlRcdata(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.normalizeHtml(value.toString());
        }
        return Sanitizers.escapeHtml(value.toString());
    }

    public static String escapeHtmlRcdata(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String normalizeHtml(SoyData value) {
        return Sanitizers.normalizeHtml(value.toString());
    }

    public static String normalizeHtml(String value) {
        return EscapingConventions.NormalizeHtml.INSTANCE.escape(value);
    }

    public static String normalizeHtmlNospace(SoyData value) {
        return Sanitizers.normalizeHtmlNospace(value.toString());
    }

    public static String normalizeHtmlNospace(String value) {
        return EscapingConventions.NormalizeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttribute(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.toString(), true);
        }
        return Sanitizers.escapeHtmlAttribute(value.toString());
    }

    public static String escapeHtmlAttribute(String value) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value);
    }

    public static String escapeHtmlAttributeNospace(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(value.toString(), false);
        }
        return Sanitizers.escapeHtmlAttributeNospace(value.toString());
    }

    public static String escapeHtmlAttributeNospace(String value) {
        return EscapingConventions.EscapeHtmlNospace.INSTANCE.escape(value);
    }

    public static String escapeJsString(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.JS_STR_CHARS)) {
            return value.toString();
        }
        return Sanitizers.escapeJsString(value.toString());
    }

    public static String escapeJsString(String value) {
        return EscapingConventions.EscapeJsString.INSTANCE.escape(value);
    }

    public static String escapeJsValue(SoyData value) {
        if (NullData.INSTANCE == value) {
            return " null ";
        }
        if (value instanceof NumberData) {
            return " " + value.numberValue() + " ";
        }
        if (value instanceof BooleanData) {
            return " " + value.booleanValue() + " ";
        }
        return Sanitizers.escapeJsValue(value.toString());
    }

    public static String escapeJsValue(String value) {
        return value != null ? "'" + Sanitizers.escapeJsString(value) + "'" : " null ";
    }

    public static String escapeJsRegex(SoyData value) {
        return Sanitizers.escapeJsRegex(value.toString());
    }

    public static String escapeJsRegex(String value) {
        return EscapingConventions.EscapeJsRegex.INSTANCE.escape(value);
    }

    public static String escapeCssString(SoyData value) {
        return Sanitizers.escapeCssString(value.toString());
    }

    public static String escapeCssString(String value) {
        return EscapingConventions.EscapeCssString.INSTANCE.escape(value);
    }

    public static String filterCssValue(SoyData value) {
        return NullData.INSTANCE == value ? "" : Sanitizers.filterCssValue(value.toString());
    }

    public static String filterCssValue(String value) {
        if (EscapingConventions.FilterCssValue.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterCssValue received bad value {0}", value);
        return "zSoyz";
    }

    public static String escapeUri(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.URI)) {
            return Sanitizers.filterNormalizeUri(value);
        }
        return Sanitizers.escapeUri(value.toString());
    }

    public static String escapeUri(String value) {
        return CharEscapers.uriEscaper(false).escape(value);
    }

    public static String normalizeUri(SoyData value) {
        return Sanitizers.normalizeUri(value.toString());
    }

    public static String normalizeUri(String value) {
        return EscapingConventions.NormalizeUri.INSTANCE.escape(value);
    }

    public static String filterNormalizeUri(SoyData value) {
        return Sanitizers.filterNormalizeUri(value.toString());
    }

    public static String filterNormalizeUri(String value) {
        if (EscapingConventions.FilterNormalizeUri.INSTANCE.getValueFilter().matcher(value).find()) {
            return EscapingConventions.FilterNormalizeUri.INSTANCE.escape(value);
        }
        LOGGER.log(Level.WARNING, "|filterNormalizeUri received bad value {0}", value);
        return "#zSoyz";
    }

    public static String filterHtmlAttribute(SoyData value) {
        if (Sanitizers.isSanitizedContentOfKind(value, SanitizedContent.ContentKind.HTML_ATTRIBUTE)) {
            String content = value.toString();
            int eqIndex = content.indexOf(61);
            if (eqIndex != -1) {
                switch (content.charAt(content.length() - 1)) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    default: {
                        return content.substring(0, eqIndex) + "=\"" + content.substring(eqIndex + 1) + "\"";
                    }
                }
            }
            return content;
        }
        return Sanitizers.filterHtmlAttribute(value.toString());
    }

    public static String filterHtmlAttribute(String value) {
        if (EscapingConventions.FilterHtmlAttribute.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlAttribute received bad value {0}", value);
        return "zSoyz";
    }

    public static String filterHtmlElementName(SoyData value) {
        return Sanitizers.filterHtmlElementName(value.toString());
    }

    public static String filterHtmlElementName(String value) {
        if (EscapingConventions.FilterHtmlElementName.INSTANCE.getValueFilter().matcher(value).find()) {
            return value;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlElementName received bad value {0}", value);
        return "zSoyz";
    }

    private static boolean isSanitizedContentOfKind(SoyData data, SanitizedContent.ContentKind kind) {
        return data instanceof SanitizedContent && kind == ((SanitizedContent)data).getContentKind();
    }

    @VisibleForTesting
    static String stripHtmlTags(String value, boolean inQuotedAttribute) {
        EscapingConventions.CrossLanguageStringXform normalizer = inQuotedAttribute ? EscapingConventions.NormalizeHtml.INSTANCE : EscapingConventions.NormalizeHtmlNospace.INSTANCE;
        Matcher matcher = EscapingConventions.HTML_TAG_CONTENT.matcher(value);
        if (!matcher.find()) {
            return normalizer.escape(value);
        }
        StringBuilder out = new StringBuilder(value.length() - matcher.end() + matcher.start());
        Appendable normalizedOut = normalizer.escape(out);
        try {
            int pos = 0;
            do {
                normalizedOut.append(value, pos, matcher.start());
                pos = matcher.end();
            } while (matcher.find());
            normalizedOut.append(value, pos, value.length());
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return out.toString();
    }
}

