/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public final class SoyAutoescapeException
extends SoySyntaxException {
    public SoyAutoescapeException(SoyNode node, String message, Throwable cause) {
        super(message, cause);
        if (node != null) {
            this.setContextNode(node);
        }
    }

    public SoyAutoescapeException(SoyNode node, String message) {
        this(node, message, null);
    }

    public SoyAutoescapeException(String message, Throwable cause) {
        this(null, message, cause);
    }

    public SoyAutoescapeException(String message) {
        this(null, message, null);
    }

    public void setContextNode(SoyNode contextNode) {
        SourceLocation location;
        TemplateNode containingTemplate = contextNode.getNearestAncestor(TemplateNode.class);
        if (containingTemplate != null) {
            this.setTemplateName(containingTemplate.getTemplateNameForUserMsgs());
        }
        if ((location = contextNode.getLocation()).isKnown()) {
            this.setSourceLocation(location);
        } else {
            SoyFileNode containingFile = contextNode.getNearestAncestor(SoyFileNode.class);
            this.setFilePath(containingFile.getFilePath());
        }
    }

    public void maybeSetContextNode(SoyNode contextNode) {
        if (!this.getSourceLocation().isKnown()) {
            this.setContextNode(contextNode);
        }
    }
}

