/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.RawTextContextUpdater;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeExceptionWrapper;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class InferenceEngine {
    private final AutoescapeMode autoescapeMode;
    private final Inferences inferences;
    @Nullable
    private final EscapingMode defaultEscapingMode;

    public static Context inferTemplateEndContext(TemplateNode templateNode, Context startContext, Inferences inferences) throws SoyAutoescapeException {
        Context endContext;
        try {
            Context context = startContext;
            AutoescapeMode autoescapeMode = templateNode.getAutoescapeMode();
            for (SoyNode.StandaloneNode child : templateNode.getChildren()) {
                context = new InferenceEngine(autoescapeMode, inferences).infer(child, context);
            }
            endContext = context;
            inferences.recordTemplateEndContext(templateNode.getTemplateName(), endContext);
        }
        catch (SoyAutoescapeExceptionWrapper e) {
            SoyFileNode containingFile;
            SoyAutoescapeException ex = e.getSoyAutoescapeException();
            if (ex.getTemplateName() == null) {
                ex.setTemplateName(templateNode.getTemplateNameForUserMsgs());
            }
            if (!ex.getSourceLocation().isKnown() && (containingFile = templateNode.getNearestAncestor(SoyFileNode.class)) != null) {
                ex.setFilePath(containingFile.getFilePath());
            }
            throw ex;
        }
        return endContext;
    }

    private InferenceEngine(AutoescapeMode autoescapeMode, Inferences inferences) {
        this.autoescapeMode = autoescapeMode;
        this.inferences = inferences;
        this.defaultEscapingMode = autoescapeMode != AutoescapeMode.FALSE ? EscapingMode.ESCAPE_HTML : null;
    }

    private Context infer(SoyNode node, Context context) {
        return new ContextPropagatingVisitor(context).exec(node);
    }

    private final class ContextPropagatingVisitor
    extends AbstractSoyNodeVisitor<Context> {
        private Context context;

        public ContextPropagatingVisitor(Context context) {
            this.context = context;
        }

        @Override
        public Context exec(SoyNode node) {
            this.visit(node);
            return this.context;
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
            Context newContext;
            String rawText = rawTextNode.getRawText();
            try {
                newContext = RawTextContextUpdater.processRawText(rawText, this.context);
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(rawTextNode);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
            if (newContext.isErrorContext()) {
                throw new SoyAutoescapeExceptionWrapper(new SoyAutoescapeException(rawTextNode, "Failed to compute an output context for raw text `" + rawText + "` starting in context " + this.context));
            }
            this.context = newContext;
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            try {
                String calleeName = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : ((CallDelegateNode)callNode).getDelCalleeName();
                Pair<String, Context> derivedNameAndContext = this.inferCallSite(this.context, calleeName, InferenceEngine.this.inferences);
                String derivedCalleeName = (String)derivedNameAndContext.first;
                if (!calleeName.equals(derivedCalleeName)) {
                    InferenceEngine.this.inferences.retargetCall(callNode, derivedCalleeName);
                }
                this.context = (Context)derivedNameAndContext.second;
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(callNode);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
        }

        private Pair<String, Context> inferCallSite(Context startContext, String templateName, Inferences inferences) throws SoyAutoescapeException {
            inferences.recordTemplateChecked(templateName);
            List<TemplateNode> targets = inferences.lookupTemplates(templateName);
            if (targets == null || targets.isEmpty()) {
                return Pair.of(templateName, startContext);
            }
            String suffix = DerivedTemplateUtils.getSuffix(startContext);
            String baseName = DerivedTemplateUtils.getBaseName(templateName);
            String newCalleeName = baseName + suffix;
            Context end = inferences.getTemplateEndContext(newCalleeName);
            if (end != null) {
                return Pair.of(newCalleeName, end);
            }
            List<TemplateNode> templateNodes = inferences.lookupTemplates(newCalleeName);
            if (templateNodes == null) {
                templateNodes = inferences.cloneTemplates(baseName, newCalleeName);
            }
            Inferences inferences2 = new Inferences(inferences);
            inferences2.recordTemplateEndContext(newCalleeName, startContext);
            for (TemplateNode templateNode : templateNodes) {
                Context c = InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences2);
                end = end != null ? Context.union(end, c) : c;
            }
            if (!end.equals(startContext) && inferences2.wasTemplateChecked(newCalleeName)) {
                Inferences inferences3 = new Inferences(inferences);
                inferences3.recordTemplateEndContext(newCalleeName, end);
                Context possibleFixedPoint = null;
                for (TemplateNode templateNode : templateNodes) {
                    Context c = InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences3);
                    possibleFixedPoint = possibleFixedPoint != null ? Context.union(c, possibleFixedPoint) : c;
                }
                if ((end = Context.union(possibleFixedPoint, end)).isErrorContext()) {
                    throw new SoyAutoescapeException(templateNodes.get(0), "Cannot determine end context for recursive template " + templateName);
                }
            }
            inferences2.recordTemplateEndContext(newCalleeName, end);
            inferences2.foldIntoParent();
            return Pair.of(newCalleeName, end);
        }

        @Override
        protected void visitIfNode(IfNode ifNode) {
            this.propagateAcrossDisjunction(ifNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode switchNode) {
            this.propagateAcrossDisjunction(switchNode);
        }

        private void propagateAcrossDisjunction(SoyNode.ParentSoyNode<?> node) {
            try {
                Iterator childIt = node.getChildren().iterator();
                SoyNode firstBranch = (SoyNode)childIt.next();
                Context out = InferenceEngine.this.infer(firstBranch, this.context);
                boolean sawElseOrDefault = false;
                while (childIt.hasNext()) {
                    SoyNode branch = (SoyNode)childIt.next();
                    Context brOut = InferenceEngine.this.infer(branch, this.context);
                    Context combined = Context.union(out, brOut);
                    if (combined.isErrorContext()) {
                        throw new SoyAutoescapeException(branch, (node instanceof IfNode ? "{if} command branch ends in a different context than preceding branches: " : "{switch} command case ends in a different context than preceding cases: ") + branch.toSourceString());
                    }
                    out = combined;
                    if (!(branch instanceof IfElseNode) && !(branch instanceof SwitchDefaultNode)) continue;
                    sawElseOrDefault = true;
                }
                if (!sawElseOrDefault) {
                    Context combined = Context.union(this.context, out);
                    if (combined.isErrorContext()) {
                        throw new SoyAutoescapeException(node, (node instanceof IfNode ? "{if} command without {else} changes context : " : "{switch} command without {default} changes context : ") + node.toSourceString());
                    }
                    out = combined;
                }
                this.context = out;
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(node);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
        }

        @Override
        protected void visitForNode(ForNode forNode) {
            try {
                Context afterBody = this.context;
                for (SoyNode.StandaloneNode child : forNode.getChildren()) {
                    afterBody = InferenceEngine.this.infer(child, afterBody);
                }
                Context combined = Context.union(this.context, afterBody);
                if (combined.isErrorContext()) {
                    throw new SoyAutoescapeException(forNode, "{for} command changes context so it cannot be reentered : " + forNode.toSourceString());
                }
                this.context = combined;
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(forNode);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
        }

        @Override
        protected void visitForeachNode(ForeachNode foreachNode) {
            ForeachIfemptyNode ieNode;
            List foreachChildren = foreachNode.getChildren();
            ForeachNonemptyNode neNode = (ForeachNonemptyNode)foreachChildren.get(0);
            if (foreachChildren.size() == 2) {
                ieNode = (ForeachIfemptyNode)foreachChildren.get(1);
            } else if (foreachChildren.size() == 1) {
                ieNode = null;
            } else {
                throw new AssertionError();
            }
            try {
                Context ifemptyContext;
                Context combined;
                Context afterBody = this.context;
                if (neNode != null) {
                    afterBody = InferenceEngine.this.infer(neNode, this.context);
                    Context elseContext = InferenceEngine.this.infer(neNode, afterBody);
                    combined = Context.union(elseContext, afterBody);
                    if (combined.isErrorContext()) {
                        throw new SoyAutoescapeException(neNode, "{foreach} body does not end in the same context after repeated entries : " + neNode.toSourceString());
                    }
                    afterBody = combined;
                }
                if ((combined = Context.union(ifemptyContext = ieNode != null ? InferenceEngine.this.infer(ieNode, this.context) : this.context, afterBody)).isErrorContext()) {
                    throw new SoyAutoescapeException(ieNode == null ? foreachNode : ieNode, (ieNode == null ? "{foreach} body changes context : " : "{foreach} body does not end in the same context as {ifempty} : ") + foreachNode.toSourceString());
                }
                this.context = combined;
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(foreachNode);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            try {
                ImmutableList escapingModes = InferenceEngine.this.inferences.getEscapingMode(printNode);
                this.context = this.context.getContextBeforeDynamicValue();
                if (escapingModes.isEmpty()) {
                    switch (InferenceEngine.this.autoescapeMode) {
                        case CONTEXTUAL: {
                            escapingModes = this.context.getEscapingModes();
                            InferenceEngine.this.inferences.setEscapingDirectives(printNode, (List<EscapingMode>)escapingModes);
                            break;
                        }
                        case FALSE: {
                            break;
                        }
                        case TRUE: {
                            escapingModes = ImmutableList.of((Object)((Object)InferenceEngine.this.defaultEscapingMode));
                        }
                    }
                } else if (!this.context.isCompatibleWith((EscapingMode)((Object)escapingModes.get(0)))) {
                    throw new SoyAutoescapeException(printNode, "Escaping modes " + escapingModes + " not compatible with " + this.context + " : " + printNode.toSourceString());
                }
                if (!escapingModes.isEmpty() || InferenceEngine.this.autoescapeMode == AutoescapeMode.CONTEXTUAL) {
                    Context newContext = this.context.getContextAfterEscaping(escapingModes.isEmpty() ? null : (EscapingMode)((Object)escapingModes.get(0)));
                    if (newContext.isErrorContext()) {
                        if (this.context.uriPart == Context.UriPart.UNKNOWN || this.context.uriPart == Context.UriPart.UNKNOWN_PRE_FRAGMENT) {
                            throw new SoyAutoescapeException(printNode, "Cannot determine which part of the URL " + printNode.toSourceString() + " is in.");
                        }
                        throw new SoyAutoescapeException(printNode, "Don't put {print} inside comments : " + printNode.toSourceString());
                    }
                    this.context = newContext;
                } else {
                    this.context = RawTextContextUpdater.processRawText("z", this.context);
                }
            }
            catch (SoyAutoescapeException ex) {
                ex.maybeSetContextNode(printNode);
                throw new SoyAutoescapeExceptionWrapper(ex);
            }
        }

        @Override
        protected void visitCssNode(CssNode node) {
            this.context = this.context.getContextBeforeDynamicValue();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

