/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;

public class PrependNamespacesToCalleeNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private String currNamespace;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode ? 1 : 0) != 0);
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.currNamespace = node.getNamespace();
        if (this.currNamespace != null) {
            this.visitChildren(node);
        }
        this.currNamespace = null;
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        Preconditions.checkState((this.currNamespace != null ? 1 : 0) != 0);
        if (node.getCalleeName() == null) {
            node.setCalleeName(this.currNamespace + node.getPartialCalleeName());
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

