/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CheckDelegatesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private TemplateRegistry templateRegistry;
    private String currTemplateNameForUserMsgs;
    private String currDelPackageName;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)(soyNode instanceof SoyFileSetNode));
        this.templateRegistry = new TemplateRegistry((SoyFileSetNode)soyNode);
        this.checkTemplates();
        super.exec(soyNode);
        return null;
    }

    private void checkTemplates() {
        Map<String, TemplateBasicNode> basicTemplatesMap = this.templateRegistry.getBasicTemplatesMap();
        Map<String, List<TemplateRegistry.DelegateTemplateDivision>> delTemplatesMap = this.templateRegistry.getDelegateTemplatesMap();
        Sets.SetView reusedTemplateNames = Sets.intersection(basicTemplatesMap.keySet(), delTemplatesMap.keySet());
        if (reusedTemplateNames.size() > 0) {
            throw new SoySyntaxException(String.format("Found template name %s being reused for both basic and delegate templates.", reusedTemplateNames));
        }
        for (List<TemplateRegistry.DelegateTemplateDivision> divisions : delTemplatesMap.values()) {
            TemplateDelegateNode firstDelTemplate = null;
            HashSet firstSoyDocParamsSet = null;
            for (TemplateRegistry.DelegateTemplateDivision division : divisions) {
                for (TemplateDelegateNode delTemplate : division.delPackageNameToDelTemplateMap.values()) {
                    if (firstDelTemplate == null) {
                        firstDelTemplate = delTemplate;
                        firstSoyDocParamsSet = Sets.newHashSet(delTemplate.getSoyDocParams());
                        continue;
                    }
                    HashSet currSoyDocParamsSet = Sets.newHashSet(delTemplate.getSoyDocParams());
                    if (((Object)currSoyDocParamsSet).equals(firstSoyDocParamsSet)) continue;
                    String firstDelPackageName = firstDelTemplate.getDelPackageName() != null ? firstDelTemplate.getDelPackageName() : "none";
                    String currDelPackageName = delTemplate.getDelPackageName() != null ? delTemplate.getDelPackageName() : "none";
                    throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found delegate templates with same name '%s' but different param declarations in delegate packages '%s' and '%s'.", firstDelTemplate.getDelTemplateName(), firstDelPackageName, currDelPackageName), null, firstDelTemplate);
                }
            }
        }
        for (TemplateBasicNode basicTemplate : basicTemplatesMap.values()) {
            if (basicTemplate.getDelPackageName() == null || basicTemplate.isPrivate()) continue;
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found public template '%s' in delegate package '%s' (must mark as private).", basicTemplate.getTemplateName(), basicTemplate.getDelPackageName()), null, basicTemplate);
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.currTemplateNameForUserMsgs = node.getTemplateNameForUserMsgs();
        this.currDelPackageName = node.getDelPackageName();
        this.visitChildren(node);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        String calleeDelPackageName;
        String calleeName = node.getCalleeName();
        if (this.templateRegistry.getSortedDelegateTemplateDivisions(calleeName) != null) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("In template '%s', found a 'call' referencing a delegate template '%s' (expected 'delcall').", this.currTemplateNameForUserMsgs, calleeName), null, node);
        }
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(calleeName);
        if (callee != null && (calleeDelPackageName = callee.getDelPackageName()) != null && !calleeDelPackageName.equals(this.currDelPackageName)) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found illegal call from '%s' to '%s', which is in a different delegate package.", this.currTemplateNameForUserMsgs, callee.getTemplateName()), null, node);
        }
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        String delCalleeName = node.getDelCalleeName();
        if (this.templateRegistry.getBasicTemplate(delCalleeName) != null) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("In template '%s', found a 'delcall' referencing a basic template '%s' (expected 'call').", this.currTemplateNameForUserMsgs, delCalleeName), null, node);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

