/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.IndentedLinesBuilder;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parseinfo.SoyFileInfo;
import com.google.template.soy.sharedpasses.FindIndirectParamsVisitor;
import com.google.template.soy.sharedpasses.FindUsedIjParamsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerateParseInfoVisitor
extends AbstractSoyNodeVisitor<ImmutableMap<String, String>> {
    private final String javaPackage;
    private final JavaClassNameSource javaClassNameSource;
    private Map<SoyFileNode, String> soyFileToJavaClassNameMap;
    private TemplateRegistry templateRegistry;
    private final Map<String, String> convertedIdents = Maps.newHashMap();
    private LinkedHashMap<String, String> generatedFiles;
    private IndentedLinesBuilder ilb;

    public GenerateParseInfoVisitor(String javaPackage, String javaClassNameSource) {
        this.javaPackage = javaPackage;
        if (javaClassNameSource.equals("filename")) {
            this.javaClassNameSource = JavaClassNameSource.SOY_FILE_NAME;
        } else if (javaClassNameSource.equals("namespace")) {
            this.javaClassNameSource = JavaClassNameSource.SOY_NAMESPACE_LAST_PART;
        } else if (javaClassNameSource.equals("generic")) {
            this.javaClassNameSource = JavaClassNameSource.GENERIC;
        } else {
            throw new IllegalArgumentException("Invalid value for javaClassNameSource \"" + javaClassNameSource + "\"" + " (valid values are \"filename\", \"namespace\", and \"generic\").");
        }
    }

    @Override
    public ImmutableMap<String, String> exec(SoyNode node) {
        this.generatedFiles = Maps.newLinkedHashMap();
        this.ilb = null;
        this.visit(node);
        return ImmutableMap.copyOf(this.generatedFiles);
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        HashMultimap baseGeneratedClassNameToSoyFilesMap = HashMultimap.create();
        for (SoyFileNode soyFile : node.getChildren()) {
            baseGeneratedClassNameToSoyFilesMap.put((Object)this.javaClassNameSource.generateBaseClassName(soyFile), (Object)soyFile);
        }
        this.soyFileToJavaClassNameMap = Maps.newHashMap();
        for (String baseClassName : baseGeneratedClassNameToSoyFilesMap.keySet()) {
            Collection soyFiles = baseGeneratedClassNameToSoyFilesMap.get((Object)baseClassName);
            if (soyFiles.size() == 1) {
                for (SoyFileNode soyFile : soyFiles) {
                    this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + "SoyInfo");
                }
                continue;
            }
            int numberSuffix = 1;
            for (SoyFileNode soyFile : soyFiles) {
                this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + numberSuffix + "SoyInfo");
                ++numberSuffix;
            }
        }
        this.templateRegistry = new TemplateRegistry(node);
        for (SoyFileNode soyFile : node.getChildren()) {
            try {
                this.visit(soyFile);
            }
            catch (SoySyntaxException sse) {
                throw sse.setFilePath(soyFile.getFilePath());
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getFilePath() == null) {
            throw new SoySyntaxException("In order to generate parse info, all Soy files must have paths (file name is extracted from the path).");
        }
        String javaClassName = this.soyFileToJavaClassNameMap.get(node);
        ArrayList publicBasicTemplatePartialNames = Lists.newArrayList();
        HashSet allParamKeys = Sets.newHashSet();
        LinkedHashMultimap paramKeyToTemplatesMultimap = LinkedHashMultimap.create();
        for (TemplateNode template : node.getChildren()) {
            if (!template.isPrivate() && template instanceof TemplateBasicNode) {
                publicBasicTemplatePartialNames.add(template.getPartialTemplateName());
            }
            for (TemplateNode.SoyDocParam param : template.getSoyDocParams()) {
                allParamKeys.add(param.key);
                paramKeyToTemplatesMultimap.put((Object)param.key, (Object)template);
            }
        }
        TreeMap allParamKeysMap = Maps.newTreeMap();
        for (String string : allParamKeys) {
            String upperUnderscoreKey2 = this.convertToUpperUnderscore(string);
            if (allParamKeysMap.containsKey(upperUnderscoreKey2)) {
                throw new SoySyntaxException("Cannot generate parse info because two param keys '" + (String)allParamKeysMap.get(upperUnderscoreKey2) + "' and '" + string + "' generate the same upper-underscore name '" + upperUnderscoreKey2 + "'.");
            }
            allParamKeysMap.put(upperUnderscoreKey2, string);
        }
        this.ilb = new IndentedLinesBuilder(2);
        this.ilb.appendLine("// This file was automatically generated from ", node.getFileName(), ".");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("package ", this.javaPackage, ";");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("import com.google.common.collect.ImmutableList;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableMap;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSortedSet;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyFileInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo.ParamRequisiteness;");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        GenerateParseInfoVisitor.appendJavadoc(this.ilb, "Soy parse info for " + node.getFileName() + ".", true, false);
        this.ilb.appendLine("public class ", javaClassName, " extends SoyFileInfo {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("public static class Param {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Param() {}");
        this.ilb.appendLine(new String[0]);
        for (Map.Entry entry : allParamKeysMap.entrySet()) {
            String upperUnderscoreKey = (String)entry.getKey();
            String key = (String)entry.getValue();
            StringBuilder javadocSb = new StringBuilder();
            javadocSb.append("Listed by ");
            boolean isFirst = true;
            for (TemplateNode template : paramKeyToTemplatesMultimap.get((Object)key)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    javadocSb.append(", ");
                }
                javadocSb.append(GenerateParseInfoVisitor.buildTemplateNameForJavadoc(node, template));
            }
            javadocSb.append(".");
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
            this.ilb.appendLine("public static final String ", upperUnderscoreKey, " = \"", key, "\";");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        for (TemplateNode templateNode : node.getChildren()) {
            try {
                this.visit(templateNode);
            }
            catch (SoySyntaxException sse) {
                throw sse.setTemplateName(templateNode.getTemplateNameForUserMsgs());
            }
        }
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("private ", javaClassName, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(\"", node.getFileName(), "\",");
        this.ilb.setIndentLen(this.ilb.getCurrIndentLen() + 6);
        this.ilb.appendLine("\"", node.getNamespace(), "\",");
        ArrayList itemSnippets = Lists.newArrayList();
        for (String upperUnderscoreKey : allParamKeysMap.keySet()) {
            itemSnippets.add("Param." + upperUnderscoreKey);
        }
        GenerateParseInfoVisitor.appendImmutableSortedSet(this.ilb, "<String>", itemSnippets);
        this.ilb.append(",\n");
        itemSnippets = Lists.newArrayList();
        for (String partialTemplateName : publicBasicTemplatePartialNames) {
            itemSnippets.add(this.convertToUpperUnderscore(partialTemplateName.substring(1)));
        }
        GenerateParseInfoVisitor.appendImmutableList(this.ilb, "<SoyTemplateInfo>", itemSnippets);
        this.ilb.append(",\n");
        SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> sortedMap = new CollectCssNamesVisitor().exec(node);
        ArrayList entrySnippetPairs = Lists.newArrayList();
        for (Map.Entry<String, SoyFileInfo.CssTagsPrefixPresence> entry : sortedMap.entrySet()) {
            entrySnippetPairs.add(Pair.of("\"" + entry.getKey() + "\"", "CssTagsPrefixPresence." + entry.getValue().name()));
        }
        GenerateParseInfoVisitor.appendImmutableMap(this.ilb, "<String, CssTagsPrefixPresence>", entrySnippetPairs);
        this.ilb.append(");\n");
        this.ilb.setIndentLen(this.ilb.getCurrIndentLen() - 6);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("private static final ", javaClassName, " __INSTANCE__ = new ", javaClassName, "();");
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine(new String[0]);
        this.ilb.appendLine("public static ", javaClassName, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new String[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.generatedFiles.put(javaClassName + ".java", this.ilb.toString());
        this.ilb = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.isPrivate() || node instanceof TemplateDelegateNode) {
            return;
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        LinkedHashMap transitiveParams = Maps.newLinkedHashMap();
        for (TemplateNode.SoyDocParam param : node.getSoyDocParams()) {
            transitiveParams.put(param.key, param);
        }
        for (TemplateNode.SoyDocParam param : ipi.indirectParams.values()) {
            TemplateNode.SoyDocParam existingParam = (TemplateNode.SoyDocParam)transitiveParams.get(param.key);
            if (existingParam != null) continue;
            transitiveParams.put(param.key, new TemplateNode.SoyDocParam(param.key, param.isRequired, null));
        }
        String upperUnderscoreName = this.convertToUpperUnderscore(node.getPartialTemplateName().substring(1));
        if (transitiveParams.size() == 0) {
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine(new String[0]);
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, node.getSoyDocDesc(), true, false);
            this.ilb.appendLine("public static final SoyTemplateInfo ", upperUnderscoreName, " = new SoyTemplateInfo(");
            this.ilb.increaseIndent(2);
            this.ilb.appendLine("\"", node.getTemplateName(), "\",");
            this.ilb.appendLine("ImmutableMap.<String, ParamRequisiteness>of(),");
            this.appendUsedIjParams(this.ilb, node);
            this.ilb.append(");\n");
            this.ilb.decreaseIndent(2);
        } else {
            String templateInfoClassName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, upperUnderscoreName) + "SoyTemplateInfo";
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine(new String[0]);
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, node.getSoyDocDesc(), true, false);
            this.ilb.appendLine("public static final ", templateInfoClassName, " ", upperUnderscoreName, " =");
            this.ilb.appendLine("    new ", templateInfoClassName, "();");
            this.ilb.appendLine(new String[0]);
            this.ilb.appendLine("public static class ", templateInfoClassName, " extends SoyTemplateInfo {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("private ", templateInfoClassName, "() {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("super(\"", node.getTemplateName(), "\",");
            this.ilb.increaseIndent(3);
            ArrayList entrySnippetPairs = Lists.newArrayList();
            for (TemplateNode.SoyDocParam param : transitiveParams.values()) {
                entrySnippetPairs.add(Pair.of("\"" + param.key + "\"", param.isRequired ? "ParamRequisiteness.REQUIRED" : "ParamRequisiteness.OPTIONAL"));
            }
            GenerateParseInfoVisitor.appendImmutableMap(this.ilb, "<String, ParamRequisiteness>", entrySnippetPairs);
            this.ilb.append(",\n");
            this.appendUsedIjParams(this.ilb, node);
            this.ilb.append(");\n");
            this.ilb.decreaseIndent(3);
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
            boolean hasSwitchedToIndirectParams = false;
            for (TemplateNode.SoyDocParam param : transitiveParams.values()) {
                if (param.desc != null) {
                    this.ilb.appendLine(new String[0]);
                    GenerateParseInfoVisitor.appendJavadoc(this.ilb, param.desc, false, false);
                } else {
                    if (!hasSwitchedToIndirectParams) {
                        this.ilb.appendLine(new String[0]);
                        this.ilb.appendLine("// Indirect params.");
                        hasSwitchedToIndirectParams = true;
                    }
                    TreeSet sortedJavadocCalleeNames = Sets.newTreeSet();
                    for (TemplateNode transitiveCallee : ipi.paramKeyToCalleesMultimap.get((Object)param.key)) {
                        String javadocCalleeName = GenerateParseInfoVisitor.buildTemplateNameForJavadoc((SoyFileNode)node.getParent(), transitiveCallee);
                        sortedJavadocCalleeNames.add(javadocCalleeName);
                    }
                    StringBuilder javadocSb = new StringBuilder();
                    javadocSb.append("Listed by ");
                    boolean isFirst = true;
                    for (String javadocCalleeName : sortedJavadocCalleeNames) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            javadocSb.append(", ");
                        }
                        javadocSb.append(javadocCalleeName);
                    }
                    javadocSb.append(".");
                    GenerateParseInfoVisitor.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
                }
                this.ilb.appendLine("public final String ", this.convertToUpperUnderscore(param.key), " = \"", param.key, "\";");
            }
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
        }
    }

    private String convertToUpperUnderscore(String ident) {
        String result = this.convertedIdents.get(ident);
        if (result == null) {
            result = BaseUtils.convertToUpperUnderscore(ident);
            this.convertedIdents.put(ident, result);
        }
        return result;
    }

    private static void appendJavadoc(IndentedLinesBuilder ilb, String doc, boolean forceMultiline, boolean wrapAt100Chars) {
        if (wrapAt100Chars) {
            int wrapLen = 100 - ilb.getCurrIndentLen() - 7;
            ArrayList wrappedLines = Lists.newArrayList();
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                while (line.length() > wrapLen) {
                    int spaceIndex = line.lastIndexOf(32, wrapLen);
                    wrappedLines.add(line.substring(0, spaceIndex));
                    line = line.substring(spaceIndex + 1);
                }
                wrappedLines.add(line);
            }
            doc = Joiner.on((String)"\n").join((Iterable)wrappedLines);
        }
        if (doc.contains("\n") || forceMultiline) {
            ilb.appendLine("/**");
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                ilb.appendLine(" * ", line);
            }
            ilb.appendLine(" */");
        } else {
            ilb.appendLine("/** ", doc, " */");
        }
    }

    private void appendUsedIjParams(IndentedLinesBuilder ilb, TemplateNode template) {
        FindUsedIjParamsVisitor.UsedIjParamsInfo uipi = new FindUsedIjParamsVisitor(this.templateRegistry).exec(template);
        ArrayList itemSnippets = Lists.newArrayList();
        for (String paramKey : ImmutableSortedSet.copyOf((Collection)uipi.usedIjParamToCalleesMultimap.keySet())) {
            itemSnippets.add("\"" + paramKey + "\"");
        }
        GenerateParseInfoVisitor.appendImmutableSortedSet(ilb, "<String>", itemSnippets);
    }

    private static String buildTemplateNameForJavadoc(SoyFileNode currSoyFile, TemplateNode template) {
        StringBuilder resultSb = new StringBuilder();
        if (template.getParent() == currSoyFile && !(template instanceof TemplateDelegateNode)) {
            resultSb.append(template.getPartialTemplateName());
        } else {
            resultSb.append(template.getTemplateNameForUserMsgs());
        }
        if (template.isPrivate()) {
            resultSb.append(" (private)");
        }
        if (template instanceof TemplateDelegateNode) {
            resultSb.append(" (delegate)");
        }
        return resultSb.toString();
    }

    private static void appendImmutableList(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        GenerateParseInfoVisitor.appendListOrSetHelper(ilb, "ImmutableList." + typeParamSnippet + "of", itemSnippets);
    }

    private static void appendImmutableSortedSet(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        GenerateParseInfoVisitor.appendListOrSetHelper(ilb, "ImmutableSortedSet." + typeParamSnippet + "of", itemSnippets);
    }

    private static void appendListOrSetHelper(IndentedLinesBuilder ilb, String creationFunctionSnippet, Collection<String> itemSnippets) {
        if (itemSnippets.size() == 0) {
            ilb.appendIndent().appendParts(creationFunctionSnippet, "()");
        } else {
            ilb.appendLine(creationFunctionSnippet, "(");
            boolean isFirst = true;
            for (String item : itemSnippets) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    ilb.append(",\n");
                }
                ilb.appendIndent().appendParts("    ", item);
            }
            ilb.append(")");
        }
    }

    private static void appendImmutableMap(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<Pair<String, String>> entrySnippetPairs) {
        if (entrySnippetPairs.size() == 0) {
            ilb.appendIndent().appendParts("ImmutableMap.", typeParamSnippet, "of()");
        } else {
            ilb.appendLine("ImmutableMap.", typeParamSnippet, "builder()");
            for (Pair<String, String> entrySnippetPair : entrySnippetPairs) {
                ilb.appendLine("    .put(", (String)entrySnippetPair.first, ", ", (String)entrySnippetPair.second, ")");
            }
            ilb.appendIndent().append("    .build()");
        }
    }

    private static class CollectCssNamesVisitor
    extends AbstractSoyNodeVisitor<SortedMap<String, SoyFileInfo.CssTagsPrefixPresence>> {
        private SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> cssNamesMap = Maps.newTreeMap();

        @Override
        public SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> exec(SoyNode node) {
            this.visit(node);
            return this.cssNamesMap;
        }

        @Override
        protected void visitCssNode(CssNode node) {
            SoyFileInfo.CssTagsPrefixPresence additionalCssTagsPrefixPresence;
            String cssName = node.getSelectorText();
            SoyFileInfo.CssTagsPrefixPresence existingCssTagsPrefixPresence = (SoyFileInfo.CssTagsPrefixPresence)((Object)this.cssNamesMap.get(cssName));
            SoyFileInfo.CssTagsPrefixPresence cssTagsPrefixPresence = additionalCssTagsPrefixPresence = node.getComponentNameExpr() == null ? SoyFileInfo.CssTagsPrefixPresence.NEVER : SoyFileInfo.CssTagsPrefixPresence.ALWAYS;
            if (existingCssTagsPrefixPresence == null) {
                this.cssNamesMap.put(cssName, additionalCssTagsPrefixPresence);
            } else if (existingCssTagsPrefixPresence != additionalCssTagsPrefixPresence) {
                this.cssNamesMap.put(cssName, SoyFileInfo.CssTagsPrefixPresence.SOMETIMES);
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    @VisibleForTesting
    static enum JavaClassNameSource {
        SOY_FILE_NAME,
        SOY_NAMESPACE_LAST_PART,
        GENERIC;

        private static final Pattern ALL_UPPER_WORD;
        private static final Pattern ALL_LOWER_WORD;
        private static final Pattern NON_LETTER_DIGIT;

        @VisibleForTesting
        String generateBaseClassName(SoyFileNode soyFile) {
            switch (this) {
                case SOY_FILE_NAME: {
                    String fileName = soyFile.getFileName();
                    if (fileName == null) {
                        throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
                    }
                    if (fileName.toLowerCase().endsWith(".soy")) {
                        fileName = fileName.substring(0, fileName.length() - 4);
                    }
                    return JavaClassNameSource.makeUpperCamelCase(fileName);
                }
                case SOY_NAMESPACE_LAST_PART: {
                    String namespace = soyFile.getNamespace();
                    String namespaceLastPart = namespace.substring(namespace.lastIndexOf(46) + 1);
                    return JavaClassNameSource.makeUpperCamelCase(namespaceLastPart);
                }
                case GENERIC: {
                    return "File";
                }
            }
            throw new AssertionError();
        }

        private static String makeUpperCamelCase(String str) {
            str = JavaClassNameSource.makeWordsCapitalized(str, ALL_UPPER_WORD);
            str = JavaClassNameSource.makeWordsCapitalized(str, ALL_LOWER_WORD);
            str = NON_LETTER_DIGIT.matcher(str).replaceAll("");
            return str;
        }

        private static String makeWordsCapitalized(String str, Pattern wordPattern) {
            StringBuffer sb = new StringBuffer();
            Matcher wordMatcher = wordPattern.matcher(str);
            while (wordMatcher.find()) {
                String oldWord = wordMatcher.group();
                StringBuilder newWord = new StringBuilder();
                int n = oldWord.length();
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        newWord.append(Character.toUpperCase(oldWord.charAt(i)));
                        continue;
                    }
                    newWord.append(Character.toLowerCase(oldWord.charAt(i)));
                }
                wordMatcher.appendReplacement(sb, Matcher.quoteReplacement(newWord.toString()));
            }
            wordMatcher.appendTail(sb);
            return sb.toString();
        }

        static {
            ALL_UPPER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [A-Z]+  (?= [^A-Za-z] | $)", 4);
            ALL_LOWER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [a-z]+  (?= [^a-z] | $)", 4);
            NON_LETTER_DIGIT = Pattern.compile("[^A-Za-z0-9]");
        }
    }
}

