/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SoyMsg {
    private final long id;
    private final String localeString;
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private final String contentType;
    private Set<String> sourcePaths;
    private final List<SoyMsgPart> parts;

    public SoyMsg(long id, @Nullable String localeString, @Nullable String meaning, @Nullable String desc, boolean isHidden, @Nullable String contentType, @Nullable String sourcePath, List<SoyMsgPart> parts) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0);
        this.id = id;
        this.localeString = localeString;
        this.meaning = meaning;
        this.desc = desc;
        this.isHidden = isHidden;
        this.contentType = contentType;
        this.sourcePaths = Sets.newHashSetWithExpectedSize((int)1);
        if (sourcePath != null) {
            this.sourcePaths.add(sourcePath);
        }
        this.parts = ImmutableList.copyOf(parts);
    }

    public String getLocaleString() {
        return this.localeString;
    }

    public long getId() {
        return this.id;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void addSourcePath(String sourcePath) {
        this.sourcePaths.add(sourcePath);
    }

    public Set<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public List<SoyMsgPart> getParts() {
        return this.parts;
    }
}

