/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.restricted;

import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.List;

public class SoyJsCodeUtils {
    private SoyJsCodeUtils() {
    }

    public static JsExpr genJsExprUsingSoySyntax(Operator op, List<JsExpr> operandJsExprs) {
        return SoyJsCodeUtils.genJsExprUsingSoySyntaxWithNewToken(op, operandJsExprs, null);
    }

    public static JsExpr genJsExprUsingSoySyntaxWithNewToken(Operator op, List<JsExpr> operandJsExprs, String newToken) {
        int opPrec = op.getPrecedence();
        boolean isLeftAssociative = op.getAssociativity() == Operator.Associativity.LEFT;
        StringBuilder exprSb = new StringBuilder();
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        int n = syntax.size();
        for (int i = 0; i < n; ++i) {
            Operator.SyntaxElement syntaxEl = syntax.get(i);
            if (syntaxEl instanceof Operator.Operand) {
                int operandIndex = ((Operator.Operand)syntaxEl).getIndex();
                JsExpr operandJsExpr = operandJsExprs.get(operandIndex);
                boolean needsProtection = i == (isLeftAssociative ? 0 : n - 1) ? operandJsExpr.getPrecedence() < opPrec : operandJsExpr.getPrecedence() <= opPrec;
                String subexpr = needsProtection ? "(" + operandJsExpr.getText() + ")" : operandJsExpr.getText();
                exprSb.append(subexpr);
                continue;
            }
            if (syntaxEl instanceof Operator.Token) {
                if (newToken != null) {
                    exprSb.append(newToken);
                    continue;
                }
                exprSb.append(((Operator.Token)syntaxEl).getValue());
                continue;
            }
            if (syntaxEl instanceof Operator.Spacer) {
                exprSb.append(' ');
                continue;
            }
            throw new AssertionError();
        }
        return new JsExpr(exprSb.toString(), opPrec);
    }
}

