/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.restricted;

import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.List;

public class JsExprUtils {
    private JsExprUtils() {
    }

    public static JsExpr concatJsExprs(List<JsExpr> jsExprs) {
        if (jsExprs.size() == 0) {
            return new JsExpr("''", Integer.MAX_VALUE);
        }
        if (jsExprs.size() == 1) {
            return jsExprs.get(0);
        }
        int plusOpPrec = Operator.PLUS.getPrecedence();
        StringBuilder resultSb = new StringBuilder();
        boolean isFirst = true;
        for (JsExpr jsExpr : jsExprs) {
            boolean needsProtection;
            boolean bl = isFirst ? jsExpr.getPrecedence() < plusOpPrec : (needsProtection = jsExpr.getPrecedence() <= plusOpPrec);
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(" + ");
            }
            if (needsProtection) {
                resultSb.append("(").append(jsExpr.getText()).append(")");
                continue;
            }
            resultSb.append(jsExpr.getText());
        }
        return new JsExpr(resultSb.toString(), plusOpPrec);
    }
}

