/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJsExprVisitor
extends AbstractReturningExprNodeVisitor<JsExpr> {
    private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private static final ImmutableSet<String> JS_RESERVED_WORDS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"class", (Object)"const", (Object)"continue", (Object[])new String[]{"debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "null", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "yield"});

    @AssistedInject
    TranslateToJsExprVisitor(Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap, @Assisted Deque<Map<String, JsExpr>> localVarTranslations) {
        this.soyJsSrcFunctionsMap = soyJsSrcFunctionsMap;
        this.localVarTranslations = localVarTranslations;
    }

    @Override
    protected JsExpr visitExprRootNode(ExprRootNode<?> node) {
        return (JsExpr)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected JsExpr visitStringNode(StringNode node) {
        return new JsExpr(JsSrcUtils.escapeUnicodeFormatChars(node.toSourceString()), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new JsExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitListLiteralNode(ListLiteralNode node) {
        StringBuilder exprTextSb = new StringBuilder();
        exprTextSb.append("[");
        boolean isFirst = true;
        for (ExprNode child : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                exprTextSb.append(", ");
            }
            exprTextSb.append(((JsExpr)this.visit(child)).getText());
        }
        exprTextSb.append("]");
        return new JsExpr(exprTextSb.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitMapLiteralNode(MapLiteralNode node) {
        StringBuilder exprTextSb = new StringBuilder();
        exprTextSb.append("{");
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                exprTextSb.append(", ");
            }
            exprTextSb.append(((JsExpr)this.visit(node.getChild(i))).getText()).append(": ").append(((JsExpr)this.visit(node.getChild(i + 1))).getText());
        }
        exprTextSb.append("}");
        return new JsExpr(exprTextSb.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitDataRefNode(DataRefNode node) {
        StringBuilder exprTextSb = new StringBuilder();
        String firstKey = node.getFirstKey();
        if (node.isIjDataRef()) {
            exprTextSb.append("opt_ijData");
            this.appendDataRefKey(exprTextSb, firstKey);
        } else {
            JsExpr translation = this.getLocalVarTranslation(firstKey);
            if (translation != null) {
                exprTextSb.append(translation.getText());
            } else {
                exprTextSb.append("opt_data");
                this.appendDataRefKey(exprTextSb, firstKey);
            }
        }
        int numKeys = node.numChildren();
        if (numKeys > 1) {
            for (int i = 1; i < numKeys; ++i) {
                ExprNode child = node.getChild(i);
                if (child instanceof DataRefKeyNode) {
                    this.appendDataRefKey(exprTextSb, ((DataRefKeyNode)child).getKey());
                    continue;
                }
                if (child instanceof DataRefIndexNode) {
                    exprTextSb.append("[").append(((DataRefIndexNode)child).getIndex()).append("]");
                    continue;
                }
                JsExpr childJsExpr = (JsExpr)this.visit(child);
                exprTextSb.append("[").append(childJsExpr.getText()).append("]");
            }
        }
        return new JsExpr(exprTextSb.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitGlobalNode(GlobalNode node) {
        return new JsExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitNotOpNode(OperatorNodes.NotOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "!");
    }

    @Override
    protected JsExpr visitAndOpNode(OperatorNodes.AndOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "&&");
    }

    @Override
    protected JsExpr visitOrOpNode(OperatorNodes.OrOpNode node) {
        return this.genJsExprUsingSoySyntaxWithNewToken(node, "||");
    }

    @Override
    protected JsExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genJsExprUsingSoySyntax(node);
    }

    @Override
    protected JsExpr visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw new SoySyntaxException("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        SoyJsSrcFunction fn = this.soyJsSrcFunctionsMap.get(fnName);
        if (fn != null) {
            if (!fn.getValidArgsSizes().contains(numArgs)) {
                throw new SoySyntaxException("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            List<JsExpr> args = this.visitChildren(node);
            try {
                return fn.computeForJsSrc(args);
            }
            catch (Exception e) {
                throw new SoySyntaxException("Error in function call \"" + node.toSourceString() + "\": " + e.getMessage(), e);
            }
        }
        throw new SoySyntaxException("Failed to find SoyJsSrcFunction with name '" + fnName + "'" + " (function call \"" + node.toSourceString() + "\").");
    }

    private JsExpr visitIsFirstFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isFirst");
    }

    private JsExpr visitIsLastFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isLast");
    }

    private JsExpr visitIndexFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__index");
    }

    private JsExpr visitHasDataFunction() {
        return new JsExpr("opt_data != null", Operator.NOT_EQUAL.getPrecedence());
    }

    private JsExpr getLocalVarTranslation(String ident) {
        for (Map<String, JsExpr> localVarTranslationsFrame : this.localVarTranslations) {
            JsExpr translation = localVarTranslationsFrame.get(ident);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    private JsExpr genJsExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(opNode, null);
    }

    private JsExpr genJsExprUsingSoySyntaxWithNewToken(ExprNode.OperatorNode opNode, String newToken) {
        List<JsExpr> operandJsExprs = this.visitChildren(opNode);
        return SoyJsCodeUtils.genJsExprUsingSoySyntaxWithNewToken(opNode.getOperator(), operandJsExprs, newToken);
    }

    private void appendDataRefKey(StringBuilder sb, String key) {
        if (JS_RESERVED_WORDS.contains((Object)key)) {
            sb.append("['").append(key).append("']");
        } else {
            sb.append(".").append(key);
        }
    }

    public static interface TranslateToJsExprVisitorFactory {
        public TranslateToJsExprVisitor create(Deque<Map<String, JsExpr>> var1);
    }
}

