/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.List;

class ReplaceMsgsWithGoogMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyJsSrcOptions jsSrcOptions;
    private List<MsgNode> msgNodes;

    @Inject
    public ReplaceMsgsWithGoogMsgsVisitor(SoyJsSrcOptions jsSrcOptions) {
        this.jsSrcOptions = jsSrcOptions;
    }

    @Override
    public Void exec(SoyNode node) {
        this.msgNodes = Lists.newArrayList();
        this.visit(node);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.visitChildren(node);
        IdGenerator nodeIdGen = node.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        for (MsgNode msgNode : this.msgNodes) {
            this.replaceMsgNodeHelper(msgNode, nodeIdGen);
        }
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        this.msgNodes.add(node);
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void replaceMsgNodeHelper(MsgNode msgNode, IdGenerator nodeIdGen) {
        int googMsgNodeId = nodeIdGen.genId();
        String googMsgVarName = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgId(msgNode) : "MSG_UNNAMED_" + googMsgNodeId;
        GoogMsgNode googMsgNode = new GoogMsgNode(googMsgNodeId, msgNode, googMsgVarName);
        GoogMsgRefNode googMsgRefNode = new GoogMsgRefNode(nodeIdGen.genId(), googMsgNode.getRenderedGoogMsgVarName());
        SoyNode.BlockNode parent = msgNode.getParent();
        int msgNodeIndex = parent.getChildIndex(msgNode);
        parent.replaceChild(msgNodeIndex, googMsgNode);
        parent.addChild(msgNodeIndex + 1, googMsgRefNode);
    }
}

