/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.MoveGoogMsgNodesEarlierVisitor;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.jssrc.internal.ReplaceMsgsWithGoogMsgsVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.IsUsingIjDataVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JsSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<ReplaceMsgsWithGoogMsgsVisitor> replaceMsgsWithGoogMsgsVisitorProvider;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJsCodeVisitor> genJsCodeVisitorProvider;

    @Inject
    public JsSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<ReplaceMsgsWithGoogMsgsVisitor> replaceMsgsWithGoogMsgsVisitorProvider, Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider, Provider<GenJsCodeVisitor> genJsCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.replaceMsgsWithGoogMsgsVisitorProvider = replaceMsgsWithGoogMsgsVisitorProvider;
        this.optimizeBidiCodeGenVisitorProvider = optimizeBidiCodeGenVisitorProvider;
        this.genJsCodeVisitorProvider = genJsCodeVisitorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> genJsSrc(SoyFileSetNode soyTree, SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) throws SoySyntaxException {
        boolean isUsingIjData = jsSrcOptions.isUsingIjData() || new IsUsingIjDataVisitor().exec(soyTree);
        Preconditions.checkState((!jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir() || jsSrcOptions.shouldProvideRequireSoyNamespaces() || jsSrcOptions.shouldProvideRequireJsFunctions() ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without either shouldProvideRequireSoyNamespaces or shouldProvideRequireJsFunctions.");
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJsSrcOptions.class, jsSrcOptions);
            this.apiCallScope.seed(Key.get(Boolean.class, ApiCallScopeBindingAnnotations.IsUsingIjData.class), Boolean.valueOf(isUsingIjData));
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromOptions(jsSrcOptions.getBidiGlobalDir(), jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, msgBundle, bidiGlobalDir);
            if (jsSrcOptions.shouldGenerateGoogMsgDefs()) {
                ((ReplaceMsgsWithGoogMsgsVisitor)this.replaceMsgsWithGoogMsgsVisitorProvider.get()).exec(soyTree);
                new MoveGoogMsgNodesEarlierVisitor().exec(soyTree);
                Preconditions.checkState((bidiGlobalDir != null ? 1 : 0) != 0, (Object)"If enabling shouldGenerateGoogMsgDefs, must also set bidi global directionality.");
            } else {
                Preconditions.checkState((bidiGlobalDir == null || bidiGlobalDir.isStaticValue() ? 1 : 0) != 0, (Object)"If using bidiGlobalIsRtlCodeSnippet, must also enable shouldGenerateGoogMsgDefs.");
                try {
                    new InsertMsgsVisitor(msgBundle, false).exec(soyTree);
                }
                catch (InsertMsgsVisitor.EncounteredPluralSelectMsgException e) {
                    throw new SoySyntaxException("JS code generation currently only supports plural/select messages when shouldGenerateGoogMsgDefs is true.");
                }
            }
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyTree);
            this.simplifyVisitor.exec(soyTree);
            List<String> list = ((GenJsCodeVisitor)this.genJsCodeVisitorProvider.get()).exec(soyTree);
            return list;
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, SoyJsSrcOptions jsSrcOptions, @Nullable String locale, @Nullable SoyMsgBundle msgBundle, String outputPathFormat, String inputPathsPrefix) throws SoySyntaxException, IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, jsSrcOptions, msgBundle);
        int numFiles = soyTree.numChildren();
        if (numFiles != jsFileContents.size()) {
            throw new AssertionError();
        }
        ListMultimap outputs = Multimaps.newListMultimap((Map)Maps.newLinkedHashMap(), (Supplier)new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return Lists.newArrayList();
            }
        });
        for (int i = 0; i < numFiles; ++i) {
            SoyFileNode inputFile = (SoyFileNode)soyTree.getChild(i);
            String inputFilePath = inputFile.getFilePath();
            String outputFilePath = JsSrcUtils.buildFilePath(outputPathFormat, locale, inputFilePath, inputPathsPrefix);
            BaseUtils.ensureDirsExistInPath(outputFilePath);
            outputs.put((Object)outputFilePath, (Object)i);
        }
        for (String outputFilePath : outputs.keySet()) {
            BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)Charsets.UTF_8);
            try {
                boolean isFirst = true;
                Iterator i$ = outputs.get((Object)outputFilePath).iterator();
                while (i$.hasNext()) {
                    int inputFileIndex = (Integer)i$.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
            finally {
                ((Writer)out).close();
            }
        }
    }
}

