/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.HasPluralSelectMsgVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.msgs.restricted.IcuSyntaxUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private static final String GOOG_IS_RTL_NAMESPACE = "goog.i18n.bidi";
    private static final String GOOG_MESSAGE_FORMAT_NAMESPACE = "goog.i18n.MessageFormat";
    private final SoyJsSrcOptions jsSrcOptions;
    private final boolean isUsingIjData;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    protected JsCodeBuilder jsCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JsExpr>> localVarTranslations;

    @Inject
    GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, @ApiCallScopeBindingAnnotations.IsUsingIjData boolean isUsingIjData, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = jsSrcOptions;
        this.isUsingIjData = isUsingIjData;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    @Override
    public List<String> exec(SoyNode node) {
        this.jsFilesContents = Lists.newArrayList();
        this.jsCodeBuilder = null;
        this.localVarTranslations = null;
        this.visit(node);
        return this.jsFilesContents;
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode node) {
        super.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList consecChildrenJsExprs = Lists.newArrayList();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChildrenJsExprs.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (consecChildrenJsExprs.size() > 0) {
                this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
                consecChildrenJsExprs.clear();
            }
            this.visit(child);
        }
        if (consecChildrenJsExprs.size() > 0) {
            this.jsCodeBuilder.addToOutputVar(consecChildrenJsExprs);
            consecChildrenJsExprs.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            try {
                this.visit(soyFile);
            }
            catch (SoySyntaxException sse) {
                throw sse.setFilePath(soyFile.getFilePath());
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.jsCodeBuilder = new JsCodeBuilder(this.jsSrcOptions.getCodeStyle());
        this.jsCodeBuilder.appendLine("// This file was automatically generated from ", node.getFileName(), ".");
        this.jsCodeBuilder.appendLine("// Please don't edit this file by hand.");
        if (node.getDelPackageName() != null) {
            this.jsCodeBuilder.appendLine(new String[0]);
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @modName {", node.getDelPackageName(), "}");
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(new String[0]);
        if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            this.addCodeToProvideSoyNamespace(node);
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideJsFunctions(node);
            }
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireSoyNamespaces(node);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                this.addCodeToProvideSoyNamespace(node);
            }
            this.addCodeToProvideJsFunctions(node);
            this.jsCodeBuilder.appendLine(new String[0]);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireJsFunctions(node);
        } else {
            this.addCodeToDefineJsNamespaces(node);
        }
        for (TemplateNode template : node.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(template);
            }
            catch (SoySyntaxException sse) {
                throw sse.setTemplateName(template.getTemplateNameForUserMsgs());
            }
        }
        this.jsFilesContents.add(this.jsCodeBuilder.getCode());
        this.jsCodeBuilder = null;
    }

    private void addCodeToDefineJsNamespaces(SoyFileNode soyFile) {
        TreeSet jsNamespaces = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            String templateName = template.getTemplateName();
            Matcher dotMatcher = DOT.matcher(templateName);
            while (dotMatcher.find()) {
                jsNamespaces.add(templateName.substring(0, dotMatcher.start()));
            }
        }
        for (String jsNamespace : jsNamespaces) {
            boolean hasDot;
            boolean bl = hasDot = jsNamespace.indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !hasDot) continue;
            this.jsCodeBuilder.appendLine("if (typeof ", jsNamespace, " == 'undefined') { ", hasDot ? "" : "var ", jsNamespace, " = {}; }");
        }
    }

    private void addCodeToProvideSoyNamespace(SoyFileNode soyFile) {
        this.jsCodeBuilder.appendLine("goog.provide('", soyFile.getNamespace(), "');");
    }

    private void addCodeToProvideJsFunctions(SoyFileNode soyFile) {
        TreeSet templateNames = Sets.newTreeSet();
        for (TemplateNode template : soyFile.getChildren()) {
            if (template instanceof TemplateBasicNode && ((TemplateBasicNode)template).isOverride()) continue;
            templateNames.add(template.getTemplateName());
        }
        for (String templateName : templateNames) {
            this.jsCodeBuilder.appendLine("goog.provide('", templateName, "');");
        }
    }

    private void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_IS_RTL_NAMESPACE, "');");
        }
        if (new HasPluralSelectMsgVisitor().exec(soyFile).booleanValue()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_MESSAGE_FORMAT_NAMESPACE, "');");
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        String prevCalleeNamespace = null;
        for (String calleeNotInFile : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            if (lastDotIndex == -1) {
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("When using the option to provide/require Soy namespaces, found a called template \"" + calleeNotInFile + "\" that does not reside in a namespace.", null, soyFile);
            }
            String calleeNamespace = calleeNotInFile.substring(0, lastDotIndex);
            if (calleeNamespace.length() <= 0 || calleeNamespace.equals(prevCalleeNamespace)) continue;
            this.jsCodeBuilder.appendLine("goog.require('", calleeNamespace, "');");
            prevCalleeNamespace = calleeNamespace;
        }
    }

    private void addCodeToRequireJsFunctions(SoyFileNode soyFile) {
        for (String calleeNotInFile : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            this.jsCodeBuilder.appendLine("goog.require('", calleeNotInFile, "');");
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean isCodeStyleStringbuilder = this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JsExpr>>();
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_data");
            if (isCodeStyleStringbuilder) {
                this.jsCodeBuilder.appendLine(" * @param {soy.StringBuilder=} opt_sb");
            } else if (this.isUsingIjData) {
                this.jsCodeBuilder.appendLine(" * @param {*=} opt_ignored");
            }
            if (this.isUsingIjData) {
                this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_ijData");
            }
            this.jsCodeBuilder.appendLine(" * @return {string}");
            this.jsCodeBuilder.appendLine(" * @notypecheck");
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(node.getTemplateName(), " = function(opt_data", isCodeStyleStringbuilder ? ", opt_sb" : (this.isUsingIjData ? ", opt_ignored" : ""), this.isUsingIjData ? ", opt_ijData" : "", ") {");
        this.jsCodeBuilder.increaseIndent();
        this.localVarTranslations.push(Maps.newHashMap());
        if (!isCodeStyleStringbuilder && ((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<JsExpr> templateBodyJsExprs = this.genJsExprsVisitor.exec(node);
            JsExpr templateBodyJsExpr = JsExprUtils.concatJsExprs(templateBodyJsExprs);
            this.jsCodeBuilder.appendLine("return ", templateBodyJsExpr.getText(), ";");
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            if (isCodeStyleStringbuilder) {
                this.jsCodeBuilder.appendLine("var output = opt_sb || new soy.StringBuilder();");
                this.jsCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(node);
            if (isCodeStyleStringbuilder) {
                this.jsCodeBuilder.appendLine("return opt_sb ? '' : output.toString();");
            } else {
                this.jsCodeBuilder.appendLine("return output;");
            }
            this.jsCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("};");
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            this.jsCodeBuilder.appendLine("soy.$$registerDelegateFn(soy.$$getDelegateId('", nodeAsDelTemplate.getDelTemplateName(), "'), ", Integer.toString(nodeAsDelTemplate.getDelPriority()), ", ", nodeAsDelTemplate.getTemplateName(), ");");
        }
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode node) {
        GoogMsgCodeGenInfo googMsgCodeGenInfo = new GoogMsgCodeGenInfo();
        this.genGoogMsgCodeForChildren(node, node, googMsgCodeGenInfo);
        String msgTextCode = BaseUtils.escapeToSoyString(googMsgCodeGenInfo.msgTextCodeSb.toString(), false);
        msgTextCode = JsSrcUtils.escapeUnicodeFormatChars(msgTextCode);
        this.jsCodeBuilder.indent().append("/** ");
        if (node.getMeaning() != null) {
            this.jsCodeBuilder.append("@meaning ", node.getMeaning(), "\n");
            this.jsCodeBuilder.indent().append(" *  ");
        }
        this.jsCodeBuilder.append("@desc ", node.getDesc());
        if (node.isHidden()) {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append(" *  @hidden");
        }
        this.jsCodeBuilder.append(" */\n");
        String googMsgName = node.getGoogMsgVarName();
        this.jsCodeBuilder.indent().append("var ", googMsgName, " = goog.getMsg(");
        if (googMsgCodeGenInfo.placeholderCodeBits.size() == 0) {
            this.jsCodeBuilder.append(msgTextCode);
        } else {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append("    ", msgTextCode, ",");
            this.appendCodeBits(googMsgCodeGenInfo.placeholderCodeBits);
        }
        this.jsCodeBuilder.append(");\n");
        if (googMsgCodeGenInfo.pluralSelectVarCodeBits.size() > 0) {
            this.jsCodeBuilder.indent().append("var ", node.getRenderedGoogMsgVarName(), " = (new goog.i18n.MessageFormat(", googMsgName, ")).formatIgnoringPound(");
            this.appendCodeBits(googMsgCodeGenInfo.pluralSelectVarCodeBits);
            this.jsCodeBuilder.append(");\n");
        }
    }

    private void appendCodeBits(List<String> codeBits) {
        boolean isFirst = true;
        for (String codeBit : codeBits) {
            if (isFirst) {
                this.jsCodeBuilder.append("\n");
                this.jsCodeBuilder.indent().append("    {");
                isFirst = false;
            } else {
                this.jsCodeBuilder.append(",\n");
                this.jsCodeBuilder.indent().append("     ");
            }
            this.jsCodeBuilder.append(codeBit);
        }
        this.jsCodeBuilder.append("}");
    }

    private void genGoogMsgCodeForChildren(SoyNode.BlockNode parentNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        if (parentNode instanceof MsgPluralCaseNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseOpenString(((MsgPluralCaseNode)parentNode).getCaseNumber()));
        } else if (parentNode instanceof MsgPluralDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseOpenString(null));
        } else if (parentNode instanceof MsgSelectCaseNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseOpenString(((MsgSelectCaseNode)parentNode).getCaseValue()));
        } else if (parentNode instanceof MsgSelectDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseOpenString(null));
        }
        for (SoyNode.StandaloneNode child : parentNode.getChildren()) {
            if (child instanceof RawTextNode) {
                msgTextCodeSb.append(((RawTextNode)child).getRawText());
                continue;
            }
            if (child instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeForMsgPlaceholderNode((MsgPlaceholderNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralNode) {
                this.genGoogMsgCodeForPluralNode((MsgPluralNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgSelectNode) {
                this.genGoogMsgCodeForSelectNode((MsgSelectNode)child, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralRemainderNode) {
                msgTextCodeSb.append(IcuSyntaxUtils.getPluralRemainderString());
                continue;
            }
            String nodeStringForErrorMsg = parentNode instanceof SoyNode.CommandNode ? "Tag " + ((SoyNode.CommandNode)((Object)parentNode)).getTagString() : "Node " + parentNode.toString();
            throw new SoySyntaxException(nodeStringForErrorMsg + " is not allowed to be a direct child of a 'msg' tag.");
        }
        if (parentNode instanceof MsgPluralCaseNode || parentNode instanceof MsgPluralDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getPluralCaseCloseString());
        } else if (parentNode instanceof MsgSelectCaseNode || parentNode instanceof MsgSelectDefaultNode) {
            msgTextCodeSb.append(IcuSyntaxUtils.getSelectCaseCloseString());
        }
    }

    private void genGoogMsgCodeForPluralNode(MsgPluralNode pluralNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String pluralVarName = googMsgNode.getPluralVarName(pluralNode);
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        msgTextCodeSb.append(IcuSyntaxUtils.getPluralOpenString(pluralVarName, pluralNode.getOffset()));
        this.updatePluralSelectVarCodeBits(googMsgCodeGenInfo, pluralVarName, this.jsExprTranslator.translateToJsExpr(pluralNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode child : pluralNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, googMsgNode, googMsgCodeGenInfo);
        }
        msgTextCodeSb.append(IcuSyntaxUtils.getPluralCloseString());
    }

    private void genGoogMsgCodeForSelectNode(MsgSelectNode selectNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String selectVarName = googMsgNode.getSelectVarName(selectNode);
        StringBuilder msgTextCodeSb = googMsgCodeGenInfo.msgTextCodeSb;
        msgTextCodeSb.append(IcuSyntaxUtils.getSelectOpenString(selectVarName));
        this.updatePluralSelectVarCodeBits(googMsgCodeGenInfo, selectVarName, this.jsExprTranslator.translateToJsExpr(selectNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode child : selectNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, googMsgNode, googMsgCodeGenInfo);
        }
        msgTextCodeSb.append(IcuSyntaxUtils.getSelectCloseString());
    }

    private void genGoogMsgCodeForMsgPlaceholderNode(MsgPlaceholderNode node, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String placeholderName = googMsgNode.getPlaceholderName(node);
        String googMsgPlaceholderName = this.genGoogMsgPlaceholderName(placeholderName);
        googMsgCodeGenInfo.msgTextCodeSb.append("{$").append(googMsgPlaceholderName).append("}");
        this.updatePlaceholderCodeBits(googMsgCodeGenInfo, placeholderName, googMsgPlaceholderName, this.genGoogMsgPlaceholderExpr(node).getText());
    }

    private void updatePluralSelectVarCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String pluralSelectVarName, String exprText) {
        if (googMsgCodeGenInfo.seenPluralSelectVarNames.contains(pluralSelectVarName)) {
            return;
        }
        googMsgCodeGenInfo.seenPluralSelectVarNames.add(pluralSelectVarName);
        String placeholderCodeBit = "'" + pluralSelectVarName + "': " + exprText;
        googMsgCodeGenInfo.pluralSelectVarCodeBits.add(placeholderCodeBit);
    }

    private void updatePlaceholderCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String placeholderName, String googMsgPlaceholderName, String exprText) {
        if (googMsgCodeGenInfo.seenPlaceholderNames.contains(placeholderName)) {
            return;
        }
        googMsgCodeGenInfo.seenPlaceholderNames.add(placeholderName);
        String placeholderCodeBit = "'" + googMsgPlaceholderName + "': " + exprText;
        googMsgCodeGenInfo.placeholderCodeBits.add(placeholderCodeBit);
    }

    private String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    private JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPhNode) {
        ArrayList contentJsExprs = Lists.newArrayList();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                this.visit(contentNode);
                contentJsExprs.add(new JsExpr("htmlTag" + contentNode.getId(), Integer.MAX_VALUE));
                continue;
            }
            if (contentNode instanceof CallNode) {
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    this.visit(grandchild);
                }
                contentJsExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
                continue;
            }
            contentJsExprs.addAll(this.genJsExprsVisitor.exec(contentNode));
        }
        return JsExprUtils.concatJsExprs(contentJsExprs);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("htmlTag" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        JsExpr valueJsExpr = this.jsExprTranslator.translateToJsExpr(node.getValueExpr(), null, this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", generatedVarName, " = ", valueJsExpr.getText(), ";");
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine(generatedVarName, " = ", generatedVarName, ".toString();");
        }
        this.localVarTranslations.peek().put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
            return;
        }
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JsExpr condJsExpr = this.jsExprTranslator.translateToJsExpr(icn.getExprUnion().getExpr(), icn.getExprText(), this.localVarTranslations);
                if (icn.getCommandName().equals("if")) {
                    this.jsCodeBuilder.appendLine("if (", condJsExpr.getText(), ") {");
                } else {
                    this.jsCodeBuilder.appendLine("} else if (", condJsExpr.getText(), ") {");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(icn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof IfElseNode) {
                IfElseNode ien = (IfElseNode)child;
                this.jsCodeBuilder.appendLine("} else {");
                this.jsCodeBuilder.increaseIndent();
                this.visit(ien);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        JsExpr switchValueJsExpr = this.jsExprTranslator.translateToJsExpr(node.getExpr(), node.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("switch (", switchValueJsExpr.getText(), ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprRootNode<?> caseExpr : scn.getExprList()) {
                    JsExpr caseJsExpr = this.jsExprTranslator.translateToJsExpr(caseExpr, null, this.localVarTranslations);
                    this.jsCodeBuilder.appendLine("case ", caseJsExpr.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(scn);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(sdn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        String baseVarName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        String listVarName = baseVarName + "List" + nodeId;
        String listLenVarName = baseVarName + "ListLen" + nodeId;
        JsExpr dataRefJsExpr = this.jsExprTranslator.translateToJsExpr(node.getExpr(), node.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", listVarName, " = ", dataRefJsExpr.getText(), ";");
        this.jsCodeBuilder.appendLine("var ", listLenVarName, " = ", listVarName, ".length;");
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.jsCodeBuilder.appendLine("if (", listLenVarName, " > 0) {");
            this.jsCodeBuilder.increaseIndent();
        }
        this.visit((SoyNode)node.getChild(0));
        if (hasIfemptyNode) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {");
            this.jsCodeBuilder.increaseIndent();
            this.visit((SoyNode)node.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String listLenVarName = baseVarName + "ListLen" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.jsCodeBuilder.appendLine("for (var ", indexVarName, " = 0; ", indexVarName, " < ", listLenVarName, "; ", indexVarName, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", dataVarName, " = ", listVarName, "[", indexVarName, "];");
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(baseVarName, new JsExpr(dataVarName, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__isFirst", new JsExpr(indexVarName + " == 0", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__isLast", new JsExpr(indexVarName + " == " + listLenVarName + " - 1", Operator.EQUAL.getPrecedence()));
        newLocalVarTranslationsFrame.put(baseVarName + "__index", new JsExpr(indexVarName, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode node) {
        String incrementCode;
        String limitCode;
        String initCode;
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        ArrayList rangeArgs = Lists.newArrayList(node.getRangeArgs());
        String incrementJsExprText = rangeArgs.size() == 3 ? this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.remove(2), null, this.localVarTranslations).getText() : "1";
        String initJsExprText = rangeArgs.size() == 2 ? this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.remove(0), null, this.localVarTranslations).getText() : "0";
        String limitJsExprText = this.jsExprTranslator.translateToJsExpr((ExprNode)rangeArgs.get(0), null, this.localVarTranslations).getText();
        if (INTEGER.matcher(initJsExprText).matches()) {
            initCode = initJsExprText;
        } else {
            initCode = varName + "Init" + nodeId;
            this.jsCodeBuilder.appendLine("var ", initCode, " = ", initJsExprText, ";");
        }
        if (INTEGER.matcher(limitJsExprText).matches()) {
            limitCode = limitJsExprText;
        } else {
            limitCode = varName + "Limit" + nodeId;
            this.jsCodeBuilder.appendLine("var ", limitCode, " = ", limitJsExprText, ";");
        }
        if (INTEGER.matcher(incrementJsExprText).matches()) {
            incrementCode = incrementJsExprText;
        } else {
            incrementCode = varName + "Increment" + nodeId;
            this.jsCodeBuilder.appendLine("var ", incrementCode, " = ", incrementJsExprText, ";");
        }
        String incrementStmt = incrementCode.equals("1") ? varName + nodeId + "++" : varName + nodeId + " += " + incrementCode;
        this.jsCodeBuilder.appendLine("for (var ", varName, nodeId, " = ", initCode, "; ", varName, nodeId, " < ", limitCode, "; ", incrementStmt, ") {");
        this.jsCodeBuilder.increaseIndent();
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(varName, new JsExpr(varName + nodeId, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            JsExpr objToPass = this.genCallCodeUtils.genObjToPass(node, this.localVarTranslations);
            String calleeExprText = node instanceof CallBasicNode ? ((CallBasicNode)node).getCalleeName() : "soy.$$getDelegateFn(soy.$$getDelegateId('" + ((CallDelegateNode)node).getDelCalleeName() + "'))";
            this.jsCodeBuilder.indent().append(calleeExprText, "(", objToPass.getText(), ", ").appendOutputVarName().append(this.isUsingIjData ? ", opt_ijData" : "").append(");\n");
        } else {
            JsExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations);
            this.jsCodeBuilder.addToOutputVar((List<JsExpr>)ImmutableList.of((Object)callExpr));
        }
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVarTranslations.push(Maps.newHashMap());
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVarTranslations.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    private class GoogMsgCodeGenInfo {
        public StringBuilder msgTextCodeSb = new StringBuilder();
        public List<String> placeholderCodeBits = Lists.newArrayList();
        public Set<String> seenPlaceholderNames = Sets.newHashSet();
        public List<String> pluralSelectVarCodeBits = Lists.newArrayList();
        public Set<String> seenPluralSelectVarNames = Sets.newHashSet();
    }
}

