/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class GenCallCodeUtils {
    private final SoyJsSrcOptions jsSrcOptions;
    private final boolean isUsingIjData;
    private final JsExprTranslator jsExprTranslator;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    @Inject
    GenCallCodeUtils(SoyJsSrcOptions jsSrcOptions, @ApiCallScopeBindingAnnotations.IsUsingIjData boolean isUsingIjData, JsExprTranslator jsExprTranslator, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = jsSrcOptions;
        this.isUsingIjData = isUsingIjData;
        this.jsExprTranslator = jsExprTranslator;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    public JsExpr genCallExpr(CallNode callNode, Deque<Map<String, JsExpr>> localVarTranslations) {
        String calleeExprText = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : "soy.$$getDelegateFn(soy.$$getDelegateId('" + ((CallDelegateNode)callNode).getDelCalleeName() + "'))";
        JsExpr objToPass = this.genObjToPass(callNode, localVarTranslations);
        return new JsExpr(calleeExprText + "(" + objToPass.getText() + (this.isUsingIjData ? ", null, opt_ijData" : "") + ")", Integer.MAX_VALUE);
    }

    public JsExpr genObjToPass(CallNode callNode, Deque<Map<String, JsExpr>> localVarTranslations) {
        JsExpr dataToPass = callNode.isPassingAllData() ? new JsExpr("opt_data", Integer.MAX_VALUE) : (callNode.isPassingData() ? this.jsExprTranslator.translateToJsExpr(callNode.getExpr(), callNode.getExprText(), localVarTranslations) : new JsExpr("null", Integer.MAX_VALUE));
        if (callNode.numChildren() == 0) {
            return dataToPass;
        }
        StringBuilder paramsObjSb = new StringBuilder();
        paramsObjSb.append("{");
        boolean isFirst = true;
        for (CallParamNode child : callNode.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                paramsObjSb.append(", ");
            }
            String key = child.getKey();
            paramsObjSb.append(key).append(": ");
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                JsExpr valueJsExpr = this.jsExprTranslator.translateToJsExpr(cpvn.getValueExprUnion().getExpr(), cpvn.getValueExprText(), localVarTranslations);
                paramsObjSb.append(valueJsExpr.getText());
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                List<JsExpr> cpcnJsExprs = this.genJsExprsVisitorFactory.create(localVarTranslations).exec(cpcn);
                JsExpr valueJsExpr = JsExprUtils.concatJsExprs(cpcnJsExprs);
                paramsObjSb.append(valueJsExpr.getText());
                continue;
            }
            if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
                paramsObjSb.append("param").append(cpcn.getId()).append(".toString()");
                continue;
            }
            paramsObjSb.append("param").append(cpcn.getId());
        }
        paramsObjSb.append("}");
        if (callNode.isPassingData()) {
            return new JsExpr("soy.$$augmentData(" + dataToPass.getText() + ", " + paramsObjSb.toString() + ")", Integer.MAX_VALUE);
        }
        return new JsExpr(paramsObjSb.toString(), Integer.MAX_VALUE);
    }
}

