/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJavaExprVisitor
extends AbstractReturningExprNodeVisitor<JavaExpr> {
    private final Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;

    @AssistedInject
    TranslateToJavaExprVisitor(Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap, @Assisted Deque<Map<String, JavaExpr>> localVarTranslations) {
        this.soyJavaSrcFunctionsMap = soyJavaSrcFunctionsMap;
        this.localVarTranslations = localVarTranslations;
    }

    @Override
    protected JavaExpr visitExprRootNode(ExprRootNode<?> node) {
        return (JavaExpr)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected JavaExpr visitNullNode(NullNode node) {
        return new JavaExpr("com.google.template.soy.data.restricted.NullData.INSTANCE", NullData.class, Integer.MAX_VALUE);
    }

    @Override
    protected JavaExpr visitBooleanNode(BooleanNode node) {
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitIntegerNode(IntegerNode node) {
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitFloatNode(FloatNode node) {
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitStringNode(StringNode node) {
        return this.convertStringResult(JavaCodeUtils.genNewStringData('\"' + CharEscapers.javaStringEscaper().escape(node.getValue()) + '\"'));
    }

    @Override
    protected JavaExpr visitListLiteralNode(ListLiteralNode node) {
        return this.convertListResult(JavaCodeUtils.genNewListData(this.buildCommaSepChildrenListHelper(node)));
    }

    @Override
    protected JavaExpr visitMapLiteralNode(MapLiteralNode node) {
        return this.convertMapResult(JavaCodeUtils.genNewMapData(this.buildCommaSepChildrenListHelper(node)));
    }

    private String buildCommaSepChildrenListHelper(ExprNode.ParentExprNode node) {
        StringBuilder resultSb = new StringBuilder();
        boolean isFirst = true;
        for (ExprNode child : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(", ");
            }
            resultSb.append(((JavaExpr)this.visit(child)).getText());
        }
        return resultSb.toString();
    }

    @Override
    protected JavaExpr visitDataRefNode(DataRefNode node) {
        if (node.isIjDataRef()) {
            return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("this.$$getIjData", this.buildKeyStringExprText(node, 0)));
        }
        JavaExpr translation = this.getLocalVarTranslation(node.getFirstKey());
        if (translation != null) {
            if (node.numChildren() == 1) {
                return translation;
            }
            return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", JavaCodeUtils.genMaybeCast(translation, CollectionData.class), this.buildKeyStringExprText(node, 1)));
        }
        return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", "data", this.buildKeyStringExprText(node, 0)));
    }

    private String buildKeyStringExprText(DataRefNode node, int startIndex) {
        ArrayList keyStrParts = Lists.newArrayList();
        StringBuilder currStringLiteralPart = new StringBuilder();
        for (int i = startIndex; i < node.numChildren(); ++i) {
            ExprNode child = node.getChild(i);
            if (i != startIndex) {
                currStringLiteralPart.append(".");
            }
            if (child instanceof DataRefKeyNode) {
                currStringLiteralPart.append(CharEscapers.javaStringEscaper().escape(((DataRefKeyNode)child).getKey()));
                continue;
            }
            if (child instanceof DataRefIndexNode) {
                currStringLiteralPart.append(Integer.toString(((DataRefIndexNode)child).getIndex()));
                continue;
            }
            JavaExpr childJavaExpr = (JavaExpr)this.visit(child);
            keyStrParts.add("\"" + currStringLiteralPart.toString() + "\"");
            keyStrParts.add(JavaCodeUtils.genMaybeProtect(childJavaExpr, Integer.MAX_VALUE) + ".toString()");
            currStringLiteralPart = new StringBuilder();
        }
        if (currStringLiteralPart.length() > 0) {
            keyStrParts.add("\"" + currStringLiteralPart.toString() + "\"");
        }
        return Joiner.on((String)" + ").join((Iterable)keyStrParts);
    }

    @Override
    protected JavaExpr visitGlobalNode(GlobalNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected JavaExpr visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        JavaExpr operand = (JavaExpr)this.visit(node.getChild(0));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genIntegerValue(operand)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genFloatValue(operand)));
        if (JavaCodeUtils.isAlwaysInteger(operand)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysFloat(operand)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$negative", JavaCodeUtils.genMaybeCast(operand, NumberData.class)));
    }

    @Override
    protected JavaExpr visitNotOpNode(OperatorNodes.NotOpNode node) {
        JavaExpr operand = (JavaExpr)this.visit(node.getChild(0));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genUnaryOp("!", JavaCodeUtils.genCoerceBoolean(operand))));
    }

    @Override
    protected JavaExpr visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        return this.visitNumberToNumberBinaryOpHelper(node, "*", "$$times");
    }

    @Override
    protected JavaExpr visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("/", JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1))));
    }

    @Override
    protected JavaExpr visitModOpNode(OperatorNodes.ModOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("%", JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1))));
    }

    @Override
    protected JavaExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        String stringComputation = JavaCodeUtils.genNewStringData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genCoerceString(operand0), JavaCodeUtils.genCoerceString(operand1)));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneString(operand0, operand1)) {
            return this.convertStringResult(stringComputation);
        }
        if (JavaCodeUtils.isAlwaysTwoFloatsOrOneFloatOneInteger(operand0, operand1)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$plus", operand0.getText(), operand1.getText()));
    }

    @Override
    protected JavaExpr visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        return this.visitNumberToNumberBinaryOpHelper(node, "-", "$$minus");
    }

    @Override
    protected JavaExpr visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, "<", "$$lessThan");
    }

    @Override
    protected JavaExpr visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, ">", "$$greaterThan");
    }

    @Override
    protected JavaExpr visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, "<=", "$$lessThanOrEqual");
    }

    @Override
    protected JavaExpr visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, ">=", "$$greaterThanOrEqual");
    }

    @Override
    protected JavaExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genMaybeProtect(operand0, Integer.MAX_VALUE) + ".equals(" + operand1.getText() + ")"));
    }

    @Override
    protected JavaExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData("! " + JavaCodeUtils.genMaybeProtect(operand0, Integer.MAX_VALUE) + ".equals(" + operand1.getText() + ")"));
    }

    @Override
    protected JavaExpr visitAndOpNode(OperatorNodes.AndOpNode node) {
        return this.visitBooleanToBooleanBinaryOpHelper(node, "&&");
    }

    @Override
    protected JavaExpr visitOrOpNode(OperatorNodes.OrOpNode node) {
        return this.visitBooleanToBooleanBinaryOpHelper(node, "||");
    }

    @Override
    protected JavaExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        JavaExpr operand2 = (JavaExpr)this.visit(node.getChild(2));
        Class<?> type1 = operand1.getType();
        Class<?> type2 = operand2.getType();
        Class<?> resultType = null;
        for (Class<?> type = type1; type != null; type = type.getSuperclass()) {
            if (!type.isAssignableFrom(type2)) continue;
            resultType = type;
            break;
        }
        if (resultType == null) {
            throw new AssertionError();
        }
        return new JavaExpr(JavaCodeUtils.genCoerceBoolean(operand0) + " ? " + JavaCodeUtils.genMaybeProtect(operand1, Operator.CONDITIONAL.getPrecedence() + 1) + " : " + JavaCodeUtils.genMaybeProtect(operand2, Operator.CONDITIONAL.getPrecedence() + 1), resultType, Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    protected JavaExpr visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw new SoySyntaxException("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        SoyJavaSrcFunction fn = this.soyJavaSrcFunctionsMap.get(fnName);
        if (fn != null) {
            if (!fn.getValidArgsSizes().contains(numArgs)) {
                throw new SoySyntaxException("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            List<JavaExpr> args = this.visitChildren(node);
            try {
                return fn.computeForJavaSrc(args);
            }
            catch (Exception e) {
                throw new SoySyntaxException("Error in function call \"" + node.toSourceString() + "\": " + e.getMessage(), e);
            }
        }
        throw new SoySyntaxException("Failed to find SoyJavaSrcFunction with name '" + fnName + "'" + " (function call \"" + node.toSourceString() + "\").");
    }

    private JavaExpr visitIsFirstFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isFirst");
    }

    private JavaExpr visitIsLastFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isLast");
    }

    private JavaExpr visitIndexFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__index");
    }

    private JavaExpr visitHasDataFunction() {
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData("data != null"));
    }

    private JavaExpr convertBooleanResult(String exprText) {
        return new JavaExpr(exprText, BooleanData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertIntegerResult(String exprText) {
        return new JavaExpr(exprText, IntegerData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertFloatResult(String exprText) {
        return new JavaExpr(exprText, FloatData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertNumberResult(String exprText) {
        return new JavaExpr(exprText, NumberData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertStringResult(String exprText) {
        return new JavaExpr(exprText, StringData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertListResult(String exprText) {
        return new JavaExpr(exprText, SoyListData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertMapResult(String exprText) {
        return new JavaExpr(exprText, SoyMapData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertUnknownResult(String exprText) {
        return new JavaExpr(exprText, SoyData.class, Integer.MAX_VALUE);
    }

    private JavaExpr visitBooleanToBooleanBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genCoerceBoolean(operand0), JavaCodeUtils.genCoerceBoolean(operand1))));
    }

    private JavaExpr visitNumberToNumberBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken, String utilsLibFnName) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(operand0, operand1)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + utilsLibFnName, JavaCodeUtils.genMaybeCast(operand0, NumberData.class), JavaCodeUtils.genMaybeCast(operand1, NumberData.class)));
    }

    private JavaExpr visitNumberToBooleanBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken, String utilsLibFnName) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        String integerComputation = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertBooleanResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(operand0, operand1)) {
            return this.convertBooleanResult(floatComputation);
        }
        return this.convertBooleanResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + utilsLibFnName, JavaCodeUtils.genMaybeCast(operand0, NumberData.class), JavaCodeUtils.genMaybeCast(operand1, NumberData.class)));
    }

    private JavaExpr getLocalVarTranslation(String ident) {
        for (Map<String, JavaExpr> localVarTranslationsFrame : this.localVarTranslations) {
            JavaExpr translation = localVarTranslationsFrame.get(ident);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    public static interface TranslateToJavaExprVisitorFactory {
        public TranslateToJavaExprVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

