/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenJavaCodeVisitor;
import com.google.template.soy.javasrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import javax.annotation.Nullable;

public class JavaSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJavaCodeVisitor> genJavaCodeVisitorProvider;

    @Inject
    public JavaSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider, Provider<GenJavaCodeVisitor> genJavaCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.optimizeBidiCodeGenVisitorProvider = optimizeBidiCodeGenVisitorProvider;
        this.genJavaCodeVisitorProvider = genJavaCodeVisitorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String genJavaSrc(SoyFileSetNode soyTree, SoyJavaSrcOptions javaSrcOptions, @Nullable SoyMsgBundle msgBundle) throws SoySyntaxException {
        try {
            new InsertMsgsVisitor(msgBundle, false).exec(soyTree);
        }
        catch (InsertMsgsVisitor.EncounteredPluralSelectMsgException e) {
            throw new SoySyntaxException("JavaSrc backend doesn't support plural/select messages.");
        }
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJavaSrcOptions.class, javaSrcOptions);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDir(javaSrcOptions.getBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, msgBundle, bidiGlobalDir);
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyTree);
            this.simplifyVisitor.exec(soyTree);
            String string = ((GenJavaCodeVisitor)this.genJavaCodeVisitorProvider.get()).exec(soyTree);
            return string;
        }
        finally {
            this.apiCallScope.exit();
        }
    }
}

