/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.javasrc.SoyTemplateRuntime;
import com.google.template.soy.javasrc.dyncompile.AbstractSoyTemplateRuntime;
import com.google.template.soy.javasrc.dyncompile.DynamicCompilerJavaFileManager;
import com.google.template.soy.javasrc.dyncompile.ReadableInMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.SoyTemplateClassLoader;
import com.google.template.soy.javasrc.dyncompile.WritableInMemoryJavaFileObject;
import com.google.template.soy.shared.SoyCssRenamingMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public final class SoyToJavaDynamicCompiler {
    static final String PACKAGE_FOR_COMPILED_SOY = "com.google.template.soy.javasrc.dyncompiled";
    private static final Logger LOGGER = Logger.getLogger(SoyToJavaDynamicCompiler.class.getName());

    public static ImmutableMap<String, SoyTemplateRuntime> compile(String bundleName, String javaClassBody) {
        if (!BaseUtils.isDottedIdentifier(bundleName)) {
            throw new IllegalArgumentException("Bundle name should be a dotted identifier, not " + bundleName);
        }
        String javaSourceCode = Joiner.on((char)'\n').join((Object)"package com.google.template.soy.javasrc.dyncompiled;", (Object)("public final class " + bundleName + " {"), new Object[]{"  private final " + SoyMapData.class.getName() + " $$ijData;", "  private final " + SoyCssRenamingMap.class.getName() + " $$cssRenamingMap;", "  public " + bundleName + "(", "      " + SoyMapData.class.getName() + " ijData,", "      " + SoyCssRenamingMap.class.getName() + " cssRenamingMap) {", "    this.$$ijData = ijData;", "    this.$$cssRenamingMap = cssRenamingMap;", "  }", "  private String $$renameCss(String selectorText) {", "    return $$cssRenamingMap.get(selectorText);", "  }", "  private " + SoyData.class.getName() + " $$getIjData(String key) {", "    return $$ijData.get(key);", "  }", javaClassBody, "}"});
        DiagnosticListener<JavaFileObject> diagnosticListener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                StringBuilder message = new StringBuilder();
                JavaFileObject src = diagnostic.getSource();
                if (src != null) {
                    message.append(src.getName()).append(':').append(diagnostic.getLineNumber()).append('+').append(diagnostic.getColumnNumber()).append(": ");
                }
                message.append(diagnostic.getMessage(Locale.getDefault()));
                switch (diagnostic.getKind()) {
                    case ERROR: 
                    case OTHER: {
                        LOGGER.severe(message.toString());
                        break;
                    }
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        LOGGER.warning(message.toString());
                        break;
                    }
                }
            }
        };
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DynamicCompilerJavaFileManager fileManager = new DynamicCompilerJavaFileManager(javaCompiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnosticListener, Locale.getDefault(), Charsets.UTF_8));
        String className = "com.google.template.soy.javasrc.dyncompiled." + bundleName;
        ReadableInMemoryJavaFileObject inputFile = new ReadableInMemoryJavaFileObject("/src/" + className.replace('.', '/') + ".java", javaSourceCode);
        fileManager.addInput(inputFile);
        boolean wasSuccessfullyCompiled = javaCompiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)diagnosticListener, (Iterable<String>)ImmutableList.of(), (Iterable<String>)ImmutableList.of(), (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)inputFile)).call();
        if (wasSuccessfullyCompiled) {
            SoyTemplateClassLoader templateClassLoader = new SoyTemplateClassLoader();
            for (WritableInMemoryJavaFileObject outputClass : fileManager.getOutputFiles()) {
                templateClassLoader.defineClassCompiledFromSoy(outputClass.getByteContent());
            }
            ImmutableMap.Builder runtimes = ImmutableMap.builder();
            try {
                Constructor<?> ctor;
                Class<?> compiledClass = templateClassLoader.loadClass(className);
                try {
                    ctor = compiledClass.getDeclaredConstructor(SoyMapData.class, SoyCssRenamingMap.class);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException("Could not find ctor for generated java class " + compiledClass);
                }
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    throw new AssertionError((Object)ctor.toString());
                }
                for (final Method method : compiledClass.getDeclaredMethods()) {
                    Class<?>[] paramTypes;
                    int modifiers = method.getModifiers();
                    if (!Modifier.isPublic(modifiers) || (paramTypes = method.getParameterTypes()).length != 2 || !paramTypes[0].isAssignableFrom(SoyMapData.class) || !paramTypes[1].isAssignableFrom(StringBuilder.class)) continue;
                    for (Class<?> thrownType : method.getExceptionTypes()) {
                        if (!Error.class.isAssignableFrom(thrownType) && RuntimeException.class.isAssignableFrom(thrownType)) continue;
                    }
                    String methodName = method.getName();
                    final String templateName = methodName.replace('$', '.');
                    runtimes.put((Object)templateName, (Object)new AbstractSoyTemplateRuntime(){

                        @Override
                        protected void renderMain(SoyMapData data, SoyMapData ijData, SoyCssRenamingMap cssRenamingMap, StringBuilder out) {
                            try {
                                method.invoke(ctor.newInstance(ijData, cssRenamingMap), data, out);
                            }
                            catch (InvocationTargetException ex) {
                                Throwables.propagate((Throwable)ex.getTargetException());
                            }
                            catch (InstantiationException ex) {
                                Throwables.propagate((Throwable)ex);
                            }
                            catch (IllegalAccessException ex) {
                                Throwables.propagate((Throwable)ex);
                            }
                        }

                        public String toString() {
                            return "[SoyTemplateRuntime " + templateName + "]";
                        }
                    });
                }
            }
            catch (ClassNotFoundException ex) {
                Throwables.propagate((Throwable)ex);
            }
            return runtimes.build();
        }
        System.err.println("Java code\n" + javaSourceCode + "\n");
        throw new RuntimeException();
    }

    private SoyToJavaDynamicCompiler() {
    }
}

