/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

final class ClasspathJavaFileObject
implements JavaFileObject {
    private final String resourcePath;

    ClasspathJavaFileObject(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public URI toUri() {
        try {
            return ClasspathJavaFileObject.class.getResource(this.resourcePath).toURI();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public String getName() {
        return this.resourcePath.substring(this.resourcePath.lastIndexOf(47) + 1);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        InputStream in = ClasspathJavaFileObject.class.getResourceAsStream(this.resourcePath);
        if (in == null) {
            throw new FileNotFoundException(this.resourcePath);
        }
        return in;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IOException("Not writable");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new IOException("Binary");
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new IOException("Binary");
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IOException("Not writable");
    }

    @Override
    public long getLastModified() {
        return 31557600000L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != this.getKind()) {
            return false;
        }
        String name = this.getName();
        int dotIndex = name.indexOf(46);
        String nameWithoutExtension = dotIndex >= 0 ? name.substring(0, dotIndex) : name;
        return kind == this.getKind() && simpleName.equals(nameWithoutExtension);
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.resourcePath;
    }
}

