/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import java.util.regex.Pattern;

public class BidiUtils {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");
    public static final String RIGHT = "right";
    public static final String LEFT = "left";

    private BidiUtils() {
    }

    public static Dir languageDir(String languageString) {
        return BidiUtils.isRtlLanguage(languageString) ? Dir.RTL : Dir.LTR;
    }

    public static boolean isRtlLanguage(String languageString) {
        return languageString != null && RtlLocalesRe.matcher(languageString).find();
    }

    public static boolean hasAnyLtr(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyLtr(false);
    }

    public static boolean hasAnyLtr(String str) {
        return BidiUtils.hasAnyLtr(str, false);
    }

    public static boolean hasAnyRtl(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyRtl(false);
    }

    public static boolean hasAnyRtl(String str) {
        return BidiUtils.hasAnyRtl(str, false);
    }

    public static boolean startsWithLtr(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).firstStrong(true) == Dir.LTR;
    }

    public static boolean startsWithLtr(String str) {
        return BidiUtils.startsWithLtr(str, false);
    }

    public static boolean startsWithRtl(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).firstStrong(true) == Dir.RTL;
    }

    public static boolean startsWithRtl(String str) {
        return BidiUtils.startsWithRtl(str, false);
    }

    public static boolean endsWithLtr(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).lastStrong(true) == Dir.LTR;
    }

    public static boolean endsWithLtr(String str) {
        return BidiUtils.endsWithLtr(str, false);
    }

    public static boolean endsWithRtl(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).lastStrong(true) == Dir.RTL;
    }

    public static boolean endsWithRtl(String str) {
        return BidiUtils.endsWithRtl(str, false);
    }

    public static Dir estimateDirection(String str) {
        return BidiUtils.estimateDirection(str, false);
    }

    public static Dir estimateDirection(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).estimateDirectionByWordCount();
    }

    static class DirectionalityEstimator
    extends DirTypeIterator {
        private static final double RTL_THRESHOLD = 0.4;
        private int ltrWordCount;
        private int rtlWordCount;
        private int weakLtrWordCount;
        private int embedLevel;
        private int wordType;

        public DirectionalityEstimator(String text, boolean isHtml) {
            super(text, isHtml);
        }

        public Dir estimateDirectionByWordCount() {
            this.rewind(false);
            this.ltrWordCount = 0;
            this.rtlWordCount = 0;
            this.weakLtrWordCount = 0;
            this.embedLevel = 0;
            this.wordType = 0;
            block12: while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 2: {
                        this.strongWord(true);
                        continue block12;
                    }
                    case 0: {
                        if (this.wordType == 0 && this.getLastChar() == 'h' && (this.matchForward("ttp://", true) || this.matchForward("ttps://", true))) {
                            this.wordType = 3;
                            ++this.weakLtrWordCount;
                            continue block12;
                        }
                        this.strongWord(false);
                        continue block12;
                    }
                    case 3: 
                    case 6: {
                        if (this.wordType >= 1) continue block12;
                        ++this.weakLtrWordCount;
                        this.wordType = 1;
                        continue block12;
                    }
                    case 11: 
                    case 12: {
                        if (this.wordType >= 4) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 10: {
                        this.embedLevel = 0;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 15: {
                        this.strongWord(false);
                    }
                    case 14: {
                        if (this.embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 17: {
                        this.strongWord(true);
                    }
                    case 16: {
                        if (this.embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 18: {
                        if (--this.embedLevel != 0) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                }
            }
            if ((double)this.rtlWordCount > (double)(this.ltrWordCount + this.rtlWordCount) * 0.4) {
                return Dir.RTL;
            }
            if (this.ltrWordCount + this.weakLtrWordCount > 0) {
                return Dir.LTR;
            }
            return Dir.UNKNOWN;
        }

        private void strongWord(boolean isRightToLeft) {
            if (this.wordType < 2) {
                if (isRightToLeft) {
                    ++this.rtlWordCount;
                } else {
                    ++this.ltrWordCount;
                }
                if (this.wordType == 1) {
                    --this.weakLtrWordCount;
                }
                this.wordType = 2;
            }
        }

        public boolean hasAnyLtr(boolean countEmbedding) {
            this.rewind(false);
            int embeddingLevel = 0;
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 16: 
                    case 17: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 18: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        public boolean hasAnyRtl(boolean countEmbedding) {
            this.rewind(false);
            int embeddingLevel = 0;
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 2: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 16: 
                    case 17: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 18: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        public Dir firstStrong(boolean countEmbedding) {
            this.rewind(false);
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        return Dir.LTR;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding) break;
                        return Dir.LTR;
                    }
                    case 1: 
                    case 2: {
                        return Dir.RTL;
                    }
                    case 16: 
                    case 17: {
                        if (!countEmbedding) break;
                        return Dir.RTL;
                    }
                }
            }
            return Dir.UNKNOWN;
        }

        public Dir lastStrong(boolean countEmbedding) {
            this.rewind(true);
            int embeddingLevel = 0;
            while (!this.atStart()) {
                switch (this.dirTypeBackward()) {
                    case 0: {
                        if (embeddingLevel != 0) break;
                        return Dir.LTR;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding || --embeddingLevel != 0) break;
                        return Dir.LTR;
                    }
                    case 1: 
                    case 2: {
                        if (embeddingLevel != 0) break;
                        return Dir.RTL;
                    }
                    case 16: 
                    case 17: {
                        if (!countEmbedding || --embeddingLevel != 0) break;
                        return Dir.RTL;
                    }
                    case 18: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                    }
                }
            }
            return Dir.UNKNOWN;
        }

        private static class WordType {
            public static final int NEUTRAL = 0;
            public static final int NUMERIC = 1;
            public static final int STRONG = 2;
            public static final int URL = 3;
            public static final int EMBEDDED = 4;

            private WordType() {
            }
        }
    }

    static class DirTypeIterator {
        private static final int DIR_TYPE_CACHE_SIZE = 1792;
        private static final byte UNKNOWN_DIR_TYPE = 127;
        private static byte[] dirTypeCache = new byte[1792];
        private CharSequence text;
        private int length;
        private boolean isHtml;
        private int charIndex;
        private char lastChar;

        private static byte getCachedDirectionality(char c) {
            if (c >= '\u0700') {
                return Character.getDirectionality(c);
            }
            byte dirType = dirTypeCache[c];
            if (dirType == 127) {
                DirTypeIterator.dirTypeCache[c] = dirType = Character.getDirectionality(c);
            }
            return dirType;
        }

        public DirTypeIterator(CharSequence text, boolean isHtml) {
            this.text = text;
            this.isHtml = isHtml;
            this.length = text.length();
            this.rewind(false);
        }

        public boolean atEnd() {
            return this.charIndex == this.length;
        }

        public boolean atStart() {
            return this.charIndex == 0;
        }

        public char getLastChar() {
            return this.lastChar;
        }

        public void rewind(boolean toEnd) {
            this.charIndex = toEnd ? this.length : 0;
            this.lastChar = (char)55296;
        }

        public char charForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            this.charIndex = Character.isHighSurrogate(this.lastChar) ? (this.charIndex += Character.charCount(Character.codePointAt(this.text, this.charIndex))) : ++this.charIndex;
            return this.lastChar;
        }

        public char charBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            this.charIndex = Character.isLowSurrogate(this.lastChar) ? (this.charIndex -= Character.charCount(Character.codePointBefore(this.text, this.charIndex))) : --this.charIndex;
            return this.lastChar;
        }

        public boolean matchForward(CharSequence match, boolean advance) {
            int matchLength = match.length();
            if (matchLength > this.length - this.charIndex) {
                return false;
            }
            for (int checkIndex = 0; checkIndex < matchLength; ++checkIndex) {
                if (this.text.charAt(this.charIndex + checkIndex) == match.charAt(checkIndex)) continue;
                return false;
            }
            if (advance) {
                this.charIndex += matchLength;
            }
            return true;
        }

        public byte dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (Character.isHighSurrogate(this.lastChar)) {
                int codePoint = Character.codePointAt(this.text, this.charIndex);
                this.charIndex += Character.charCount(codePoint);
                return Character.getDirectionality(codePoint);
            }
            ++this.charIndex;
            byte dirType = DirTypeIterator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '<') {
                    dirType = this.skipTagForward();
                } else if (this.lastChar == '&') {
                    dirType = this.skipEntityForward();
                }
            }
            return dirType;
        }

        public byte dirTypeBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            if (Character.isLowSurrogate(this.lastChar)) {
                int codePoint = Character.codePointBefore(this.text, this.charIndex);
                this.charIndex -= Character.charCount(codePoint);
                return Character.getDirectionality(codePoint);
            }
            --this.charIndex;
            byte dirType = DirTypeIterator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '>') {
                    dirType = this.skipTagBackward();
                } else if (this.lastChar == ';') {
                    dirType = this.skipEntityBackward();
                }
            }
            return dirType;
        }

        private byte skipTagForward() {
            char c;
            while (!this.atEnd() && (c = this.charForward()) != '>') {
                if (c != '\"' && c != '\'') continue;
                while (!this.atEnd() && this.charForward() != c) {
                }
            }
            return 12;
        }

        private byte skipTagBackward() {
            int initialCharIndex = this.charIndex;
            while (!this.atStart()) {
                char c = this.charBackward();
                if (c == '<') {
                    return 12;
                }
                if (c == '>') break;
                if (c != '\"' && c != '\'') continue;
                while (!this.atStart() && this.charBackward() != c) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)62;
            return 13;
        }

        private byte skipEntityForward() {
            while (!this.atEnd() && this.charForward() != ';') {
            }
            return 12;
        }

        private byte skipEntityBackward() {
            int initialCharIndex = this.charIndex;
            while (!this.atStart()) {
                char c = this.charBackward();
                if (c == '&') {
                    return 12;
                }
                if (c != ';') continue;
                break;
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)59;
            return 13;
        }

        static {
            for (int i = 0; i < 1792; ++i) {
                DirTypeIterator.dirTypeCache[i] = 127;
            }
        }
    }

    public static final class Format {
        public static final char LRE = '\u202a';
        public static final char RLE = '\u202b';
        public static final char PDF = '\u202c';
        public static final char LRM = '\u200e';
        public static final char RLM = '\u200f';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    public static enum Dir {
        LTR(1),
        UNKNOWN(0),
        RTL(-1);

        public final int ord;

        private Dir(int ord) {
            this.ord = ord;
        }

        public static Dir valueOf(int dir) {
            return dir > 0 ? LTR : (dir < 0 ? RTL : UNKNOWN);
        }

        public static Dir valueOf(boolean dir) {
            return dir ? RTL : LTR;
        }

        public boolean isOppositeTo(Dir dir) {
            return this.ord * dir.ord < 0;
        }
    }
}

