/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.internal.i18n.BidiUtils;
import java.util.Locale;

public class BidiFormatter {
    private BidiUtils.Dir contextDir;
    private boolean alwaysSpan;

    public static BidiFormatter getInstance(BidiUtils.Dir contextDir, boolean alwaysSpan) {
        return new BidiFormatter(contextDir, alwaysSpan);
    }

    public static BidiFormatter getInstance(BidiUtils.Dir contextDir) {
        return BidiFormatter.getInstance(contextDir, false);
    }

    public static BidiFormatter getInstance(boolean rtlContext, boolean alwaysSpan) {
        return new BidiFormatter(rtlContext ? BidiUtils.Dir.RTL : BidiUtils.Dir.LTR, alwaysSpan);
    }

    public static BidiFormatter getInstance(boolean rtlContext) {
        return BidiFormatter.getInstance(rtlContext, false);
    }

    public static BidiFormatter getInstance(Locale locale, boolean alwaysSpan) {
        return BidiFormatter.getInstance(BidiUtils.languageDir(locale.toString()), alwaysSpan);
    }

    public static BidiFormatter getInstance(Locale locale) {
        return BidiFormatter.getInstance(locale, false);
    }

    private BidiFormatter(BidiUtils.Dir contextDir, boolean alwaysSpan) {
        this.contextDir = contextDir;
        this.alwaysSpan = alwaysSpan;
    }

    public BidiUtils.Dir getContextDir() {
        return this.contextDir;
    }

    public boolean isRtlContext() {
        return this.contextDir == BidiUtils.Dir.RTL;
    }

    public boolean getAlwaysSpan() {
        return this.alwaysSpan;
    }

    public String dirAttrValue(String str, boolean isHtml) {
        return this.knownDirAttrValue(BidiFormatter.estimateDirection(str, isHtml));
    }

    public String dirAttrValue(String str) {
        return this.dirAttrValue(str, false);
    }

    public String knownDirAttrValue(BidiUtils.Dir dir) {
        if (dir == BidiUtils.Dir.UNKNOWN) {
            dir = this.contextDir;
        }
        return dir == BidiUtils.Dir.RTL ? "rtl" : "ltr";
    }

    public String dirAttr(String str, boolean isHtml) {
        return this.knownDirAttr(BidiFormatter.estimateDirection(str, isHtml));
    }

    public String dirAttr(String str) {
        return this.dirAttr(str, false);
    }

    public String knownDirAttr(BidiUtils.Dir dir) {
        if (dir != this.contextDir) {
            return dir == BidiUtils.Dir.LTR ? "dir=ltr" : (dir == BidiUtils.Dir.RTL ? "dir=rtl" : "");
        }
        return "";
    }

    public String spanWrap(String str, boolean isHtml, boolean dirReset) {
        BidiUtils.Dir dir = BidiFormatter.estimateDirection(str, isHtml);
        return this.spanWrapWithKnownDir(dir, str, isHtml, dirReset);
    }

    public String spanWrap(String str, boolean isHtml) {
        return this.spanWrap(str, isHtml, true);
    }

    public String spanWrap(String str) {
        return this.spanWrap(str, false, true);
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String str, boolean isHtml, boolean dirReset) {
        boolean dirCondition = dir != BidiUtils.Dir.UNKNOWN && dir != this.contextDir;
        String origStr = str;
        if (!isHtml) {
            str = CharEscapers.asciiHtmlEscaper().escape(str);
        }
        StringBuilder result = new StringBuilder();
        if (this.alwaysSpan || dirCondition) {
            result.append("<span");
            if (dirCondition) {
                result.append(" ");
                result.append(dir == BidiUtils.Dir.RTL ? "dir=rtl" : "dir=ltr");
            }
            result.append(">" + str + "</span>");
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(origStr, dir, isHtml, dirReset));
        return result.toString();
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String str, boolean isHtml) {
        return this.spanWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String str) {
        return this.spanWrapWithKnownDir(dir, str, false, true);
    }

    public String unicodeWrap(String str, boolean isHtml, boolean dirReset) {
        BidiUtils.Dir dir = BidiFormatter.estimateDirection(str, isHtml);
        return this.unicodeWrapWithKnownDir(dir, str, isHtml, dirReset);
    }

    public String unicodeWrap(String str, boolean isHtml) {
        return this.unicodeWrap(str, isHtml, true);
    }

    public String unicodeWrap(String str) {
        return this.unicodeWrap(str, false, true);
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String str, boolean isHtml, boolean dirReset) {
        StringBuilder result = new StringBuilder();
        if (dir != BidiUtils.Dir.UNKNOWN && dir != this.contextDir) {
            result.append(dir == BidiUtils.Dir.RTL ? (char)'\u202b' : '\u202a');
            result.append(str);
            result.append('\u202c');
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(str, dir, isHtml, dirReset));
        return result.toString();
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String str, boolean isHtml) {
        return this.unicodeWrapWithKnownDir(dir, str, isHtml, true);
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String str) {
        return this.unicodeWrapWithKnownDir(dir, str, false, true);
    }

    public String markAfter(String str, boolean isHtml) {
        return this.dirResetIfNeeded(str, BidiFormatter.estimateDirection(str, isHtml), isHtml, true);
    }

    public String markAfter(String str) {
        return this.markAfter(str, false);
    }

    public String mark() {
        return this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Format.LRM_STRING : (this.contextDir == BidiUtils.Dir.RTL ? BidiUtils.Format.RLM_STRING : "");
    }

    public String startEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "right" : "left";
    }

    public String endEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "left" : "right";
    }

    public static BidiUtils.Dir estimateDirection(String str, boolean isHtml) {
        return BidiUtils.estimateDirection(str, isHtml);
    }

    public static BidiUtils.Dir estimateDirection(String str) {
        return BidiUtils.estimateDirection(str);
    }

    private String dirResetIfNeeded(String str, BidiUtils.Dir dir, boolean isHtml, boolean dirReset) {
        if (dirReset && (this.contextDir == BidiUtils.Dir.LTR && (dir == BidiUtils.Dir.RTL || BidiUtils.endsWithRtl(str, isHtml)) || this.contextDir == BidiUtils.Dir.RTL && (dir == BidiUtils.Dir.LTR || BidiUtils.endsWithLtr(str, isHtml)))) {
            return this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Format.LRM_STRING : BidiUtils.Format.RLM_STRING;
        }
        return "";
    }
}

