/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.ExprNode;

public class DataRefNode
extends AbstractParentExprNode {
    private final boolean isIjDataRef;
    private Boolean isLocalVarDataRef;

    public DataRefNode(boolean isIjDataRef) {
        this.isIjDataRef = isIjDataRef;
        this.isLocalVarDataRef = null;
    }

    protected DataRefNode(DataRefNode orig) {
        super(orig);
        this.isIjDataRef = orig.isIjDataRef;
        this.isLocalVarDataRef = orig.isLocalVarDataRef;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.DATA_REF_NODE;
    }

    public boolean isIjDataRef() {
        return this.isIjDataRef;
    }

    public void setIsLocalVarDataRef(Boolean isLocalVarDataRef) {
        this.isLocalVarDataRef = isLocalVarDataRef;
    }

    public Boolean isLocalVarDataRef() {
        return this.isLocalVarDataRef;
    }

    public String getFirstKey() {
        return ((DataRefKeyNode)this.getChild(0)).getKey();
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        boolean isFirst = true;
        for (ExprNode child : this.getChildren()) {
            if (isFirst) {
                sourceSb.append(this.isIjDataRef ? "$ij." : "$").append(child.toSourceString());
                isFirst = false;
                continue;
            }
            if (child instanceof DataRefKeyNode || child instanceof DataRefIndexNode) {
                sourceSb.append('.').append(child.toSourceString());
                continue;
            }
            sourceSb.append('[').append(child.toSourceString()).append(']');
        }
        return sourceSb.toString();
    }

    @Override
    public DataRefNode clone() {
        return new DataRefNode(this);
    }
}

