/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.restricted.CollectionData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SoyMapData
extends CollectionData {
    private final Map<String, SoyData> map;

    public SoyMapData() {
        this.map = Maps.newHashMap();
    }

    public SoyMapData(Map<String, ?> data) {
        this.map = Maps.newHashMapWithExpectedSize((int)data.size());
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            String key;
            try {
                key = entry.getKey();
            }
            catch (ClassCastException cce) {
                throw new SoyDataException("Attempting to convert a map with non-string key to Soy data (key type " + entry.getKey().getClass().getName() + ").");
            }
            Object value = entry.getValue();
            try {
                this.map.put(key, SoyData.createFromExistingData(value));
            }
            catch (SoyDataException sde) {
                sde.prependKeyToDataPath(key);
                throw sde;
            }
        }
    }

    public SoyMapData(Object ... data) {
        this();
        this.put(data);
    }

    public Map<String, SoyData> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public String toString() {
        return this.toStringHelper(this.map);
    }

    protected String toStringHelper(Map<String, SoyData> map) {
        StringBuilder mapStr = new StringBuilder();
        mapStr.append('{');
        boolean isFirst = true;
        for (Map.Entry<String, SoyData> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                mapStr.append(", ");
            }
            mapStr.append(entry.getKey()).append(": ").append(entry.getValue().toString());
        }
        mapStr.append("}");
        return mapStr.toString();
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public void putSingle(String key, SoyData value) {
        this.map.put(key, value);
    }

    @Override
    public void removeSingle(String key) {
        this.map.remove(key);
    }

    @Override
    public SoyData getSingle(String key) {
        return this.map.get(key);
    }
}

