/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.List;
import java.util.Map;

public abstract class SoyData {
    public static SoyData createFromExistingData(Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        if (obj instanceof SoyData) {
            return (SoyData)obj;
        }
        if (obj instanceof String) {
            return StringData.forValue((String)obj);
        }
        if (obj instanceof Boolean) {
            return BooleanData.forValue((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return IntegerData.forValue((Integer)obj);
        }
        if (obj instanceof Map) {
            Map objCast = (Map)obj;
            return new SoyMapData(objCast);
        }
        if (obj instanceof List) {
            return new SoyListData((List)obj);
        }
        if (obj instanceof Double) {
            return FloatData.forValue((Double)obj);
        }
        if (obj instanceof Float) {
            return FloatData.forValue(((Float)obj).floatValue());
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy data (object type " + obj.getClass().getName() + ").");
    }

    public abstract String toString();

    public abstract boolean toBoolean();

    public abstract boolean equals(Object var1);

    public boolean booleanValue() {
        throw new SoyDataException("Non-boolean found when expecting boolean value.");
    }

    public int integerValue() {
        throw new SoyDataException("Non-integer found when expecting integer value.");
    }

    public double floatValue() {
        throw new SoyDataException("Non-float found when expecting float value.");
    }

    public double numberValue() {
        throw new SoyDataException("Non-number found when expecting number value.");
    }

    public String stringValue() {
        throw new SoyDataException("Non-string found when expecting string value.");
    }
}

