/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.EscapingConventions;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class EscapeHtmlDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    public static final String NAME = "|escapeHtml";

    @Inject
    public EscapeHtmlDirective() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public String apply(SoyData value, List<SoyData> args) {
        SanitizedContent sanitizedContent;
        if (value instanceof SanitizedContent && (sanitizedContent = (SanitizedContent)value).getContentKind() == SanitizedContent.ContentKind.HTML) {
            return sanitizedContent.getContent();
        }
        return EscapingConventions.EscapeHtml.INSTANCE.escape(value.toString());
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$escapeHtml(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$escapeHtml", value.getText()), String.class, Integer.MAX_VALUE);
    }
}

