/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.BidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class BidiTextDirFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    BidiTextDirFunction() {
    }

    @Override
    public String getName() {
        return "bidiTextDir";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> args) {
        String text = args.get(0).stringValue();
        boolean isHtml = args.size() == 2 ? args.get(1).booleanValue() : false;
        return SoyJavaRuntimeFunctionUtils.toSoyData(BidiUtils.estimateDirection((String)text, (boolean)isHtml).ord);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr text = args.get(0);
        JsExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = isHtml != null ? "soy.$$bidiTextDir(" + text.getText() + ", " + isHtml.getText() + ")" : "soy.$$bidiTextDir(" + text.getText() + ")";
        return new JsExpr(callText, Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> args) {
        JavaExpr text = args.get(0);
        JavaExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String bidiFunctionName = BidiUtils.class.getName() + ".estimateDirection";
        return SoyJavaSrcFunctionUtils.toIntegerJavaExpr(JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genFunctionCall(bidiFunctionName, JavaCodeUtils.genCoerceString(text), isHtml != null ? JavaCodeUtils.genCoerceBoolean(isHtml) : "false") + ".ord"));
    }
}

