/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class BidiDirAttrFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiDirAttrFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "bidiDirAttr";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> args) {
        String text = args.get(0).stringValue();
        boolean isHtml = args.size() == 2 ? args.get(1).booleanValue() : false;
        int bidiGlobalDir = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue();
        return new SanitizedContent(SoyBidiUtils.getBidiFormatter(bidiGlobalDir).dirAttr(text, isHtml), SanitizedContent.ContentKind.HTML_ATTRIBUTE);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr text = args.get(0);
        JsExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = "soy.$$bidiDirAttr(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ", " + text.getText() + (isHtml != null ? ", " + isHtml.getText() : "") + ")";
        return new JsExpr(callText, Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> args) {
        JavaExpr text = args.get(0);
        JavaExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String bidiFunctionName = SoyBidiUtils.class.getName() + ".getBidiFormatter(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ").dirAttr";
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewSanitizedContent(JavaCodeUtils.genFunctionCall(bidiFunctionName, JavaCodeUtils.genCoerceString(text), isHtml != null ? JavaCodeUtils.genCoerceBoolean(isHtml) : "false"), SanitizedContent.ContentKind.HTML_ATTRIBUTE));
    }
}

