/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
@SoyPureFunction
class RoundFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    RoundFunction() {
    }

    @Override
    public String getName() {
        return "round";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> args) {
        int numDigitsAfterPt;
        SoyData value = args.get(0);
        int n = numDigitsAfterPt = args.size() == 2 ? args.get(1).integerValue() : 0;
        if (numDigitsAfterPt == 0) {
            if (value instanceof IntegerData) {
                return SoyJavaRuntimeFunctionUtils.toSoyData(value.integerValue());
            }
            return SoyJavaRuntimeFunctionUtils.toSoyData((int)Math.round(value.numberValue()));
        }
        if (numDigitsAfterPt > 0) {
            double valueDouble = value.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPt);
            return SoyJavaRuntimeFunctionUtils.toSoyData((double)Math.round(valueDouble * shift) / shift);
        }
        double valueDouble = value.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPt);
        return SoyJavaRuntimeFunctionUtils.toSoyData((int)((double)Math.round(valueDouble / shift) * shift));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr value = args.get(0);
        JsExpr numDigitsAfterPt = args.size() == 2 ? args.get(1) : null;
        int numDigitsAfterPtAsInt = 0;
        if (numDigitsAfterPt != null) {
            try {
                numDigitsAfterPtAsInt = Integer.parseInt(numDigitsAfterPt.getText());
            }
            catch (NumberFormatException nfe) {
                numDigitsAfterPtAsInt = Integer.MIN_VALUE;
            }
        }
        if (numDigitsAfterPtAsInt == 0) {
            return new JsExpr("Math.round(" + value.getText() + ")", Integer.MAX_VALUE);
        }
        if (numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 || numDigitsAfterPtAsInt == Integer.MIN_VALUE) {
            String shiftExprText = numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 ? "1" + "000000000000".substring(0, numDigitsAfterPtAsInt) : "Math.pow(10, " + numDigitsAfterPt.getText() + ")";
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueTimesShift = SoyJsCodeUtils.genJsExprUsingSoySyntax(Operator.TIMES, Lists.newArrayList((Object[])new JsExpr[]{value, shift}));
            return new JsExpr("Math.round(" + valueTimesShift.getText() + ") / " + shift.getText(), Operator.DIVIDE_BY.getPrecedence());
        }
        if (numDigitsAfterPtAsInt < 0 && numDigitsAfterPtAsInt >= -12) {
            String shiftExprText = "1" + "000000000000".substring(0, -numDigitsAfterPtAsInt);
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueDivideByShift = SoyJsCodeUtils.genJsExprUsingSoySyntax(Operator.DIVIDE_BY, Lists.newArrayList((Object[])new JsExpr[]{value, shift}));
            return new JsExpr("Math.round(" + valueDivideByShift.getText() + ") * " + shift.getText(), Operator.TIMES.getPrecedence());
        }
        throw new IllegalArgumentException("Second argument to round() function is " + numDigitsAfterPtAsInt + ", which is too large in magnitude.");
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> args) {
        JavaExpr value = args.get(0);
        JavaExpr numDigitsAfterPt = args.size() == 2 ? args.get(1) : null;
        String numDigitsAfterPtExprText = numDigitsAfterPt != null ? JavaCodeUtils.genMaybeCast(numDigitsAfterPt, IntegerData.class) : "null";
        return SoyJavaSrcFunctionUtils.toNumberJavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$round", JavaCodeUtils.genMaybeCast(value, NumberData.class), numDigitsAfterPtExprText));
    }
}

