/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

@Singleton
public class ChangeNewlineToBrDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective,
SanitizedContentOperator {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");

    @Inject
    public ChangeNewlineToBrDirective() {
    }

    @Override
    public String getName() {
        return "|changeNewlineToBr";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String apply(SoyData value, List<SoyData> args) {
        return NEWLINE_PATTERN.matcher(value.toString()).replaceAll("<br>");
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$changeNewlineToBr(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$changeNewlineToBr", value.getText()), String.class, Integer.MAX_VALUE);
    }

    @Override
    public SanitizedContent.ContentKind getContentKind() {
        return SanitizedContent.ContentKind.HTML;
    }
}

