/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.Sanitizers;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

public abstract class BasicEscapeDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    private final String name;
    private static final Set<Integer> VALID_ARGS_SIZES = ImmutableSet.of((Object)0);

    public BasicEscapeDirective(String name) {
        this.name = name;
    }

    protected abstract String escape(SoyData var1);

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Set<Integer> getValidArgsSizes() {
        return VALID_ARGS_SIZES;
    }

    @Override
    public final boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public final String apply(SoyData value, List<SoyData> args) {
        return this.escape(value);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        return new JavaExpr(JavaCodeUtils.genNewStringData(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$" + this.name.substring(1), JavaCodeUtils.genMaybeCast(value, SoyData.class))), StringData.class, Integer.MAX_VALUE);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$" + this.name.substring(1) + "(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    static final class EscapeUri
    extends BasicEscapeDirective {
        EscapeUri() {
            super("|escapeUri");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeUri(value);
        }
    }

    static final class NormalizeUri
    extends BasicEscapeDirective {
        NormalizeUri() {
            super("|normalizeUri");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.normalizeUri(value);
        }
    }

    static final class FilterNormalizeUri
    extends BasicEscapeDirective {
        FilterNormalizeUri() {
            super("|filterNormalizeUri");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.filterNormalizeUri(value);
        }
    }

    static final class EscapeJsValue
    extends BasicEscapeDirective {
        EscapeJsValue() {
            super("|escapeJsValue");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeJsValue(value);
        }
    }

    static final class EscapeJsString
    extends BasicEscapeDirective {
        EscapeJsString() {
            super("|escapeJsString");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeJsString(value);
        }
    }

    static final class FilterHtmlElementName
    extends BasicEscapeDirective {
        FilterHtmlElementName() {
            super("|filterHtmlElementName");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.filterHtmlElementName(value);
        }
    }

    static final class FilterHtmlAttribute
    extends BasicEscapeDirective {
        FilterHtmlAttribute() {
            super("|filterHtmlAttribute");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.filterHtmlAttribute(value);
        }
    }

    static final class EscapeHtmlAttributeNospace
    extends BasicEscapeDirective {
        EscapeHtmlAttributeNospace() {
            super("|escapeHtmlAttributeNospace");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeHtmlAttributeNospace(value);
        }
    }

    static final class EscapeHtmlAttribute
    extends BasicEscapeDirective {
        EscapeHtmlAttribute() {
            super("|escapeHtmlAttribute");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeHtmlAttribute(value);
        }
    }

    static final class EscapeHtmlRcdata
    extends BasicEscapeDirective {
        EscapeHtmlRcdata() {
            super("|escapeHtmlRcdata");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeHtmlRcdata(value);
        }
    }

    static final class FilterCssValue
    extends BasicEscapeDirective {
        FilterCssValue() {
            super("|filterCssValue");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.filterCssValue(value);
        }
    }

    static final class EscapeCssString
    extends BasicEscapeDirective {
        EscapeCssString() {
            super("|escapeCssString");
        }

        @Override
        protected String escape(SoyData value) {
            return Sanitizers.escapeCssString(value);
        }
    }
}

