/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.template.soy.base.SourceLocation;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class SoySyntaxException
extends RuntimeException {
    private SourceLocation sourceLocation = SourceLocation.UNKNOWN;
    private String templateName;

    public SoySyntaxException(String message) {
        super(message);
    }

    public SoySyntaxException(String message, Throwable cause) {
        super(message, cause);
    }

    public SoySyntaxException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    public SoySyntaxException setFilePath(String filePath) {
        return this.setSourceLocation(new SourceLocation(filePath, 0));
    }

    public SoySyntaxException setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public SoySyntaxException setTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    @Override
    public String getMessage() {
        boolean locationKnown = this.sourceLocation.isKnown();
        boolean templateKnown = this.templateName != null;
        String message = super.getMessage();
        if (locationKnown) {
            if (templateKnown) {
                return "In file " + this.sourceLocation + ", template " + this.templateName + ": " + message;
            }
            return "In file " + this.sourceLocation + ": " + message;
        }
        if (templateKnown) {
            return "In template " + this.templateName + ": " + message;
        }
        return message;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }
}

