/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SourceLocation {
    @Nonnull
    private final String sourcePath;
    private final int lineNumber;
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown", 0);

    public SourceLocation(String sourcePath, int lineNumber) {
        this.sourcePath = sourcePath;
        this.lineNumber = lineNumber;
    }

    @Nonnull
    public String getSourcePath() {
        return this.sourcePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isKnown() {
        return !this.equals(UNKNOWN);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.sourcePath.equals(that.sourcePath) && this.lineNumber == that.lineNumber;
    }

    public int hashCode() {
        return this.sourcePath.hashCode() + 31 * this.lineNumber;
    }

    public String toString() {
        return this.lineNumber != 0 ? this.sourcePath + ":" + this.lineNumber : this.sourcePath;
    }
}

