/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.internal.base.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyUtils {
    private static final Pattern COMPILE_TIME_GLOBAL_LINE = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9.]*) \\s* = \\s* (.+)", 4);

    private SoyUtils() {
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> compileTimeGlobalsMap, Appendable output) throws IOException {
        ImmutableMap<String, PrimitiveData> compileTimeGlobals = DataUtils.convertCompileTimeGlobalsMap(compileTimeGlobalsMap);
        for (Map.Entry entry : compileTimeGlobals.entrySet()) {
            String valueSrcStr = DataUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue()).toSourceString();
            output.append((CharSequence)entry.getKey()).append(" = ").append(valueSrcStr).append("\n");
        }
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> compileTimeGlobalsMap, File file) throws IOException {
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        SoyUtils.generateCompileTimeGlobalsFile(compileTimeGlobalsMap, writer);
        writer.close();
    }

    public static ImmutableMap<String, PrimitiveData> parseCompileTimeGlobals(InputSupplier<? extends Reader> inputSupplier) throws IOException, SoySyntaxException {
        ImmutableMap.Builder compileTimeGlobalsBuilder = ImmutableMap.builder();
        ArrayList errors = Lists.newArrayListWithCapacity((int)0);
        BufferedReader reader = new BufferedReader((Reader)inputSupplier.getInput());
        String line = reader.readLine();
        while (line != null) {
            block12: {
                if (!line.startsWith("//") && line.trim().length() != 0) {
                    Matcher matcher = COMPILE_TIME_GLOBAL_LINE.matcher(line);
                    if (!matcher.matches()) {
                        errors.add(Pair.of(CompileTimeGlobalsFileError.INVALID_FORMAT, line));
                    } else {
                        PrimitiveData value;
                        String name = matcher.group(1);
                        String valueText = matcher.group(2).trim();
                        try {
                            Node valueExpr = new ExpressionParser(valueText).parseExpression().getChild(0);
                            if (!(valueExpr instanceof ExprNode.PrimitiveNode)) {
                                if (valueExpr instanceof GlobalNode || valueExpr instanceof DataRefNode) {
                                    errors.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, line));
                                } else {
                                    errors.add(Pair.of(CompileTimeGlobalsFileError.NON_PRIMITIVE_VALUE, line));
                                }
                                break block12;
                            }
                            value = DataUtils.convertPrimitiveExprToData((ExprNode.PrimitiveNode)valueExpr);
                        }
                        catch (TokenMgrError tme) {
                            errors.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, line));
                            break block12;
                        }
                        catch (ParseException pe) {
                            errors.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, line));
                            break block12;
                        }
                        compileTimeGlobalsBuilder.put((Object)name, (Object)value);
                    }
                }
            }
            line = reader.readLine();
        }
        if (errors.size() > 0) {
            StringBuilder errorMsgSb = new StringBuilder("Compile-time globals file contains the following errors:\n");
            for (Pair error : errors) {
                errorMsgSb.append("[").append(String.format("%-19s", ((CompileTimeGlobalsFileError)((Object)error.first)).toString())).append("] ").append((String)error.second).append("\n");
            }
            throw new SoySyntaxException(errorMsgSb.toString());
        }
        return compileTimeGlobalsBuilder.build();
    }

    private static enum CompileTimeGlobalsFileError {
        INVALID_FORMAT("Invalid line format"),
        INVALID_VALUE("Invalid value"),
        NON_PRIMITIVE_VALUE("Non-primitive value");

        private final String errorString;

        private CompileTimeGlobalsFileError(String errorString) {
            this.errorString = errorString;
        }

        public String toString() {
            return this.errorString;
        }
    }
}

