/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.SoyModule;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

class MainClassUtils {
    private MainClassUtils() {
    }

    public static CmdLineParser parseFlags(Object objWithFlags, String[] args, String usagePrefix) {
        CmdLineParser cmdLineParser = new CmdLineParser(objWithFlags);
        cmdLineParser.setUsageWidth(100);
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            MainClassUtils.exitWithError(cle.getMessage(), cmdLineParser, usagePrefix);
        }
        return cmdLineParser;
    }

    public static void exitWithError(String errorMsg, CmdLineParser cmdLineParser, String usagePrefix) {
        System.err.println("\nError: " + errorMsg + "\n\n");
        System.err.println(usagePrefix);
        cmdLineParser.printUsage((OutputStream)System.err);
        System.exit(1);
    }

    public static Injector createInjector(String msgPluginModuleName, @Nullable String pluginModuleNames) {
        ArrayList guiceModules = Lists.newArrayListWithCapacity((int)2);
        guiceModules.add(new SoyModule());
        Preconditions.checkArgument((msgPluginModuleName != null && msgPluginModuleName.length() > 0 ? 1 : 0) != 0);
        guiceModules.add(MainClassUtils.instantiatePluginModule(msgPluginModuleName));
        if (pluginModuleNames != null && pluginModuleNames.length() > 0) {
            for (String pluginModuleName : Splitter.on((char)',').split((CharSequence)pluginModuleNames)) {
                guiceModules.add(MainClassUtils.instantiatePluginModule(pluginModuleName));
            }
        }
        return Guice.createInjector((Iterable)guiceModules);
    }

    private static Module instantiatePluginModule(String moduleName) {
        try {
            return (Module)Class.forName(moduleName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find plugin module \"" + moduleName + "\".", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access plugin module \"" + moduleName + "\".", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate plugin module \"" + moduleName + "\".", e);
        }
    }

    public static class StringListOptionHandler
    extends ListOptionHandler<String> {
        public StringListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
            super(parser, option, setter);
        }

        @Override
        public String parseItem(String item) {
            return item;
        }
    }

    public static abstract class ListOptionHandler<T>
    extends OptionHandler<T> {
        public ListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
            super(parser, option, setter);
        }

        public abstract T parseItem(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            for (String item : params.getParameter(0).split(",")) {
                this.setter.addValue(this.parseItem(item));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "ITEM,ITEM,...";
        }
    }

    public static class BooleanOptionHandler
    extends OptionHandler<Boolean> {
        public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            boolean hasParam;
            boolean value;
            try {
                String nextArg = params.getParameter(0);
                if (nextArg.equals("true") || nextArg.equals("1")) {
                    value = true;
                    hasParam = true;
                } else if (nextArg.equals("false") || nextArg.equals("0")) {
                    value = false;
                    hasParam = true;
                } else {
                    value = true;
                    hasParam = false;
                }
            }
            catch (CmdLineException e) {
                value = true;
                hasParam = false;
            }
            this.setter.addValue((Object)value);
            return hasParam ? 1 : 0;
        }

        public String getDefaultMetaVariable() {
            return null;
        }
    }
}

