/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.shopping.css.v1.AccountLabel;
import com.google.shopping.css.v1.AccountLabelsServiceClient;
import com.google.shopping.css.v1.CreateAccountLabelRequest;
import com.google.shopping.css.v1.DeleteAccountLabelRequest;
import com.google.shopping.css.v1.ListAccountLabelsRequest;
import com.google.shopping.css.v1.ListAccountLabelsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelRequest;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStub;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStubSettings;
import com.google.shopping.css.v1.stub.GrpcAccountLabelsServiceCallableFactory;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAccountLabelsServiceStub
extends AccountLabelsServiceStub {
    private static final MethodDescriptor<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountLabelsService/ListAccountLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAccountLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAccountLabelsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateAccountLabelRequest, AccountLabel> createAccountLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountLabelsService/CreateAccountLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAccountLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccountLabel.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountLabelsService/UpdateAccountLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAccountLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccountLabel.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteAccountLabelRequest, Empty> deleteAccountLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.shopping.css.v1.AccountLabelsService/DeleteAccountLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAccountLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsCallable;
    private final UnaryCallable<ListAccountLabelsRequest, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsPagedCallable;
    private final UnaryCallable<CreateAccountLabelRequest, AccountLabel> createAccountLabelCallable;
    private final UnaryCallable<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelCallable;
    private final UnaryCallable<DeleteAccountLabelRequest, Empty> deleteAccountLabelCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAccountLabelsServiceStub create(AccountLabelsServiceStubSettings settings) throws IOException {
        return new GrpcAccountLabelsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAccountLabelsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAccountLabelsServiceStub(AccountLabelsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAccountLabelsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAccountLabelsServiceStub(AccountLabelsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAccountLabelsServiceStub(AccountLabelsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAccountLabelsServiceCallableFactory());
    }

    protected GrpcAccountLabelsServiceStub(AccountLabelsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listAccountLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAccountLabelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createAccountLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAccountLabelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAccountLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAccountLabelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("account_label.name", String.valueOf(request.getAccountLabel().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAccountLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAccountLabelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listAccountLabelsCallable = callableFactory.createUnaryCallable(listAccountLabelsTransportSettings, settings.listAccountLabelsSettings(), clientContext);
        this.listAccountLabelsPagedCallable = callableFactory.createPagedCallable(listAccountLabelsTransportSettings, settings.listAccountLabelsSettings(), clientContext);
        this.createAccountLabelCallable = callableFactory.createUnaryCallable(createAccountLabelTransportSettings, settings.createAccountLabelSettings(), clientContext);
        this.updateAccountLabelCallable = callableFactory.createUnaryCallable(updateAccountLabelTransportSettings, settings.updateAccountLabelSettings(), clientContext);
        this.deleteAccountLabelCallable = callableFactory.createUnaryCallable(deleteAccountLabelTransportSettings, settings.deleteAccountLabelSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsCallable() {
        return this.listAccountLabelsCallable;
    }

    @Override
    public UnaryCallable<ListAccountLabelsRequest, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsPagedCallable() {
        return this.listAccountLabelsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateAccountLabelRequest, AccountLabel> createAccountLabelCallable() {
        return this.createAccountLabelCallable;
    }

    @Override
    public UnaryCallable<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelCallable() {
        return this.updateAccountLabelCallable;
    }

    @Override
    public UnaryCallable<DeleteAccountLabelRequest, Empty> deleteAccountLabelCallable() {
        return this.deleteAccountLabelCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

