/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.shopping.css.v1.AccountLabel;
import com.google.shopping.css.v1.AccountLabelsServiceClient;
import com.google.shopping.css.v1.CreateAccountLabelRequest;
import com.google.shopping.css.v1.DeleteAccountLabelRequest;
import com.google.shopping.css.v1.ListAccountLabelsRequest;
import com.google.shopping.css.v1.ListAccountLabelsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelRequest;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStub;
import com.google.shopping.css.v1.stub.AccountLabelsServiceStubSettings;
import com.google.shopping.css.v1.stub.HttpJsonAccountLabelsServiceCallableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonAccountLabelsServiceStub
extends AccountLabelsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountLabelsService/ListAccountLabels").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=accounts/*}/labels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAccountLabelsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateAccountLabelRequest, AccountLabel> createAccountLabelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountLabelsService/CreateAccountLabel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=accounts/*}/labels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("accountLabel", (Message)request.getAccountLabel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AccountLabel.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountLabelsService/UpdateAccountLabel").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{accountLabel.name=accounts/*/labels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "accountLabel.name", (Object)request.getAccountLabel().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("accountLabel", (Message)request.getAccountLabel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AccountLabel.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteAccountLabelRequest, Empty> deleteAccountLabelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountLabelsService/DeleteAccountLabel").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=accounts/*/labels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsCallable;
    private final UnaryCallable<ListAccountLabelsRequest, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsPagedCallable;
    private final UnaryCallable<CreateAccountLabelRequest, AccountLabel> createAccountLabelCallable;
    private final UnaryCallable<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelCallable;
    private final UnaryCallable<DeleteAccountLabelRequest, Empty> deleteAccountLabelCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAccountLabelsServiceStub create(AccountLabelsServiceStubSettings settings) throws IOException {
        return new HttpJsonAccountLabelsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAccountLabelsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAccountLabelsServiceStub(AccountLabelsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAccountLabelsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAccountLabelsServiceStub(AccountLabelsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAccountLabelsServiceStub(AccountLabelsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAccountLabelsServiceCallableFactory());
    }

    protected HttpJsonAccountLabelsServiceStub(AccountLabelsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listAccountLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAccountLabelsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createAccountLabelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createAccountLabelMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateAccountLabelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAccountLabelMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("account_label.name", String.valueOf(request.getAccountLabel().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteAccountLabelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAccountLabelMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listAccountLabelsCallable = callableFactory.createUnaryCallable(listAccountLabelsTransportSettings, settings.listAccountLabelsSettings(), clientContext);
        this.listAccountLabelsPagedCallable = callableFactory.createPagedCallable(listAccountLabelsTransportSettings, settings.listAccountLabelsSettings(), clientContext);
        this.createAccountLabelCallable = callableFactory.createUnaryCallable(createAccountLabelTransportSettings, settings.createAccountLabelSettings(), clientContext);
        this.updateAccountLabelCallable = callableFactory.createUnaryCallable(updateAccountLabelTransportSettings, settings.updateAccountLabelSettings(), clientContext);
        this.deleteAccountLabelCallable = callableFactory.createUnaryCallable(deleteAccountLabelTransportSettings, settings.deleteAccountLabelSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listAccountLabelsMethodDescriptor);
        methodDescriptors.add(createAccountLabelMethodDescriptor);
        methodDescriptors.add(updateAccountLabelMethodDescriptor);
        methodDescriptors.add(deleteAccountLabelMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListAccountLabelsRequest, ListAccountLabelsResponse> listAccountLabelsCallable() {
        return this.listAccountLabelsCallable;
    }

    @Override
    public UnaryCallable<ListAccountLabelsRequest, AccountLabelsServiceClient.ListAccountLabelsPagedResponse> listAccountLabelsPagedCallable() {
        return this.listAccountLabelsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateAccountLabelRequest, AccountLabel> createAccountLabelCallable() {
        return this.createAccountLabelCallable;
    }

    @Override
    public UnaryCallable<UpdateAccountLabelRequest, AccountLabel> updateAccountLabelCallable() {
        return this.updateAccountLabelCallable;
    }

    @Override
    public UnaryCallable<DeleteAccountLabelRequest, Empty> deleteAccountLabelCallable() {
        return this.deleteAccountLabelCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

