/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.shopping.css.v1.Account;
import com.google.shopping.css.v1.AccountsServiceClient;
import com.google.shopping.css.v1.GetAccountRequest;
import com.google.shopping.css.v1.ListChildAccountsRequest;
import com.google.shopping.css.v1.ListChildAccountsResponse;
import com.google.shopping.css.v1.UpdateAccountLabelsRequest;
import com.google.shopping.css.v1.stub.AccountsServiceStub;
import com.google.shopping.css.v1.stub.AccountsServiceStubSettings;
import com.google.shopping.css.v1.stub.HttpJsonAccountsServiceCallableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonAccountsServiceStub
extends AccountsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountsService/ListChildAccounts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=accounts/*}:listChildAccounts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFullName()) {
            serializer.putQueryParam(fields, "fullName", (Object)request.getFullName());
        }
        if (request.hasLabelId()) {
            serializer.putQueryParam(fields, "labelId", (Object)request.getLabelId());
        }
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListChildAccountsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAccountRequest, Account> getAccountMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountsService/GetAccount").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=accounts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasParent()) {
            serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        }
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Account.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAccountLabelsRequest, Account> updateLabelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.shopping.css.v1.AccountsService/UpdateLabels").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=accounts/*}:updateLabels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Account.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsCallable;
    private final UnaryCallable<ListChildAccountsRequest, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsPagedCallable;
    private final UnaryCallable<GetAccountRequest, Account> getAccountCallable;
    private final UnaryCallable<UpdateAccountLabelsRequest, Account> updateLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAccountsServiceStub create(AccountsServiceStubSettings settings) throws IOException {
        return new HttpJsonAccountsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAccountsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAccountsServiceStub(AccountsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAccountsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAccountsServiceStub(AccountsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAccountsServiceStub(AccountsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAccountsServiceCallableFactory());
    }

    protected HttpJsonAccountsServiceStub(AccountsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listChildAccountsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listChildAccountsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAccountTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAccountMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateLabelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateLabelsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listChildAccountsCallable = callableFactory.createUnaryCallable(listChildAccountsTransportSettings, settings.listChildAccountsSettings(), clientContext);
        this.listChildAccountsPagedCallable = callableFactory.createPagedCallable(listChildAccountsTransportSettings, settings.listChildAccountsSettings(), clientContext);
        this.getAccountCallable = callableFactory.createUnaryCallable(getAccountTransportSettings, settings.getAccountSettings(), clientContext);
        this.updateLabelsCallable = callableFactory.createUnaryCallable(updateLabelsTransportSettings, settings.updateLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listChildAccountsMethodDescriptor);
        methodDescriptors.add(getAccountMethodDescriptor);
        methodDescriptors.add(updateLabelsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListChildAccountsRequest, ListChildAccountsResponse> listChildAccountsCallable() {
        return this.listChildAccountsCallable;
    }

    @Override
    public UnaryCallable<ListChildAccountsRequest, AccountsServiceClient.ListChildAccountsPagedResponse> listChildAccountsPagedCallable() {
        return this.listChildAccountsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAccountRequest, Account> getAccountCallable() {
        return this.getAccountCallable;
    }

    @Override
    public UnaryCallable<UpdateAccountLabelsRequest, Account> updateLabelsCallable() {
        return this.updateLabelsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

