/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CheckReturnValue;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.ManifestSchemaFactory;
import com.google.protobuf.Reader;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaFactory;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@CheckReturnValue
final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    static Protobuf getInstance() {
        return INSTANCE;
    }

    <T> void writeTo(T message, Writer writer) throws IOException {
        this.schemaFor(message).writeTo(message, writer);
    }

    <T> void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message).mergeFrom(message, reader, extensionRegistry);
    }

    <T> boolean isInitialized(T message) {
        return this.schemaFor(message).isInitialized(message);
    }

    <T> Schema<T> schemaFor(Class<T> messageType) {
        Internal.checkNotNull(messageType, "messageType");
        Schema<T> schema = (Schema<T>)this.schemaCache.get(messageType);
        if (schema == null) {
            schema = this.schemaFactory.createSchema(messageType);
            Internal.checkNotNull(schema, "schema");
            Schema<T> previous = this.schemaCache.putIfAbsent(messageType, schema);
            if (previous != null) {
                schema = previous;
            }
        }
        return schema;
    }

    <T> Schema<T> schemaFor(T message) {
        return this.schemaFor((T)message.getClass());
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }
}

