/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import com.google.protobuf.gradle.ArchiveActionFacade;
import com.google.protobuf.gradle.CopyActionFacade;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GradleVersion;

public abstract class ProtobufExtract
extends DefaultTask
implements GroovyObject {
    private final CopyActionFacade copyActionFacade;
    private final ArchiveActionFacade archiveActionFacade;
    private final FileCollection filteredProtos;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProtobufExtract() {
        MetaClass metaClass;
        FileCollection fileCollection;
        ArchiveActionFacade archiveActionFacade;
        CopyActionFacade copyActionFacade;
        this.copyActionFacade = copyActionFacade = CopyActionFacade.Loader.create(this.getProject(), this.getObjectFactory());
        this.archiveActionFacade = archiveActionFacade = this.instantiateArchiveActionFacade();
        this.filteredProtos = fileCollection = this.instantiateFilteredProtos();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @OutputDirectory
    public abstract DirectoryProperty getDestDir();

    @org.gradle.api.tasks.Internal
    public abstract ConfigurableFileCollection getInputFiles();

    @org.gradle.api.tasks.Internal
    public abstract ConfigurableFileCollection getDummyTaskDependency();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getInputProtoFiles() {
        public final class _getInputProtoFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInputProtoFiles_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(PatternFilterable pattern) {
                return pattern.include(new String[]{"**/*.proto"});
            }

            public Object call(PatternFilterable pattern) {
                return this.doCall(pattern);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInputProtoFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.filteredProtos.getAsFileTree().matching((Closure)new _getInputProtoFiles_closure1((Object)this, (Object)this));
    }

    @TaskAction
    public void extract() {
        public final class _extract_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extract_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object spec) {
                boolean bl = false;
                ((CopySpec)spec).setIncludeEmptyDirs(bl);
                ((CopySpec)spec).from(new Object[]{((ProtobufExtract)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProtobufExtract.class))).getInputProtoFiles()});
                ((CopySpec)spec).into((Object)((ProtobufExtract)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ProtobufExtract.class))).getDestDir());
                DuplicatesStrategy duplicatesStrategy = DuplicatesStrategy.INCLUDE;
                ((CopySpec)spec).setDuplicatesStrategy(duplicatesStrategy);
                return duplicatesStrategy;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extract_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.copyActionFacade.sync((Action<? super CopySpec>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _extract_closure2((Object)this, (Object)this)), Action.class)));
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    private ArchiveActionFacade instantiateArchiveActionFacade() {
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)GradleVersion.current(), (Object)GradleVersion.version((String)"6.0"))) {
            return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.getObjectFactory().newInstance(ArchiveActionFacade.ServiceBased.class, new Object[0]), ArchiveActionFacade.class);
        }
        return new ArchiveActionFacade.ProjectBased(this.getProject());
    }

    private FileCollection instantiateFilteredProtos() {
        Reference warningLogged = new Reference((Object)false);
        Reference archiveFacade = new Reference((Object)this.archiveActionFacade);
        Reference logger = new Reference((Object)this.getLogger());
        Reference inputFiles = new Reference((Object)this.getInputFiles());
        public final class _instantiateFilteredProtos_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _instantiateFilteredProtos_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return false;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _instantiateFilteredProtos_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _instantiateFilteredProtos_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference inputFiles;
            private /* synthetic */ Reference warningLogged;
            private /* synthetic */ Reference logger;
            private /* synthetic */ Reference archiveFacade;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _instantiateFilteredProtos_closure4(Object _outerInstance, Object _thisObject, Reference inputFiles, Reference warningLogged, Reference logger, Reference archiveFacade) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.inputFiles = reference4 = inputFiles;
                this.warningLogged = reference3 = warningLogged;
                this.logger = reference2 = logger;
                this.archiveFacade = reference = archiveFacade;
            }

            public Object doCall(Object unused) {
                Set files = ((ConfigurableFileCollection)this.inputFiles.get()).getFiles();
                Reference protoFilter = new Reference((Object)new PatternSet().include(new String[]{"**/*.proto"}));
                Reference protoInputs = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
                File file = null;
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    file = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                    if (file.isDirectory()) {
                        ((Set)protoInputs.get()).add(file);
                        continue;
                    }
                    if (file.getPath().endsWith(".proto")) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.warningLogged.get())) {
                            boolean bl = true;
                            this.warningLogged.set((Object)bl);
                            ((Logger)this.logger.get()).warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file.getPath()}, new String[]{"proto file '", "' directly specified in configuration. "}).plus("It's likely you specified files('path/to/foo.proto') or ").plus("fileTree('path/to/directory') in protobuf or compile configuration. ").plus("This makes you vulnerable to ").plus("https://github.com/google/protobuf-gradle-plugin/issues/248. ").plus("Please use files('path/to/directory') instead.")));
                        }
                        ((Set)protoInputs.get()).add(file);
                        continue;
                    }
                    if (file.getPath().endsWith(".jar") || file.getPath().endsWith(".zip")) {
                        ((Set)protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).zipTree(file.getPath()).matching((PatternFilterable)((PatternSet)protoFilter.get())));
                        continue;
                    }
                    if (file.getPath().endsWith(".aar")) {
                        public final class _closure5
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure5(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(File it) {
                                return it.getPath().endsWith(".jar");
                            }

                            public Object call(File it) {
                                return this.doCall(it);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure5.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        FileCollection zipTree = ((ArchiveActionFacade)this.archiveFacade.get()).zipTree(file.getPath()).filter((Closure)new _closure5((Object)this, this.getThisObject()));
                        public final class _closure6
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference protoInputs;
                            private /* synthetic */ Reference archiveFacade;
                            private /* synthetic */ Reference protoFilter;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure6(Object _outerInstance, Object _thisObject, Reference protoInputs, Reference archiveFacade, Reference protoFilter) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.protoInputs = reference3 = protoInputs;
                                this.archiveFacade = reference2 = archiveFacade;
                                this.protoFilter = reference = protoFilter;
                            }

                            public Object doCall(Object entry) {
                                return ((Set)this.protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).zipTree(entry).matching((PatternFilterable)ScriptBytecodeAdapter.castToType((Object)this.protoFilter.get(), PatternFilterable.class)));
                            }

                            @Generated
                            public Set getProtoInputs() {
                                return (Set)ScriptBytecodeAdapter.castToType((Object)this.protoInputs.get(), Set.class);
                            }

                            @Generated
                            public ArchiveActionFacade getArchiveFacade() {
                                return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.archiveFacade.get(), ArchiveActionFacade.class);
                            }

                            @Generated
                            public PatternSet getProtoFilter() {
                                return (PatternSet)ScriptBytecodeAdapter.castToType((Object)this.protoFilter.get(), PatternSet.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure6.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each((Iterable)zipTree, (Closure)new _closure6((Object)this, this.getThisObject(), protoInputs, this.archiveFacade, protoFilter));
                        continue;
                    }
                    if (file.getPath().endsWith(".tar") || file.getPath().endsWith(".tar.gz") || file.getPath().endsWith(".tar.bz2") || file.getPath().endsWith(".tgz")) {
                        ((Set)protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).tarTree(file.getPath()).matching((PatternFilterable)((PatternSet)protoFilter.get())));
                        continue;
                    }
                    ((Logger)this.logger.get()).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file.getPath()}, new String[]{"Skipping unsupported file type (", "); "}).plus("handles only jar, tar, tar.gz, tar.bz2 & tgz")));
                }
                return (Set)protoInputs.get();
            }

            @Generated
            public FileCollection getInputFiles() {
                return (FileCollection)ScriptBytecodeAdapter.castToType((Object)this.inputFiles.get(), FileCollection.class);
            }

            @Generated
            public Boolean getWarningLogged() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.warningLogged.get(), Boolean.class);
            }

            @Generated
            public Logger getLogger() {
                return (Logger)ScriptBytecodeAdapter.castToType((Object)this.logger.get(), Logger.class);
            }

            @Generated
            public ArchiveActionFacade getArchiveFacade() {
                return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.archiveFacade.get(), ArchiveActionFacade.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _instantiateFilteredProtos_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.getObjectFactory().fileCollection().from(new Object[]{((ConfigurableFileCollection)inputFiles.get()).filter((Closure)new _instantiateFilteredProtos_closure3((Object)this, (Object)this))}).from(new Object[]{this.getDummyTaskDependency().getElements().map((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _instantiateFilteredProtos_closure4((Object)this, (Object)this, inputFiles, warningLogged, logger, archiveFacade)), Transformer.class))});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ProtobufExtract.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }
}

