/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonLexerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0003J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0006\u0010%\u001a\u00020\u0003J\u0018\u0010&\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010'\u001a\u00020\u0013J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0003J\u0018\u0010/\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020!H\u0002J\u0006\u00102\u001a\u00020\u001fJ\u0010\u00103\u001a\u0004\u0018\u00010\u00032\u0006\u00104\u001a\u00020\u0017J1\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00172\b\b\u0002\u0010,\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000307H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u0017J\b\u0010;\u001a\u00020\u0006H\u0002J\b\u0010<\u001a\u00020\u0003H\u0002J\b\u0010=\u001a\u00020\u0003H\u0016J\u0006\u0010>\u001a\u00020\u0017J\u0006\u0010?\u001a\u00020\u0017J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0002R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006A"}, d2={"Lkotlinx/serialization/json/internal/JsonLexer;", "", "source", "", "(Ljava/lang/String;)V", "currentPosition", "", "escapedString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "peekedString", "appendEsc", "startPosition", "appendEscape", "lastPosition", "current", "appendHex", "startPos", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeBoolean", "start", "consumeBooleanLenient", "consumeBooleanLiteral", "literalSuffix", "consumeKeyString", "consumeNextToken", "", "expected", "", "consumeNumericLiteral", "", "consumeString", "consumeStringLenient", "decodedString", "expectEof", "fail", "expectedToken", "", "message", "position", "failOnUnknownKey", "key", "fromHexChar", "isValidValueStart", "c", "peekNextToken", "peekString", "isLenient", "require", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "skipElement", "allowLenientStrings", "skipWhitespaces", "takePeeked", "toString", "tryConsumeComma", "tryConsumeNotNull", "unexpectedToken", "kotlinx-serialization-json"})
public final class JsonLexer {
    @NotNull
    private final String source;
    @JvmField
    public int currentPosition;
    @Nullable
    private String peekedString;
    @NotNull
    private StringBuilder escapedString;

    public JsonLexer(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.source = source;
        this.escapedString = new StringBuilder();
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            JsonLexer.fail$default(this, "Expected EOF, but had " + this.source.charAt(this.currentPosition - 1) + " instead", 0, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    public final boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current == this.source.length()) {
            return false;
        }
        if (this.source.charAt(current) == ',') {
            JsonLexer jsonLexer = this;
            ++jsonLexer.currentPosition;
            int cfr_ignored_0 = jsonLexer.currentPosition;
            return true;
        }
        return false;
    }

    public final boolean canConsumeValue() {
        int current;
        for (current = this.currentPosition; current < this.source.length(); ++current) {
            char c = this.source.charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final boolean isValidValueStart(char c) {
        char c2 = c;
        return !(((c2 == '}' ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',');
    }

    public final byte consumeNextToken(byte expected) {
        byte token = this.consumeNextToken();
        if (token != expected) {
            this.fail(expected);
        }
        return token;
    }

    public final void consumeNextToken(char expected) {
        String source = this.source;
        while (this.currentPosition < source.length()) {
            JsonLexer jsonLexer = this;
            int n = jsonLexer.currentPosition;
            jsonLexer.currentPosition = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.unexpectedToken(expected);
    }

    private final void unexpectedToken(char expected) {
        JsonLexer jsonLexer = this;
        jsonLexer.currentPosition += -1;
        int cfr_ignored_0 = jsonLexer.currentPosition;
        if (expected == '\"' && Intrinsics.areEqual(this.consumeStringLenient(), "null")) {
            this.fail("Expected string literal but 'null' literal was found.\nUse 'coerceInputValues = true' in 'Json {}` builder to coerce nulls to default values.", this.currentPosition - 4);
            throw new KotlinNothingValueException();
        }
        this.fail(JsonLexerKt.charToTokenClass(expected));
    }

    private final void fail(byte expectedToken) {
        byte by = expectedToken;
        String expected = by == 1 ? "quotation mark '\"'" : (by == 4 ? "comma ','" : (by == 5 ? "semicolon ':'" : (by == 6 ? "start of the object '{'" : (by == 7 ? "end of the object '}'" : (by == 8 ? "start of the array '['" : (by == 9 ? "end of the array ']'" : "valid token"))))));
        String s = this.currentPosition == this.source.length() || this.currentPosition <= 0 ? "EOF" : String.valueOf(this.source.charAt(this.currentPosition - 1));
        this.fail("Expected " + expected + ", but had '" + s + "' instead", this.currentPosition - 1);
        throw new KotlinNothingValueException();
    }

    public final byte peekNextToken() {
        String source = this.source;
        while (this.currentPosition < source.length()) {
            char ch = source.charAt(this.currentPosition);
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                JsonLexer jsonLexer = this;
                ++jsonLexer.currentPosition;
                int cfr_ignored_0 = jsonLexer.currentPosition;
                continue;
            }
            return JsonLexerKt.charToTokenClass(ch);
        }
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    public final byte consumeNextToken() {
        String source = this.source;
        while (this.currentPosition < source.length()) {
            void var3_3;
            JsonLexer jsonLexer = this;
            int n = jsonLexer.currentPosition;
            jsonLexer.currentPosition = n + 1;
            char ch = source.charAt(n);
            byte tc = JsonLexerKt.charToTokenClass(ch);
            if (tc == 3) continue;
            return (byte)var3_3;
        }
        return 10;
    }

    public final boolean tryConsumeNotNull() {
        int current = this.skipWhitespaces();
        if (this.source.length() - current < 4) {
            return true;
        }
        int n = 0;
        do {
            int i;
            if ("null".charAt(i = n++) == this.source.charAt(current + i)) continue;
            return true;
        } while (n <= 3);
        this.currentPosition = current + 4;
        return false;
    }

    private final int skipWhitespaces() {
        char c;
        int current;
        for (current = this.currentPosition; current < this.source.length() && ((c = this.source.charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t'); ++current) {
        }
        this.currentPosition = current;
        return current;
    }

    @Nullable
    public final String peekString(boolean isLenient) {
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            if (token != 1) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return string;
    }

    @NotNull
    public final String consumeKeyString() {
        int n;
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = StringsKt.indexOf$default((CharSequence)this.source, '\"', current, false, 4, null);
        if (closingQuote == -1) {
            this.fail((byte)1);
        }
        if ((n = current) < closingQuote) {
            do {
                int i;
                if (this.source.charAt(i = n++) != '\\') continue;
                return this.consumeString(this.currentPosition, i);
            } while (n < closingQuote);
        }
        this.currentPosition = closingQuote + 1;
        String string = this.source;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(current, closingQuote);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    private final String consumeString(int startPosition, int current) {
        String string;
        int currentPosition = current;
        int lastPosition = startPosition;
        String source = this.source;
        char c = source.charAt(currentPosition);
        while (c != '\"') {
            if (c == '\\') {
                lastPosition = currentPosition = this.appendEscape(lastPosition, currentPosition);
            } else if (++currentPosition >= source.length()) {
                this.fail("EOF", currentPosition);
                throw new KotlinNothingValueException();
            }
            c = source.charAt(currentPosition);
        }
        if (lastPosition == startPosition) {
            String string2 = source;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(lastPosition, currentPosition);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = this.decodedString(lastPosition, currentPosition);
        }
        String string5 = string;
        this.currentPosition = currentPosition + 1;
        return string5;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.escapedString.append(this.source, lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue(string, "escapedString.toString()");
        String result = string;
        this.escapedString.setLength(0);
        return result;
    }

    private final String takePeeked() {
        String string = this.peekedString;
        Intrinsics.checkNotNull(string);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        this.peekedString = null;
        return string;
    }

    @NotNull
    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.source.length()) {
            this.fail("EOF", current);
            throw new KotlinNothingValueException();
        }
        byte token = JsonLexerKt.charToTokenClass(this.source.charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            JsonLexer.fail$default(this, Intrinsics.stringPlus("Expected beginning of the string, but got ", Character.valueOf(this.source.charAt(current))), 0, 2, null);
            throw new KotlinNothingValueException();
        }
        while (current < this.source.length() && JsonLexerKt.charToTokenClass(this.source.charAt(current)) == 0) {
            ++current;
        }
        String string = this.source;
        int n = this.currentPosition;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, current);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String result = string3;
        this.currentPosition = current;
        return result;
    }

    private final void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.source, fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition;
        int n = currentPosition = startPosition;
        currentPosition = n + 1;
        char currentChar = this.source.charAt(n);
        if (currentChar == 'u') {
            return this.appendHex(this.source, currentPosition);
        }
        char c = JsonLexerKt.escapeToChar(currentChar);
        if (c == '\u0000') {
            JsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c);
        return currentPosition;
    }

    private final int appendHex(String source, int startPos) {
        if (startPos + 4 >= source.length()) {
            JsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar(source, startPos + 3)));
        return startPos + 4;
    }

    private final int fromHexChar(String source, int currentPosition) {
        int n;
        char character = source.charAt(currentPosition);
        boolean bl = '0' <= character ? character <= '9' : false;
        if (bl) {
            n = character - 48;
        } else {
            boolean bl2 = 'a' <= character ? character <= 'f' : false;
            if (bl2) {
                n = character - 97 + 10;
            } else {
                boolean bl3 = 'A' <= character ? character <= 'F' : false;
                if (bl3) {
                    n = character - 65 + 10;
                } else {
                    JsonLexer.fail$default(this, "Invalid toHexChar char '" + character + "' in unicode escape", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        boolean bl = false;
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                if (allowLenientStrings) {
                    this.consumeStringLenient();
                    continue;
                }
                this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 ? true : by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of }", this.source);
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ]", this.source);
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 10) {
                JsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.source + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String string = this.source;
        int n = 0;
        int n2 = this.currentPosition;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String processed = string3;
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)processed, key, 0, false, 6, null);
        this.fail("Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.", lastIndexOf);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail(@NotNull String message, int position) {
        Intrinsics.checkNotNullParameter(message, "message");
        throw JsonExceptionsKt.JsonDecodingException(position, message, this.source);
    }

    public static /* synthetic */ Void fail$default(JsonLexer jsonLexer, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = jsonLexer.currentPosition;
        }
        return jsonLexer.fail(string, n);
    }

    public final void require$kotlinx_serialization_json(boolean condition, int position, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            this.fail(message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(JsonLexer this_, boolean condition, int position, Function0 message, int n, Object object) {
        if ((n & 2) != 0) {
            position = this_.currentPosition;
        }
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            this_.fail((String)message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.source.length()) {
            JsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.source.charAt(current) == '\"') {
            if (++current == this.source.length()) {
                JsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        boolean isNegative = false;
        int start = current;
        boolean hasChars = true;
        while (hasChars) {
            char ch = this.source.charAt(current);
            if (ch == '-') {
                if (current != start) {
                    JsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte token = JsonLexerKt.charToTokenClass(ch);
            if (token != 0) break;
            hasChars = ++current != this.source.length();
            int digit = ch - 48;
            if (!(0 <= digit ? digit <= 9 : false)) {
                JsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            JsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (start == current || isNegative && start == current - 1) {
            JsonLexer.fail$default(this, "Expected numeric literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                JsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.source.charAt(current) != '\"') {
                JsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (isNegative) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            JsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public final boolean consumeBoolean() {
        return this.consumeBoolean(this.skipWhitespaces());
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.source.length()) {
            JsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.source.charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.source.length()) {
                JsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.source.charAt(this.currentPosition) != '\"') {
                JsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            JsonLexer jsonLexer = this;
            ++jsonLexer.currentPosition;
            int cfr_ignored_0 = jsonLexer.currentPosition;
        }
        return result;
    }

    private final boolean consumeBoolean(int start) {
        boolean bl;
        int current = start;
        if (current == this.source.length()) {
            JsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = current;
        current = n + 1;
        int n2 = this.source.charAt(n) | 0x20;
        switch (n2) {
            case 116: {
                this.consumeBooleanLiteral("rue", current);
                bl = true;
                break;
            }
            case 102: {
                this.consumeBooleanLiteral("alse", current);
                bl = false;
                break;
            }
            default: {
                JsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
                throw new KotlinNothingValueException();
            }
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.source.length() - current < literalSuffix.length()) {
            JsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = 0;
        int n2 = literalSuffix.length() + -1;
        if (n <= n2) {
            do {
                char actual;
                int i;
                char expected;
                if ((expected = literalSuffix.charAt(i = n++)) == ((actual = this.source.charAt(current + i)) | 0x20)) continue;
                JsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
                throw new KotlinNothingValueException();
            } while (n <= n2);
        }
        this.currentPosition = current + literalSuffix.length();
    }
}

