/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import com.google.prefab.api.Module;
import com.google.prefab.api.PackageKt;
import com.google.prefab.api.PackageMetadata;
import com.google.prefab.api.PackageMetadataV1;
import com.google.prefab.api.SchemaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/google/prefab/api/Package;", "", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "dependencies", "", "", "getDependencies", "()Ljava/util/List;", "metadata", "Lcom/google/prefab/api/PackageMetadataV1;", "moduleDir", "Ljava/io/File;", "modules", "Lcom/google/prefab/api/Module;", "getModules", "name", "getName", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "schemaVersion", "Lcom/google/prefab/api/SchemaVersion;", "version", "getVersion", "api"})
public final class Package {
    @NotNull
    private final Path path;
    @NotNull
    private final PackageMetadataV1 metadata;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> dependencies;
    @Nullable
    private final String version;
    @NotNull
    private final SchemaVersion schemaVersion;
    @NotNull
    private final File moduleDir;
    @NotNull
    private final List<Module> modules;

    /*
     * WARNING - void declaration
     */
    public Package(@NotNull Path path2) {
        Object object;
        File[] it;
        Intrinsics.checkNotNullParameter(path2, "path");
        this.path = path2;
        this.metadata = PackageMetadata.Companion.loadAndMigrate(SchemaVersion.Companion.from(this.path), this.path);
        this.name = this.metadata.getName();
        this.dependencies = this.metadata.getDependencies();
        Object object2 = this.metadata.getVersion();
        boolean bl = false;
        boolean bl2 = false;
        String string = object2;
        Package package_ = this;
        boolean bl3 = false;
        boolean bl4 = it == null || PackageKt.isValidVersionForCMake((String)it);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string2 = "version must be compatible with CMake, if present";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Object object3 = Unit.INSTANCE;
        package_.version = object2;
        this.schemaVersion = SchemaVersion.Companion.from(this.metadata.getSchemaVersion());
        object2 = this.path.resolve("modules").toFile();
        Intrinsics.checkNotNullExpressionValue(object2, "path.resolve(\"modules\").toFile()");
        this.moduleDir = object2;
        Package package_2 = this;
        File[] fileArray = this.moduleDir.listFiles();
        if (fileArray == null) {
            object = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            it = fileArray;
            package_ = package_2;
            boolean $i$f$filter = false;
            void var7_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv;
            int n = ((void)iterator2).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it2 = element$iv$iv = iterator2[i];
                boolean bl8 = false;
                if (!(it2.isDirectory() && !it2.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object4 = object3 = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                File file2 = (File)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl9 = false;
                Path path3 = it3.toPath();
                Intrinsics.checkNotNullExpressionValue(path3, "it.toPath()");
                Module module = new Module(path3, this, this.schemaVersion);
                object3.add(module);
            }
            object3 = (List)destination$iv$iv;
            package_2 = package_;
            object = object2 = object3;
        }
        if (object2 == null) {
            throw new RuntimeException(Intrinsics.stringPlus("Unable to retrieve file list for ", this.moduleDir));
        }
        package_2.modules = object2;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final List<Module> getModules() {
        return this.modules;
    }
}

