/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/google/prefab/api/LibraryReference;", "", "()V", "Companion", "External", "Literal", "Local", "Lcom/google/prefab/api/LibraryReference$Literal;", "Lcom/google/prefab/api/LibraryReference$Local;", "Lcom/google/prefab/api/LibraryReference$External;", "api"})
public abstract class LibraryReference {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LibraryReference() {
    }

    public /* synthetic */ LibraryReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/google/prefab/api/LibraryReference$Literal;", "Lcom/google/prefab/api/LibraryReference;", "arg", "", "(Ljava/lang/String;)V", "getArg", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class Literal
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String arg;

        public Literal(@NotNull String arg) {
            Intrinsics.checkNotNullParameter(arg, "arg");
            super(null);
            this.arg = arg;
        }

        @NotNull
        public final String getArg() {
            return this.arg;
        }

        @NotNull
        public final String component1() {
            return this.arg;
        }

        @NotNull
        public final Literal copy(@NotNull String arg) {
            Intrinsics.checkNotNullParameter(arg, "arg");
            return new Literal(arg);
        }

        public static /* synthetic */ Literal copy$default(Literal literal, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = literal.arg;
            }
            return literal.copy(string);
        }

        @NotNull
        public String toString() {
            return "Literal(arg=" + this.arg + ')';
        }

        public int hashCode() {
            return this.arg.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)other;
            return Intrinsics.areEqual(this.arg, literal.arg);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$Literal$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$Literal;", "reference", "", "validate", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                CharSequence charSequence = reference;
                boolean bl = false;
                boolean bl2 = charSequence.length() > 0;
                bl = false;
                boolean bl3 = false;
                if (!bl2) {
                    boolean bl4 = false;
                    String string = "Literal library reference must not be empty";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }

            @NotNull
            public final Literal fromString(@NotNull String reference) {
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate(reference);
                return new Literal(reference);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/google/prefab/api/LibraryReference$Local;", "Lcom/google/prefab/api/LibraryReference;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class Local
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        public Local(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            super(null);
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Local copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Local(name);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.name;
            }
            return local.copy(string);
        }

        @NotNull
        public String toString() {
            return "Local(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return Intrinsics.areEqual(this.name, local.name);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$Local$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$Local;", "reference", "", "validate", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                boolean bl = StringsKt.startsWith$default(reference, ":", false, 2, null);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                CharSequence $this$count$iv = reference;
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl5 = false;
                    if (!(it == ':')) continue;
                    ++count$iv;
                }
                boolean bl6 = count$iv == 1;
                bl2 = false;
                bl3 = false;
                if (!bl6) {
                    boolean bl7 = false;
                    String string = "Expected exactly one : in local library reference";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }

            @NotNull
            public final Local fromString(@NotNull String reference) {
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate(reference);
                String string = reference;
                int n = 1;
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
                return new Local(string2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/google/prefab/api/LibraryReference$External;", "Lcom/google/prefab/api/LibraryReference;", "pkg", "", "module", "(Ljava/lang/String;Ljava/lang/String;)V", "getModule", "()Ljava/lang/String;", "getPkg", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class External
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String pkg;
        @NotNull
        private final String module;

        public External(@NotNull String pkg, @NotNull String module) {
            Intrinsics.checkNotNullParameter(pkg, "pkg");
            Intrinsics.checkNotNullParameter(module, "module");
            super(null);
            this.pkg = pkg;
            this.module = module;
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        @NotNull
        public final String getModule() {
            return this.module;
        }

        @NotNull
        public final String component1() {
            return this.pkg;
        }

        @NotNull
        public final String component2() {
            return this.module;
        }

        @NotNull
        public final External copy(@NotNull String pkg, @NotNull String module) {
            Intrinsics.checkNotNullParameter(pkg, "pkg");
            Intrinsics.checkNotNullParameter(module, "module");
            return new External(pkg, module);
        }

        public static /* synthetic */ External copy$default(External external, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = external.pkg;
            }
            if ((n & 2) != 0) {
                string2 = external.module;
            }
            return external.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "External(pkg=" + this.pkg + ", module=" + this.module + ')';
        }

        public int hashCode() {
            int result = this.pkg.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof External)) {
                return false;
            }
            External external = (External)other;
            if (!Intrinsics.areEqual(this.pkg, external.pkg)) {
                return false;
            }
            return Intrinsics.areEqual(this.module, external.module);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$External$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$External;", "reference", "", "validate", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                boolean bl = StringsKt.startsWith$default(reference, "//", false, 2, null);
                int n = 0;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                CharSequence $this$count$iv = reference;
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl4 = false;
                    if (!(it == ':')) continue;
                    ++count$iv;
                }
                boolean bl5 = count$iv == 1;
                n = 0;
                bl2 = false;
                if (!bl5) {
                    boolean bl6 = false;
                    String string = "Expected exactly one : in external library reference";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                String string = reference;
                n = 2;
                bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
                boolean bl7 = !StringsKt.contains$default((CharSequence)string3, '/', false, 2, null);
                n = 0;
                bl2 = false;
                if (!bl7) {
                    boolean bl8 = false;
                    String string4 = "Expected no / after leading // in external library reference";
                    throw (Throwable)new IllegalArgumentException(string4.toString());
                }
            }

            @NotNull
            public final External fromString(@NotNull String reference) {
                List list;
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate((String)reference);
                String[] stringArray = reference;
                int n = 2;
                boolean bl = false;
                String string = stringArray.substring(n);
                Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
                stringArray = new String[]{":"};
                List list2 = list = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
                bl = false;
                String pkg = (String)list2.get(0);
                List list3 = list;
                boolean bl2 = false;
                String module = (String)list3.get(1);
                return new External(pkg, module);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/prefab/api/LibraryReference$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference;", "reference", "", "api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryReference fromString(@NotNull String reference) {
            Intrinsics.checkNotNullParameter(reference, "reference");
            return StringsKt.startsWith$default(reference, "//", false, 2, null) ? (LibraryReference)External.Companion.fromString(reference) : (StringsKt.startsWith$default(reference, ":", false, 2, null) ? (LibraryReference)Local.Companion.fromString(reference) : (LibraryReference)Literal.Companion.fromString(reference));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

