/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import com.google.prefab.api.Android;
import com.google.prefab.api.AndroidAbiMetadata;
import com.google.prefab.api.AndroidAbiMetadataV2;
import com.google.prefab.api.CompatibleLibrary;
import com.google.prefab.api.IncompatibleLibrary;
import com.google.prefab.api.LibraryUsabilityResult;
import com.google.prefab.api.Module;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PlatformFactoryInterface;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.api.SchemaVersion;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0003\u001f !B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0004"}, d2={"Lcom/google/prefab/api/Android;", "Lcom/google/prefab/api/PlatformDataInterface;", "abi", "Lcom/google/prefab/api/Android$Abi;", "api", "", "stl", "Lcom/google/prefab/api/Android$Stl;", "ndkMajorVersion", "(Lcom/google/prefab/api/Android$Abi;ILcom/google/prefab/api/Android$Stl;I)V", "getAbi", "()Lcom/google/prefab/api/Android$Abi;", "getApi", "()I", "getNdkMajorVersion", "originalApi", "getStl", "()Lcom/google/prefab/api/Android$Stl;", "targetTriple", "", "getTargetTriple", "()Ljava/lang/String;", "checkIfUsable", "Lcom/google/prefab/api/LibraryUsabilityResult;", "library", "Lcom/google/prefab/api/PrebuiltLibrary;", "findBestMatch", "libraries", "", "stlsAreCompatible", "toString", "Abi", "Companion", "Stl"})
public final class Android
implements PlatformDataInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Abi abi;
    @NotNull
    private final Stl stl;
    private final int ndkMajorVersion;
    @NotNull
    private final String targetTriple;
    private final int originalApi;
    private final int api;
    @NotNull
    private static final String identifier = "android";

    public Android(@NotNull Abi abi, int api, @NotNull Stl stl, int ndkMajorVersion) {
        int n;
        Intrinsics.checkNotNullParameter((Object)abi, "abi");
        Intrinsics.checkNotNullParameter((Object)stl, "stl");
        this.abi = abi;
        this.stl = stl;
        this.ndkMajorVersion = ndkMajorVersion;
        this.targetTriple = this.abi.getTriple();
        this.originalApi = api;
        Abi abi2 = this.abi;
        int n2 = WhenMappings.$EnumSwitchMapping$0[abi2.ordinal()];
        switch (n2) {
            case 1: 
            case 2: {
                n = api;
                break;
            }
            case 3: 
            case 4: {
                int n3 = 21;
                boolean bl = false;
                n = Math.max(api, n3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.api = n;
    }

    @NotNull
    public final Abi getAbi() {
        return this.abi;
    }

    @NotNull
    public final Stl getStl() {
        return this.stl;
    }

    public final int getNdkMajorVersion() {
        return this.ndkMajorVersion;
    }

    @Override
    @NotNull
    public String getTargetTriple() {
        return this.targetTriple;
    }

    public final int getApi() {
        return this.api;
    }

    @NotNull
    public String toString() {
        return "Android(" + (Object)((Object)this.abi) + ", " + this.api + ", " + (Object)((Object)this.stl) + ')';
    }

    private final LibraryUsabilityResult stlsAreCompatible(PrebuiltLibrary library) {
        boolean bl = library.getPlatform() instanceof Android;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "library must be an Android library";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (((Android)library.getPlatform()).stl.getFamily() == Stl.Family.None) {
            return CompatibleLibrary.INSTANCE;
        }
        if (this.stl.getFamily() != ((Android)library.getPlatform()).stl.getFamily()) {
            return new IncompatibleLibrary("User requested " + this.stl.getFamily().getFamilyName() + " but library requires " + ((Android)library.getPlatform()).stl.getFamily().getFamilyName());
        }
        PathMatcher pathMatcher = library.getPath().getFileSystem().getPathMatcher("glob:*.a");
        if (pathMatcher.matches(library.getPath().getFileName())) {
            return CompatibleLibrary.INSTANCE;
        }
        if (!((Android)library.getPlatform()).stl.isShared()) {
            return new IncompatibleLibrary("Library is a shared library with a statically linked STL and cannot be used with any library using the STL");
        }
        if (!this.stl.isShared()) {
            return new IncompatibleLibrary("User is using a static STL but library requires a shared STL");
        }
        return CompatibleLibrary.INSTANCE;
    }

    @Override
    @NotNull
    public LibraryUsabilityResult checkIfUsable(@NotNull PrebuiltLibrary library) {
        Intrinsics.checkNotNullParameter(library, "library");
        if (!(library.getPlatform() instanceof Android)) {
            return new IncompatibleLibrary("Library is not an Android library");
        }
        if (this.abi != ((Android)library.getPlatform()).abi) {
            return new IncompatibleLibrary("User is targeting " + this.abi.getTargetArchAbi() + " but library is for " + ((Android)library.getPlatform()).abi.getTargetArchAbi());
        }
        if (this.api < ((Android)library.getPlatform()).api) {
            return new IncompatibleLibrary("User has minSdkVersion " + this.api + " but library was built for " + ((Android)library.getPlatform()).api);
        }
        return this.stlsAreCompatible(library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PrebuiltLibrary findBestMatch(@NotNull List<PrebuiltLibrary> libraries) {
        void $this$filterTo$iv$iv;
        Object v3;
        Object v2;
        void $this$filterTo$iv$iv22;
        Object v1;
        void $this$mapTo$iv$iv;
        Object it;
        boolean bl;
        boolean $i$f$all;
        boolean bl2;
        block28: {
            Intrinsics.checkNotNullParameter(libraries, "libraries");
            Collection collection = libraries;
            boolean bl3 = false;
            boolean bl4 = !collection.isEmpty();
            bl3 = false;
            bl2 = false;
            if (!bl4) {
                boolean bl5 = false;
                String string = "libraries must be non-empty";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable $this$all$iv = libraries;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (PrebuiltLibrary)element$iv;
                    boolean bl6 = false;
                    if (this.checkIfUsable((PrebuiltLibrary)it) instanceof CompatibleLibrary) continue;
                    bl = false;
                    break block28;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        $i$f$all = false;
        bl2 = false;
        if (!$this$all$iv) {
            boolean bl7 = false;
            String string = "all libraries must be compatible";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String moduleName = CollectionsKt.first(libraries).getModule().getCanonicalName();
        Iterable $this$map$iv = libraries;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PrebuiltLibrary prebuiltLibrary = (PrebuiltLibrary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl8 = false;
            boolean bl9 = it2.getPlatform() instanceof Android;
            boolean bl10 = false;
            boolean bl11 = false;
            if (!bl9) {
                boolean bl12 = false;
                String string = "library must be an android library";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Pair<void, PlatformDataInterface> pair2 = new Pair<void, PlatformDataInterface>(it2, it2.getPlatform());
            collection.add(pair2);
        }
        List allLibraries = (List)destination$iv$iv;
        Iterable $this$maxByOrNull$iv = allLibraries;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Pair it3 = (Pair)maxElem$iv;
                boolean bl13 = false;
                int maxValue$iv = ((Android)it3.getSecond()).getApi();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it4 = (Pair)e$iv;
                    $i$a$-maxByOrNull-Android$findBestMatch$bestApiLevel$1 = false;
                    int v$iv = ((Android)it4.getSecond()).getApi();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v1);
        int bestApiLevel = ((Android)((Pair)v1).getSecond()).api;
        Iterable $this$filter$iv22 = allLibraries;
        boolean $i$f$filter = false;
        Iterable maxElem$iv = $this$filter$iv22;
        Collection destination$iv$iv222 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv22) {
            Pair $dstr$_u24__u24$reqs = (Pair)element$iv$iv;
            boolean bl14 = false;
            Android reqs = (Android)$dstr$_u24__u24$reqs.component2();
            if (!(reqs.getApi() == bestApiLevel)) continue;
            destination$iv$iv222.add(element$iv$iv);
        }
        List bestApiLevelMatches = (List)destination$iv$iv222;
        if (bestApiLevelMatches.size() == 1) {
            return (PrebuiltLibrary)((Pair)CollectionsKt.single(bestApiLevelMatches)).getFirst();
        }
        $this$filter$iv22 = bestApiLevelMatches;
        $i$f$filter = false;
        boolean $this$filter$iv22 = !$this$filter$iv22.isEmpty();
        $i$f$filter = false;
        boolean $this$filterTo$iv$iv22 = false;
        if (_Assertions.ENABLED && !$this$filter$iv22) {
            boolean destination$iv$iv222 = false;
            String destination$iv$iv222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)destination$iv$iv222));
        }
        Iterable $this$minByOrNull$iv = bestApiLevelMatches;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = minElem$iv;
            } else {
                Pair it5 = (Pair)minElem$iv;
                boolean bl15 = false;
                int minValue$iv = ((Android)it5.getSecond()).getNdkMajorVersion();
                do {
                    Object e$iv = iterator$iv2.next();
                    Pair it6 = (Pair)e$iv;
                    $i$a$-minByOrNull-Android$findBestMatch$minNdkVersion$1 = false;
                    int v$iv = ((Android)it6.getSecond()).getNdkMajorVersion();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v2);
        int minNdkVersion = ((Android)((Pair)v2).getSecond()).ndkMajorVersion;
        Iterable $this$maxByOrNull$iv2 = bestApiLevelMatches;
        boolean $i$f$maxByOrNull2 = false;
        Iterator iterator$iv3 = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv3.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv2 = iterator$iv3.next();
            if (!iterator$iv3.hasNext()) {
                v3 = maxElem$iv2;
            } else {
                Pair it7 = (Pair)maxElem$iv2;
                boolean bl16 = false;
                int maxValue$iv = ((Android)it7.getSecond()).getNdkMajorVersion();
                do {
                    Object e$iv = iterator$iv3.next();
                    Pair it8 = (Pair)e$iv;
                    $i$a$-maxByOrNull-Android$findBestMatch$maxNdkVersion$1 = false;
                    int v$iv = ((Android)it8.getSecond()).getNdkMajorVersion();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv2 = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv3.hasNext());
                v3 = maxElem$iv2;
            }
        }
        Intrinsics.checkNotNull(v3);
        int maxNdkVersion = ((Android)((Pair)v3).getSecond()).ndkMajorVersion;
        int clamped = RangesKt.coerceIn(this.ndkMajorVersion, minNdkVersion, maxNdkVersion);
        Iterable $this$filter$iv = bestApiLevelMatches;
        boolean $i$f$filter2 = false;
        Iterable maxValue$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair $dstr$_u24__u24$reqs = (Pair)element$iv$iv;
            boolean bl17 = false;
            Android reqs = (Android)$dstr$_u24__u24$reqs.component2();
            if (!(reqs.getNdkMajorVersion() == clamped)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List ndkVersionMatches = (List)destination$iv$iv3;
        if (ndkVersionMatches.isEmpty()) {
            throw new RuntimeException(moduleName + " contains a library per NDK version but no match was found for " + this.ndkMajorVersion);
        }
        if (ndkVersionMatches.size() == 1) {
            return (PrebuiltLibrary)((Pair)CollectionsKt.single(ndkVersionMatches)).getFirst();
        }
        String redundantLibsStr2 = CollectionsKt.joinToString$default(ndkVersionMatches, "\n", null, null, 0, null, findBestMatch.redundantLibsStr.1.INSTANCE, 30, null);
        throw new RuntimeException("Unable to resolve a single library match for " + moduleName + ". The following libraries are redundant:\n" + redundantLibsStr2);
    }

    public static final /* synthetic */ int access$getOriginalApi$p(Android $this) {
        return $this.originalApi;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/google/prefab/api/Android$Abi;", "", "targetArchAbi", "", "triple", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getTargetArchAbi", "()Ljava/lang/String;", "getTriple", "Arm32", "Arm64", "X86", "X86_64", "Companion", "api"})
    public static final class Abi
    extends Enum<Abi> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String targetArchAbi;
        @NotNull
        private final String triple;
        public static final /* enum */ Abi Arm32;
        public static final /* enum */ Abi Arm64;
        public static final /* enum */ Abi X86;
        public static final /* enum */ Abi X86_64;
        private static final /* synthetic */ Abi[] $VALUES;

        private Abi(String targetArchAbi, String triple2) {
            this.targetArchAbi = targetArchAbi;
            this.triple = triple2;
        }

        @NotNull
        public final String getTargetArchAbi() {
            return this.targetArchAbi;
        }

        @NotNull
        public final String getTriple() {
            return this.triple;
        }

        public static Abi[] values() {
            return (Abi[])$VALUES.clone();
        }

        public static Abi valueOf(String value) {
            return Enum.valueOf(Abi.class, value);
        }

        static {
            Arm32 = new Abi("armeabi-v7a", "arm-linux-androideabi");
            Arm64 = new Abi("arm64-v8a", "aarch64-linux-android");
            X86 = new Abi("x86", "i686-linux-android");
            X86_64 = new Abi("x86_64", "x86_64-linux-android");
            $VALUES = abiArray = new Abi[]{Abi.Arm32, Abi.Arm64, Abi.X86, Abi.X86_64};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/prefab/api/Android$Abi$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/Android$Abi;", "str", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Abi fromString(@NotNull String str) {
                Abi abi;
                block2: {
                    Abi abi2;
                    Intrinsics.checkNotNullParameter(str, "str");
                    Abi[] abiArray = Abi.values();
                    boolean bl = false;
                    Abi[] abiArray2 = abiArray;
                    boolean bl2 = false;
                    Abi[] abiArray3 = abiArray2;
                    int n = abiArray3.length;
                    for (int i = 0; i < n; ++i) {
                        Abi abi3;
                        Abi it = abi3 = abiArray3[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getTargetArchAbi(), str)) continue;
                        abi2 = abi3;
                        break block2;
                    }
                    abi2 = abi = null;
                }
                if (abi == null) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown ABI: ", str));
                }
                return abi;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0016\u0017B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0018"}, d2={"Lcom/google/prefab/api/Android$Stl;", "", "stlName", "", "family", "Lcom/google/prefab/api/Android$Stl$Family;", "isShared", "", "(Ljava/lang/String;ILjava/lang/String;Lcom/google/prefab/api/Android$Stl$Family;Z)V", "getFamily", "()Lcom/google/prefab/api/Android$Stl$Family;", "()Z", "getStlName", "()Ljava/lang/String;", "CxxShared", "CxxStatic", "GnustlShared", "GnustlStatic", "None", "StlportShared", "StlportStatic", "System", "Companion", "Family", "api"})
    public static final class Stl
    extends Enum<Stl> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String stlName;
        @NotNull
        private final Family family;
        private final boolean isShared;
        public static final /* enum */ Stl CxxShared;
        public static final /* enum */ Stl CxxStatic;
        public static final /* enum */ Stl GnustlShared;
        public static final /* enum */ Stl GnustlStatic;
        public static final /* enum */ Stl None;
        public static final /* enum */ Stl StlportShared;
        public static final /* enum */ Stl StlportStatic;
        public static final /* enum */ Stl System;
        private static final /* synthetic */ Stl[] $VALUES;

        private Stl(String stlName, Family family, boolean isShared) {
            this.stlName = stlName;
            this.family = family;
            this.isShared = isShared;
        }

        @NotNull
        public final String getStlName() {
            return this.stlName;
        }

        @NotNull
        public final Family getFamily() {
            return this.family;
        }

        public final boolean isShared() {
            return this.isShared;
        }

        public static Stl[] values() {
            return (Stl[])$VALUES.clone();
        }

        public static Stl valueOf(String value) {
            return Enum.valueOf(Stl.class, value);
        }

        static {
            CxxShared = new Stl("c++_shared", Family.Cxx, true);
            CxxStatic = new Stl("c++_static", Family.Cxx, false);
            GnustlShared = new Stl("gnustl_shared", Family.Gnustl, true);
            GnustlStatic = new Stl("gnustl_static", Family.Gnustl, false);
            None = new Stl("none", Family.None, false);
            StlportShared = new Stl("stlport_shared", Family.Stlport, true);
            StlportStatic = new Stl("stlport_static", Family.Stlport, false);
            System = new Stl("system", Family.None, true);
            $VALUES = stlArray = new Stl[]{Stl.CxxShared, Stl.CxxStatic, Stl.GnustlShared, Stl.GnustlStatic, Stl.None, Stl.StlportShared, Stl.StlportStatic, Stl.System};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/google/prefab/api/Android$Stl$Family;", "", "familyName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getFamilyName", "()Ljava/lang/String;", "Cxx", "Gnustl", "None", "Stlport", "api"})
        public static final class Family
        extends Enum<Family> {
            @NotNull
            private final String familyName;
            public static final /* enum */ Family Cxx = new Family("libc++");
            public static final /* enum */ Family Gnustl = new Family("libstdc++");
            public static final /* enum */ Family None = new Family("no STL");
            public static final /* enum */ Family Stlport = new Family("STLport");
            private static final /* synthetic */ Family[] $VALUES;

            private Family(String familyName) {
                this.familyName = familyName;
            }

            @NotNull
            public final String getFamilyName() {
                return this.familyName;
            }

            public static Family[] values() {
                return (Family[])$VALUES.clone();
            }

            public static Family valueOf(String value) {
                return Enum.valueOf(Family.class, value);
            }

            static {
                $VALUES = familyArray = new Family[]{Family.Cxx, Family.Gnustl, Family.None, Family.Stlport};
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/prefab/api/Android$Stl$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/Android$Stl;", "str", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Stl fromString(@NotNull String str) {
                Stl stl;
                block2: {
                    Stl stl2;
                    Intrinsics.checkNotNullParameter(str, "str");
                    Stl[] stlArray = Stl.values();
                    boolean bl = false;
                    Stl[] stlArray2 = stlArray;
                    boolean bl2 = false;
                    Stl[] stlArray3 = stlArray2;
                    int n = stlArray3.length;
                    for (int i = 0; i < n; ++i) {
                        Stl stl3;
                        Stl it = stl3 = stlArray3[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getStlName(), str)) continue;
                        stl2 = stl3;
                        break block2;
                    }
                    stl2 = stl = null;
                }
                if (stl == null) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown STL: ", str));
                }
                return stl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/google/prefab/api/Android$Companion;", "Lcom/google/prefab/api/PlatformFactoryInterface;", "()V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "libraryNameFor", "module", "Lcom/google/prefab/api/Module;", "prebuiltLibraryFromDirectory", "Lcom/google/prefab/api/PrebuiltLibrary;", "directory", "Ljava/nio/file/Path;", "loadSchemaVersion", "Lcom/google/prefab/api/SchemaVersion;", "api"})
    public static final class Companion
    implements PlatformFactoryInterface {
        private Companion() {
        }

        @Override
        @NotNull
        public String getIdentifier() {
            return identifier;
        }

        @Override
        @NotNull
        public PrebuiltLibrary prebuiltLibraryFromDirectory(@NotNull Path directory, @NotNull Module module, @NotNull SchemaVersion loadSchemaVersion) {
            Intrinsics.checkNotNullParameter(directory, "directory");
            Intrinsics.checkNotNullParameter(module, "module");
            Intrinsics.checkNotNullParameter((Object)loadSchemaVersion, "loadSchemaVersion");
            AndroidAbiMetadataV2 metadata = AndroidAbiMetadata.Companion.loadAndMigrate(loadSchemaVersion, directory, module);
            Android platformData = new Android(Abi.Companion.fromString(metadata.getAbi()), metadata.getApi(), Stl.Companion.fromString(metadata.getStl()), metadata.getNdk());
            String name = this.libraryNameFor(module);
            String ext = metadata.isStatic() ? "a" : "so";
            Path path2 = directory.resolve(name + '.' + ext);
            Intrinsics.checkNotNullExpressionValue(path2, "path");
            return new PrebuiltLibrary(path2, module, platformData);
        }

        @Override
        @NotNull
        public String libraryNameFor(@NotNull Module module) {
            String string;
            Intrinsics.checkNotNullParameter(module, "module");
            String string2 = module.getMetadata$api().getAndroid().getLibraryName();
            return string2 == null ? ((string = module.getMetadata$api().getLibraryName()) == null ? Intrinsics.stringPlus("lib", module.getName()) : string) : string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Abi.values().length];
            nArray[Abi.Arm32.ordinal()] = 1;
            nArray[Abi.X86.ordinal()] = 2;
            nArray[Abi.Arm64.ordinal()] = 3;
            nArray[Abi.X86_64.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

