/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.AffineExpression;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpSatHelper;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.util.Domain;

public class IntVar
implements LinearArgument {
    protected final CpModelProto.Builder modelBuilder;
    protected final int variableIndex;
    protected final IntegerVariableProto.Builder varBuilder;

    IntVar(CpModelProto.Builder builder, Domain domain, String name) {
        this.modelBuilder = builder;
        this.variableIndex = this.modelBuilder.getVariablesCount();
        this.varBuilder = this.modelBuilder.addVariablesBuilder();
        this.varBuilder.setName(name);
        for (long b : domain.flattenedIntervals()) {
            this.varBuilder.addDomain(b);
        }
    }

    IntVar(CpModelProto.Builder builder, int index) {
        this.modelBuilder = builder;
        this.variableIndex = index;
        this.varBuilder = this.modelBuilder.getVariablesBuilder(index);
    }

    public String getName() {
        return this.varBuilder.getName();
    }

    public int getIndex() {
        return this.variableIndex;
    }

    public IntegerVariableProto.Builder getBuilder() {
        return this.varBuilder;
    }

    @Override
    public LinearExpr build() {
        return new AffineExpression(this.variableIndex, 1L, 0L);
    }

    public String displayBounds() {
        String out = "";
        for (int i = 0; i < this.varBuilder.getDomainCount(); i += 2) {
            if (i != 0) {
                out = out + ", ";
            }
            out = this.varBuilder.getDomain(i) == this.varBuilder.getDomain(i + 1) ? out + String.format("%d", this.varBuilder.getDomain(i)) : out + String.format("%d..%d", this.varBuilder.getDomain(i), this.varBuilder.getDomain(i + 1));
        }
        return out;
    }

    public Domain getDomain() {
        return CpSatHelper.variableDomain(this.varBuilder.build());
    }

    public String toString() {
        if (this.varBuilder.getName().isEmpty()) {
            if (this.varBuilder.getDomainCount() == 2 && this.varBuilder.getDomain(0) == this.varBuilder.getDomain(1)) {
                return String.format("%d", this.varBuilder.getDomain(0));
            }
            return String.format("var_%d(%s)", this.getIndex(), this.displayBounds());
        }
        return String.format("%s(%s)", this.getName(), this.displayBounds());
    }
}

